/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSConditionalSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItemObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCSConditionalSubItem
extends SimpleCSObject
implements ISimpleCSConditionalSubItem {
    private String fCondition;
    private ArrayList fSubItems;
    private static final long serialVersionUID = 1L;

    public SimpleCSConditionalSubItem(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public String getCondition() {
        return this.fCondition;
    }

    public ISimpleCSSubItem[] getSubItems() {
        return (ISimpleCSSubItem[])this.fSubItems.toArray(new ISimpleCSSubItemObject[this.fSubItems.size()]);
    }

    public void setCondition(String condition) {
        String old = this.fCondition;
        this.fCondition = condition;
        if (this.isEditable()) {
            this.firePropertyChanged("condition", old, this.fCondition);
        }
    }

    public void parse(Element element) {
        this.fCondition = element.getAttribute("condition");
        NodeList children = element.getChildNodes();
        ISimpleCSModelFactory factory = this.getModel().getFactory();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                Element childElement = (Element)child;
                if (name.equals("subitem")) {
                    ISimpleCSSubItem subitem = factory.createSimpleCSSubItem(this);
                    this.fSubItems.add(subitem);
                    subitem.parse(childElement);
                }
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            buffer.append("conditional-subitem");
            if (this.fCondition != null && this.fCondition.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("condition", this.fCondition));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            Iterator iterator = this.fSubItems.iterator();
            while (iterator.hasNext()) {
                ISimpleCSSubItem subitem = (ISimpleCSSubItem)iterator.next();
                subitem.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "conditional-subitem", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fCondition = null;
        this.fSubItems = new ArrayList();
    }

    public int getType() {
        return 3;
    }

    public String getName() {
        return "conditional-subitem";
    }

    public List getChildren() {
        ArrayList list = new ArrayList();
        if (this.fSubItems.size() > 0) {
            list.addAll(this.fSubItems);
        }
        return list;
    }

    public void addSubItem(ISimpleCSSubItem subitem) {
        this.fSubItems.add(subitem);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 1);
        }
    }

    public void removeSubItem(ISimpleCSSubItem subitem) {
        this.fSubItems.remove(subitem);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 2);
        }
    }
}

