/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.core.cheatsheet.comp.CompCSObject;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSDataObject;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.core.util.CheatSheetUtil;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class CompCSDataObject
extends CompCSObject
implements ICompCSDataObject {
    private String fFieldContent;

    public CompCSDataObject(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
    }

    public List getChildren() {
        return new ArrayList();
    }

    public abstract String getElement();

    public String getName() {
        return this.fFieldContent;
    }

    public abstract int getType();

    protected void parseContent(Element element) {
        this.fFieldContent = CheatSheetUtil.parseElementText(element).trim();
    }

    protected void parseAttributes(Element element) {
    }

    protected void parseElement(Element element) {
    }

    protected void parseText(Text text) {
    }

    public void reset() {
        this.fFieldContent = null;
    }

    protected void writeAttributes(StringBuffer buffer) {
    }

    protected void writeElements(String indent, PrintWriter writer) {
        String newIndent = String.valueOf(indent) + "   ";
        if (this.fFieldContent != null && this.fFieldContent.length() > 0) {
            writer.write(String.valueOf(newIndent) + PDETextHelper.translateWriteText(this.fFieldContent.trim(), DEFAULT_TAG_EXCEPTIONS, DEFAULT_SUBSTITUTE_CHARS) + "\n");
        }
    }

    public String getFieldContent() {
        return this.fFieldContent;
    }

    public void setFieldContent(String content) {
        String old = this.fFieldContent;
        this.fFieldContent = content;
        if (this.isEditable()) {
            this.firePropertyChanged(this.getElement(), old, this.fFieldContent);
        }
    }
}

