/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDEManager;

public class PDEStateHelper {
    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                BundleDescription[] toAdd = PDEStateHelper.getImportedBundles(fragments[i]);
                int j = 0;
                while (j < toAdd.length) {
                    if (!list.contains(toAdd[j])) {
                        list.add(toAdd[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[list.size()];
        return list.toArray(result);
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        int i = 0;
        while (i < packages.length) {
            if (!root.getLocation().equals(packages[i].getExporter().getLocation()) && !resolvedImports.contains(packages[i].getExporter())) {
                resolvedImports.add(packages[i].getExporter());
            }
            ++i;
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static IPluginExtensionPoint findExtensionPoint(String fullID) {
        if (fullID == null || fullID.length() == 0) {
            return null;
        }
        int lastDot = fullID.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String pluginID = fullID.substring(0, lastDot);
        IPluginModelBase model = PluginRegistry.findModel(pluginID);
        if (model == null) {
            return PDEManager.findExtensionPoint(fullID);
        }
        String pointID = fullID.substring(lastDot + 1);
        IPluginExtensionPoint[] points = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            IPluginExtensionPoint point = points[i];
            if (point.getId().equals(pointID)) {
                return point;
            }
            ++i;
        }
        IFragmentModel[] fragments = PDEManager.findFragmentsFor(model);
        int i2 = 0;
        while (i2 < fragments.length) {
            points = fragments[i2].getPluginBase().getExtensionPoints();
            int j = 0;
            while (j < points.length) {
                if (points[j].getId().equals(pointID)) {
                    return points[j];
                }
                ++j;
            }
            ++i2;
        }
        return PDEManager.findExtensionPoint(fullID);
    }
}

