/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;

public abstract class AbstractModelManager {
    private ArrayList fListeners = new ArrayList();

    public synchronized void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public synchronized void addModelProviderListener(IModelProviderListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void fireModelProviderEvent(IModelProviderEvent event) {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            ((IModelProviderListener)iter.next()).modelsChanged(event);
        }
    }

    public void shutdown() {
        this.removeListeners();
    }

    protected void removeListeners() {
        if (this.fListeners.size() > 0) {
            this.fListeners.clear();
        }
    }
}

