/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitAddLibraryProposal;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JUnitQuickFixProcessor
implements IQuickFixProcessor {
    private static final int JUNIT3 = 1;
    private static final int JUNIT4 = 2;
    private static final HashSet ASSERT_METHOD_NAMES = new HashSet();

    public JUnitQuickFixProcessor() {
        ASSERT_METHOD_NAMES.add("fail");
        ASSERT_METHOD_NAMES.add("assertTrue");
        ASSERT_METHOD_NAMES.add("assertFalse");
        ASSERT_METHOD_NAMES.add("assertEquals");
        ASSERT_METHOD_NAMES.add("assertNotNull");
        ASSERT_METHOD_NAMES.add("assertNull");
        ASSERT_METHOD_NAMES.add("assertSame");
        ASSERT_METHOD_NAMES.add("assertNotSame");
        ASSERT_METHOD_NAMES.add("failNotEquals");
        ASSERT_METHOD_NAMES.add("failSame");
        ASSERT_METHOD_NAMES.add("failNotSame");
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 0x1000002 || problemId == 268435846 || problemId == 0x4000064;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) {
        ArrayList res = null;
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            int id = problem.getProblemId();
            if (0x1000002 == id || 268435846 == id) {
                res = this.getAddJUnitToBuildPathProposals(context, problem, res);
            } else if (id == 0x4000064) {
                res = this.getAddAssertImportProposals(context, problem, res);
            }
            ++i;
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        return res.toArray(new IJavaCompletionProposal[res.size()]);
    }

    private ArrayList getAddAssertImportProposals(IInvocationContext context, IProblemLocation problem, ArrayList proposals) {
        String methodName;
        String[] args = problem.getProblemArguments();
        if (args.length > 1 && ASSERT_METHOD_NAMES.contains(methodName = args[1]) && this.isInsideJUnit4Test(context)) {
            if (proposals == null) {
                proposals = new ArrayList<AddAssertProposal>();
            }
            proposals.add(new AddAssertProposal(context.getASTRoot(), methodName, 9));
            proposals.add(new AddAssertProposal(context.getASTRoot(), "*", 10));
        }
        return proposals;
    }

    private ArrayList getAddJUnitToBuildPathProposals(IInvocationContext context, IProblemLocation location, ArrayList proposals) {
        try {
            ICompilationUnit unit = context.getCompilationUnit();
            int res = 0;
            String s = unit.getBuffer().getText(location.getOffset(), location.getLength());
            if (s.equals("org.junit")) {
                res = 2;
            } else if (s.equals("TestCase") || s.equals("TestSuite") || s.equals("junit")) {
                res = 1;
            } else if (s.equals("Test")) {
                ASTNode node = location.getCoveredNode(context.getASTRoot());
                res = node != null && node.getLocationInParent() == MarkerAnnotation.TYPE_NAME_PROPERTY ? 2 : 3;
            } else if (s.equals("RunWith")) {
                res = 2;
            }
            if (res != 0) {
                IJavaProject javaProject = unit.getJavaProject();
                if (JUnitStubUtility.is50OrHigher(javaProject) && (res & 2) != 0) {
                    if (proposals == null) {
                        proposals = new ArrayList<JUnitAddLibraryProposal>();
                    }
                    proposals.add(new JUnitAddLibraryProposal(true, context, 10));
                }
                if ((res & 1) != 0) {
                    if (proposals == null) {
                        proposals = new ArrayList();
                    }
                    proposals.add(new JUnitAddLibraryProposal(false, context, 8));
                }
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e.getStatus());
        }
        return proposals;
    }

    private boolean isInsideJUnit4Test(IInvocationContext context) {
        IMethodBinding binding;
        if (!JUnitStubUtility.is50OrHigher(context.getCompilationUnit().getJavaProject())) {
            return false;
        }
        ASTNode node = context.getCoveringNode();
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        if (node instanceof MethodDeclaration && (binding = ((MethodDeclaration)node).resolveBinding()) != null) {
            IAnnotationBinding[] annotations = binding.getAnnotations();
            int i = 0;
            while (i < annotations.length) {
                ITypeBinding annotationType = annotations[i].getAnnotationType();
                if (annotationType != null && "org.junit.Test".equals(annotationType.getQualifiedName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static class AddAssertProposal
    implements IJavaCompletionProposal {
        private final CompilationUnit fAstRoot;
        private final String fMethodName;
        private final int fRelevance;

        public AddAssertProposal(CompilationUnit astRoot, String methodName, int relevance) {
            this.fAstRoot = astRoot;
            this.fMethodName = methodName;
            this.fRelevance = relevance;
        }

        public int getRelevance() {
            return this.fRelevance;
        }

        public void apply(IDocument document) {
            try {
                ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.fAstRoot, (boolean)true);
                rewrite.addStaticImport("org.junit.Assert", this.fMethodName, true);
                TextEdit edit = rewrite.rewriteImports(null);
                edit.apply(document);
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {}
        }

        public String getAdditionalProposalInfo() {
            return Messages.format(JUnitMessages.JUnitQuickFixProcessor_add_assert_info, this.fMethodName);
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return Messages.format(JUnitMessages.JUnitQuickFixProcessor_add_assert_description, this.fMethodName);
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.imp_obj.gif");
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }
}

