/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.console;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileLink
implements IConsoleHyperlink {
    private IFile fFile;
    private int fFileOffset;
    private int fFileLength;
    private int fFileLineNumber;
    private String fEditorId;
    static /* synthetic */ Class class$0;

    public FileLink(IFile file, String editorId, int fileOffset, int fileLength, int fileLineNumber) {
        this.fFile = file;
        this.fFileOffset = fileOffset;
        this.fFileLength = fileLength;
        this.fFileLineNumber = fileLineNumber;
        this.fEditorId = editorId;
    }

    public void linkActivated() {
        block14: {
            IWorkbenchPage page;
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                try {
                    IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(this.fFile), this.getEditorId(), false);
                    if (this.fFileLineNumber <= 0) break block14;
                    ITextEditor textEditor = null;
                    if (editorPart instanceof ITextEditor) {
                        textEditor = (ITextEditor)editorPart;
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        textEditor = (ITextEditor)editorPart.getAdapter((Class)clazz);
                    }
                    if (textEditor == null) break block14;
                    IEditorInput input = editorPart.getEditorInput();
                    if (this.fFileOffset < 0) {
                        IDocumentProvider provider = textEditor.getDocumentProvider();
                        try {
                            provider.connect((Object)input);
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                            return;
                        }
                        IDocument document = provider.getDocument((Object)input);
                        try {
                            IRegion region = document.getLineInformation(this.fFileLineNumber - 1);
                            this.fFileOffset = region.getOffset();
                            this.fFileLength = region.getLength();
                        }
                        catch (BadLocationException e) {
                            DebugUIPlugin.log(e);
                        }
                        provider.disconnect((Object)input);
                    }
                    if (this.fFileOffset >= 0 && this.fFileLength >= 0) {
                        textEditor.selectAndReveal(this.fFileOffset, this.fFileLength);
                    }
                }
                catch (PartInitException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    private String getEditorId() {
        if (this.fEditorId == null) {
            IWorkbench workbench = DebugUIPlugin.getDefault().getWorkbench();
            IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(this.fFile.getName(), this.getFileContentType());
            if (desc == null) {
                desc = workbench.getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
            }
            this.fEditorId = desc.getId();
        }
        return this.fEditorId;
    }

    private IContentType getFileContentType() {
        try {
            IContentDescription description = this.fFile.getContentDescription();
            if (description != null) {
                return description.getContentType();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

