/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class SelectFavoritesDialog
extends AbstractDebugCheckboxSelectionDialog {
    private LaunchHistory fHistory;
    private List fCurrentFavoriteSet;

    public SelectFavoritesDialog(Shell parentShell, LaunchHistory history, List favorites) {
        super(parentShell);
        this.fHistory = history;
        this.fCurrentFavoriteSet = favorites;
        this.setTitle(MessageFormat.format((String)LaunchConfigurationsMessages.FavoritesDialog_0, (Object[])new String[]{this.getModeLabel()}));
    }

    private String getModeLabel() {
        return DebugUIPlugin.removeAccelerators(this.fHistory.getLaunchGroup().getLabel());
    }

    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.SELECT_FAVORITESS_DIALOG";
    }

    protected Object getViewerInput() {
        return this.fHistory.getLaunchGroup().getMode();
    }

    protected IContentProvider getContentProvider() {
        return new LaunchConfigurationContentProvider();
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_favorites_dialog";
    }

    protected String getViewerLabel() {
        return LaunchConfigurationsMessages.FavoritesDialog_7;
    }

    protected void addCustomFooterControls(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768);
        GridData gd = (GridData)comp.getLayoutData();
        gd.horizontalAlignment = 0x1000008;
        Button button = SWTFactory.createPushButton(comp, LaunchConfigurationsMessages.SelectFavoritesDialog_0, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectFavoritesDialog.this.getCheckBoxTableViewer().setAllChecked(true);
                SelectFavoritesDialog.this.getOkButton().setEnabled(true);
            }
        });
        button = SWTFactory.createPushButton(comp, LaunchConfigurationsMessages.SelectFavoritesDialog_1, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectFavoritesDialog.this.getCheckBoxTableViewer().setAllChecked(false);
                SelectFavoritesDialog.this.getOkButton().setEnabled(false);
            }
        });
    }

    protected class LaunchConfigurationContentProvider
    implements IStructuredContentProvider {
        protected LaunchConfigurationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchConfiguration[] all = null;
            try {
                all = LaunchConfigurationManager.filterConfigs(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                return new ILaunchConfiguration[0];
            }
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>(all.length);
            LaunchGroupFilter filter = new LaunchGroupFilter(SelectFavoritesDialog.this.fHistory.getLaunchGroup());
            int i = 0;
            while (i < all.length) {
                if (filter.select(null, null, all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
            list.removeAll(SelectFavoritesDialog.this.fCurrentFavoriteSet);
            Object[] objs = list.toArray();
            new WorkbenchViewerComparator().sort((Viewer)SelectFavoritesDialog.this.getCheckBoxTableViewer(), objs);
            return objs;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

