/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contextlaunching;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contextlaunching.ContextMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutSelectionDialog;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public final class ContextRunner {
    private static ContextRunner fgInstance = null;

    public static ContextRunner getDefault() {
        if (fgInstance == null) {
            fgInstance = new ContextRunner();
        }
        return fgInstance;
    }

    public void launch(ILaunchGroup group) {
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        if (resource != null) {
            this.selectAndLaunch(resource, group);
            return;
        }
        if (!this.launchLast(group)) {
            List shortcuts = this.getLaunchShortcutsForEmptySelection();
            if (!shortcuts.isEmpty()) {
                this.showShortcutSelectionDialog(resource, shortcuts, group.getMode());
            } else {
                MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)ContextMessages.ContextRunner_7);
            }
        }
    }

    protected boolean launchLast(ILaunchGroup group) {
        ILaunchConfiguration config = null;
        if (group != null) {
            config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
        }
        if (config != null) {
            this.launch(config, group.getMode());
            return true;
        }
        return false;
    }

    public List getLaunchShortcutsForEmptySelection() {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        List sc = this.getLaunchConfigurationManager().getLaunchShortcuts();
        ArrayList ctxt = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, ctxt);
        context.addVariable("selection", ctxt);
        LaunchShortcutExtension ext = null;
        Iterator iter = sc.iterator();
        while (iter.hasNext()) {
            ext = (LaunchShortcutExtension)iter.next();
            try {
                if (!ext.evalEnablementExpression((IEvaluationContext)context, ext.getContextualLaunchEnablementExpression()) || WorkbenchActivityHelper.filterItem((Object)ext) || list.contains(ext)) continue;
                list.add(ext);
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    protected void selectAndLaunch(IResource resource, ILaunchGroup group) {
        if (group == null) {
            return;
        }
        ILaunchConfiguration config = this.getLaunchConfigurationManager().isSharedConfig(resource);
        if (config != null) {
            this.launch(config, group.getMode());
            return;
        }
        List configs = this.getLaunchConfigurationManager().getApplicableLaunchConfigurations(resource);
        int csize = (configs = this.getConfigsApplicableToMode(configs, group.getMode())).size();
        if (csize == 1) {
            this.launch((ILaunchConfiguration)configs.get(0), group.getMode());
            return;
        }
        if (csize < 1) {
            List exts = this.getLaunchConfigurationManager().getLaunchShortcuts(resource);
            List modeSpecificExts = this.getLaunchConfigurationManager().getShortcutsSupportingMode(exts, group.getMode());
            int esize = modeSpecificExts.size();
            if (esize == 1) {
                LaunchShortcutExtension ext = (LaunchShortcutExtension)modeSpecificExts.get(0);
                ext.launch((ISelection)new StructuredSelection((Object)resource), group.getMode());
                return;
            }
            if (esize > 1) {
                this.showShortcutSelectionDialog(resource, modeSpecificExts, group.getMode());
                return;
            }
            if (esize < 1) {
                if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchLastIfNotLaunchable")) {
                    if (!this.launchLast(group)) {
                        MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)ContextMessages.ContextRunner_7);
                    }
                    return;
                }
                if (exts.size() > 0) {
                    ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(group.getMode());
                    if (launchMode == null) {
                        DebugUIPlugin.logErrorMessage("Unsupported launch mode: " + group.getMode());
                    } else {
                        String label = launchMode.getLabel();
                        String modeLabel = DebugUIPlugin.removeAccelerators(label);
                        MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)MessageFormat.format((String)ContextMessages.ContextRunner_1, (Object[])new String[]{modeLabel}), (String)MessageFormat.format((String)ContextMessages.ContextRunner_2, (Object[])new String[]{modeLabel.toLowerCase()}));
                    }
                } else {
                    IProject project = resource.getProject();
                    if (project != null && !project.equals((Object)resource)) {
                        this.selectAndLaunch((IResource)project, group);
                    } else {
                        String msg = ContextMessages.ContextRunner_7;
                        if (!resource.isAccessible()) {
                            msg = MessageFormat.format((String)ContextMessages.ContextRunner_13, (Object[])new String[]{resource.getName()});
                        }
                        MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)msg);
                    }
                }
            }
        } else if (csize > 1) {
            config = this.getLaunchConfigurationManager().getMRUConfiguration(configs, group, resource);
            if (config != null) {
                this.launch(config, group.getMode());
            } else {
                this.showConfigurationSelectionDialog(configs, group.getMode());
            }
        }
    }

    private void launch(ILaunchConfiguration configuration, String mode) {
        if (this.validateMode(configuration, mode)) {
            DebugUITools.launch(configuration, mode);
        }
    }

    private boolean validateMode(ILaunchConfiguration configuration, String mode) {
        try {
            if (configuration.getModes().isEmpty() && !configuration.supportsMode(mode)) {
                ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
                if (launchMode == null) {
                    DebugUIPlugin.logErrorMessage("Unsupported launch mode: " + mode);
                } else {
                    String label = launchMode.getLabel();
                    String modeLabel = DebugUIPlugin.removeAccelerators(label);
                    MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)MessageFormat.format((String)ContextMessages.ContextRunner_1, (Object[])new String[]{modeLabel}), (String)MessageFormat.format((String)ContextMessages.ContextRunner_3, (Object[])new String[]{configuration.getName(), modeLabel.toLowerCase()}));
                }
                return false;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
            return false;
        }
        return true;
    }

    protected void showConfigurationSelectionDialog(List configurations, String mode) {
        LaunchConfigurationSelectionDialog lsd = new LaunchConfigurationSelectionDialog(DebugUIPlugin.getShell());
        if (configurations != null) {
            lsd.setInput(configurations);
        }
        if (lsd.open() == 0) {
            ILaunchConfiguration config = (ILaunchConfiguration)lsd.getResult()[0];
            this.launch(config, mode);
        }
    }

    protected void showShortcutSelectionDialog(IResource resource, List shortcuts, String mode) {
        LaunchShortcutExtension method;
        Object[] result;
        LaunchShortcutSelectionDialog dialog = new LaunchShortcutSelectionDialog(resource, mode);
        dialog.setInput(shortcuts);
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && (method = (LaunchShortcutExtension)result[0]) != null) {
            method.launch((ISelection)(resource == null ? new StructuredSelection() : new StructuredSelection((Object)resource)), mode);
        }
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    private List getConfigsApplicableToMode(List configs, String mode) {
        ArrayList applicable = new ArrayList(configs);
        ListIterator iterator = applicable.listIterator();
        while (iterator.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iterator.next();
            try {
                Set modes = config.getModes();
                modes.add(mode);
                if (config.getType().supportsModeCombination(modes)) continue;
                iterator.remove();
            }
            catch (CoreException coreException) {}
        }
        return applicable;
    }
}

