/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.PluginBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PluginsTab
extends AbstractLauncherTab {
    private Image fImage;
    private boolean fShowFeatures = true;
    private Combo fSelectionCombo;
    private PluginBlock fPluginBlock;
    private static final int DEFAULT_SELECTION = 0;
    private static final int CUSTOM_SELECTION = 1;
    private static final int FEATURE_SELECTION = 2;

    public PluginsTab() {
        this(true);
    }

    public PluginsTab(boolean showFeatures) {
        this.fShowFeatures = showFeatures;
        this.fImage = PDEPluginImages.DESC_PLUGINS_FRAGMENTS.createImage();
        this.fPluginBlock = new PluginBlock(this);
    }

    public void dispose() {
        this.fPluginBlock.dispose();
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(PDEUIMessages.PluginsTab_launchWith);
        this.fSelectionCombo = new Combo(composite, 2056);
        this.fSelectionCombo.setItems(new String[]{PDEUIMessages.PluginsTab_allPlugins, PDEUIMessages.PluginsTab_selectedPlugins, PDEUIMessages.PluginsTab_featureMode});
        this.fSelectionCombo.setText(this.fSelectionCombo.getItem(0));
        this.fSelectionCombo.setLayoutData((Object)new GridData(768));
        this.fSelectionCombo.addSelectionListener((SelectionListener)new Listener());
        this.fPluginBlock.createControl(composite, 3, 10);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.launcher_advanced");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int index = 0;
            if (this.fShowFeatures && configuration.getAttribute("usefeatures", false)) {
                index = 2;
            } else if (!configuration.getAttribute("default", true)) {
                index = 1;
            }
            this.fSelectionCombo.setText(this.fSelectionCombo.getItem(index));
            boolean custom = this.fSelectionCombo.getSelectionIndex() == 1;
            this.fPluginBlock.initializeFrom(configuration, custom);
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("default", true);
        if (this.fShowFeatures) {
            configuration.setAttribute("usefeatures", false);
        }
        this.fPluginBlock.setDefaults(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int index = this.fSelectionCombo.getSelectionIndex();
        configuration.setAttribute("default", index == 0);
        if (this.fShowFeatures) {
            configuration.setAttribute("usefeatures", index == 2);
        }
        this.fPluginBlock.performApply(configuration);
    }

    public String getName() {
        return PDEUIMessages.AdvancedLauncherTab_name;
    }

    public Image getImage() {
        return this.fImage;
    }

    public void validateTab() {
        String errorMessage = null;
        if (this.fShowFeatures && this.fSelectionCombo.getSelectionIndex() == 2) {
            IPath workspacePath = PDEPlugin.getWorkspace().getRoot().getLocation();
            IPath featurePath = workspacePath.removeLastSegments(1).append("features");
            if (!workspacePath.lastSegment().equalsIgnoreCase("plugins") || !featurePath.toFile().exists()) {
                errorMessage = PDEUIMessages.AdvancedLauncherTab_error_featureSetup;
            }
        }
        this.setErrorMessage(errorMessage);
    }

    class Listener
    extends SelectionAdapter {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = PluginsTab.this.fSelectionCombo.getSelectionIndex();
            PluginsTab.this.fPluginBlock.enableViewer(index == 1);
            PluginsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

