/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.VMHelper;
import org.osgi.framework.Version;

public class JUnitLaunchConfigurationDelegate
extends org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate {
    private static String[] REQUIRED_PLUGINS = new String[]{"org.junit", "org.eclipse.jdt.junit.runtime", "org.eclipse.pde.junit.runtime"};
    protected File fConfigDir = null;
    private Map fPluginMap;

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        return launcher.getVMRunner(mode);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            return "org.eclipse.equinox.launcher.Main";
        }
        return "org.eclipse.core.launcher.Main";
    }

    private String getTestPluginId(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (model == null) {
            this.abort(NLS.bind((String)PDEUIMessages.JUnitLaunchConfiguration_error_notaplugin, (Object)javaProject.getProject().getName()), null, 0);
        }
        if (model instanceof IFragmentModel) {
            return ((IFragmentModel)model).getFragment().getPluginId();
        }
        return model.getPluginBase().getId();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", code, message, exception));
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArgs) throws CoreException {
        super.collectExecutionArguments(configuration, vmArguments, programArgs);
        programArgs.add("-application");
        String application = null;
        try {
            application = configuration.getAttribute("application", null);
        }
        catch (CoreException coreException) {}
        if (application == null) {
            Version version;
            int major;
            BundleDescription desc;
            IPluginModelBase model = (IPluginModelBase)this.fPluginMap.get("org.eclipse.pde.junit.runtime");
            BundleDescription bundleDescription = desc = model != null ? model.getBundleDescription() : null;
            if (desc != null && (major = (version = desc.getVersion()).getMajor()) >= 3 && version.getMinor() >= 3 && !TargetPlatformHelper.usesNewApplicationModel()) {
                application = "org.eclipse.pde.junit.runtime.legacytestapplication";
            }
        }
        if (application == null) {
            application = "org.eclipse.pde.junit.runtime.uitestapplication";
        }
        programArgs.add(application);
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            String defaultApplication = "org.eclipse.pde.junit.runtime.coretestapplication".equals(application) ? null : TargetPlatform.getDefaultApplication();
            String testApplication = configuration.getAttribute("testApplication", defaultApplication);
            if (testApplication != null) {
                programArgs.add("-testApplication");
                programArgs.add(testApplication);
            }
        }
        String targetWorkspace = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        if (targetWorkspace.length() > 0) {
            programArgs.add("-data");
            programArgs.add(targetWorkspace);
        }
        String productID = LaunchConfigurationHelper.getProductID(configuration);
        LaunchConfigurationHelper.createConfigIniFile(configuration, productID, this.fPluginMap, this.getConfigurationDirectory(configuration));
        String brandingId = LaunchConfigurationHelper.getContributingPlugin(productID);
        TargetPlatform.createPlatformConfiguration((File)this.getConfigurationDirectory(configuration), (IPluginModelBase[])this.fPluginMap.values().toArray(new IPluginModelBase[this.fPluginMap.size()]), brandingId != null ? (IPluginModelBase)this.fPluginMap.get(brandingId) : null);
        TargetPlatformHelper.checkPluginPropertiesConsistency((Map)this.fPluginMap, (File)this.getConfigurationDirectory(configuration));
        programArgs.add("-configuration");
        programArgs.add("file:" + new Path(this.getConfigurationDirectory(configuration).getPath()).addTrailingSeparator().toString());
        programArgs.add("-dev");
        programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.getConfigurationDirectory(configuration).toString()) + "/dev.properties"), (Map)this.fPluginMap));
        IPluginModelBase base = this.findPlugin("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) < 0) {
            programArgs.add("-pdelaunch");
        }
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            String path = String.valueOf(this.getConfigurationDirectory(configuration).getPath()) + '/' + ".options";
            programArgs.add(LaunchArgumentsHelper.getTracingFileArgument(configuration, path));
        }
        String[] userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray(configuration);
        int i = 0;
        while (i < userArgs.length) {
            if (!userArgs[i].equals("-debug") || !programArgs.contains("-debug")) {
                programArgs.add(userArgs[i]);
            }
            ++i;
        }
        if (!configuration.getAttribute("append.args", false)) {
            if (!programArgs.contains("-os")) {
                programArgs.add("-os");
                programArgs.add(TargetPlatform.getOS());
            }
            if (!programArgs.contains("-ws")) {
                programArgs.add("-ws");
                programArgs.add(TargetPlatform.getWS());
            }
            if (!programArgs.contains("-arch")) {
                programArgs.add("-arch");
                programArgs.add(TargetPlatform.getOSArch());
            }
        }
        programArgs.add("-testpluginname");
        programArgs.add(this.getTestPluginId(configuration));
    }

    private IPluginModelBase findPlugin(String id) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null) {
            model = PDECore.getDefault().findPluginInHost(id);
        }
        if (model == null) {
            this.abort(NLS.bind((String)PDEUIMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)id), null, 0);
        }
        return model;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getUserProgramArguments(configuration);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmArgs = LaunchArgumentsHelper.getUserVMArguments(configuration);
        IPluginModelBase base = (IPluginModelBase)LaunchPluginValidator.getPluginsToRun(configuration).get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) >= 0) {
            if (vmArgs.length() > 0 && !vmArgs.endsWith(" ")) {
                vmArgs = vmArgs.concat(" ");
            }
            vmArgs = vmArgs.concat("-Declipse.pde.launch=true");
        }
        return vmArgs;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath(configuration);
        if (classpath == null) {
            this.abort(PDEUIMessages.WorkbenchLauncherConfigurationDelegate_noStartup, null, 0);
        }
        return classpath;
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory(configuration);
    }

    public Map getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap(configuration);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.doSave();
        }
        this.manageLaunch(launch);
    }

    protected File getConfigurationDirectory(ILaunchConfiguration configuration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(configuration);
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects(configuration);
    }

    protected void manageLaunch(ILaunch launch) {
        PDEPlugin.getDefault().getLaunchListener().manage(launch);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fPluginMap = LaunchPluginValidator.getPluginsToRun(configuration);
        int i = 0;
        while (i < REQUIRED_PLUGINS.length) {
            String id = REQUIRED_PLUGINS[i];
            if (!this.fPluginMap.containsKey(id)) {
                this.fPluginMap.put(id, this.findPlugin(id));
            }
            ++i;
        }
        boolean autoValidate = configuration.getAttribute("automaticValidate", false);
        monitor.beginTask("", autoValidate ? 3 : 4);
        if (autoValidate) {
            this.validatePluginDependencies(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        this.validateProjectDependencies(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.clear(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        launch.setAttribute("configLocation", this.getConfigurationDirectory(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    protected void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LaunchConfigurationHelper.synchronizeManifests(configuration, this.getConfigurationDirectory(configuration));
        monitor.done();
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String workspace = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        if (!LauncherUtils.clearWorkspace(configuration, workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
            monitor.setCanceled(true);
            return;
        }
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigurationDirectory(configuration));
        }
    }

    protected void validateProjectDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LauncherUtils.validateProjectDependencies(configuration, monitor);
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        EclipsePluginValidationOperation op = new EclipsePluginValidationOperation(configuration);
        LaunchPluginValidator.runValidationOperation(op, monitor);
    }
}

