/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.provisioner.update;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.IUpdateSiteProvisionerEntry;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.UpdateSiteProvisionerEntry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdateSiteProvisionerDialog
extends StatusDialog {
    private Text fInstallLocationText;
    private Label fInstallLocationLabel;
    private Text fSiteLocationText;
    private Label fSiteLocationLabel;
    private IUpdateSiteProvisionerEntry fEntry;
    private IStatus fOkStatus;
    private IStatus fErrorStatus;
    private String fInstallLocation;
    private String fSiteLocation;

    public UpdateSiteProvisionerDialog(Shell parent, String installLocation, String siteLocation, String title) {
        super(parent);
        this.fInstallLocation = installLocation;
        this.fSiteLocation = siteLocation;
        this.setTitle(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.createEntry(container);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UpdateSiteProvisionerDialog.this.dialogChanged();
            }
        };
        this.fInstallLocationText.addModifyListener(listener);
        this.fSiteLocationText.addModifyListener(listener);
        Dialog.applyDialogFont((Control)container);
        this.dialogChanged();
        return container;
    }

    protected void createEntry(Composite container) {
        this.fSiteLocationLabel = new Label(container, 0);
        this.fSiteLocationLabel.setText(PDEUIMessages.UpdateSiteProvisionerDialog_siteLocation);
        this.fSiteLocationText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fSiteLocationText.setLayoutData((Object)gd);
        if (this.fSiteLocation != null) {
            this.fSiteLocationText.setText(this.fSiteLocation);
        }
        this.fInstallLocationLabel = new Label(container, 0);
        this.fInstallLocationLabel.setText(PDEUIMessages.UpdateSiteProvisionerDialog_installLocation);
        this.fInstallLocationText = new Text(container, 2052);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.fInstallLocationText.setLayoutData((Object)gd);
        if (this.fInstallLocation != null) {
            this.fInstallLocationText.setText(this.fInstallLocation);
        }
        Button fs = new Button(container, 8);
        fs.setText(PDEUIMessages.UpdateSiteProvisionerDialog_fileSystem);
        fs.setLayoutData((Object)new GridData());
        fs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateSiteProvisionerDialog.this.handleBrowseFileSystem();
            }
        });
        SWTUtil.setButtonDimensionHint(fs);
    }

    private IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    private void dialogChanged() {
        IStatus status = null;
        if (this.fInstallLocationText.getText().length() == 0 && this.fSiteLocationText.getText().length() == 0) {
            status = this.getEmptyErrorStatus();
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private IStatus getOKStatus() {
        if (this.fOkStatus == null) {
            this.fOkStatus = new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
        return this.fOkStatus;
    }

    private IStatus getEmptyErrorStatus() {
        if (this.fErrorStatus == null) {
            this.fErrorStatus = this.createErrorStatus(PDEUIMessages.UpdateSiteProvisionerDialog_missBothErrorMessage);
        }
        return this.fErrorStatus;
    }

    protected void handleBrowseFileSystem() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String text = this.fInstallLocationText.getText();
        if (text == null || text.length() == 0) {
            dialog.setFilterPath(TargetPlatform.getLocation());
        } else {
            dialog.setFilterPath(this.fInstallLocationText.getText());
        }
        dialog.setText(PDEUIMessages.BaseBlock_dirSelection);
        dialog.setMessage(PDEUIMessages.BaseBlock_dirChoose);
        String result = dialog.open();
        if (result != null) {
            this.fInstallLocationText.setText(result);
        }
    }

    protected void okPressed() {
        this.fEntry = new UpdateSiteProvisionerEntry(this.fInstallLocationText.getText(), this.fSiteLocationText.getText());
        super.okPressed();
    }

    public IUpdateSiteProvisionerEntry getEntry() {
        return this.fEntry;
    }
}

