/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.provisioner;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProvisionerListSelectionPage
extends WizardSelectionPage {
    private TableViewer fTableViewer = null;
    private Text fTextBox = null;
    private ElementList fElements = null;

    protected ProvisionerListSelectionPage(ElementList elements) {
        super(PDEUIMessages.ProvisionerListSelectionPage_pageName);
        this.fElements = elements;
        this.setTitle(PDEUIMessages.ProvisionerListSelectionPage_title);
        this.setDescription(PDEUIMessages.ProvisionerListSelectionPage_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.ProvisionerListSelectionPage_tableLabel);
        label.setLayoutData((Object)new GridData());
        SashForm sashForm = new SashForm(container, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        this.fTableViewer = new TableViewer((Composite)sashForm, 2048);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)ListUtil.TABLE_LABEL_PROVIDER);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setInput((Object)this.fElements.getChildren());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProvisionerListSelectionPage.this.handleSelection();
            }
        });
        this.fTextBox = new Text((Composite)sashForm, 2120);
        this.fTextBox.setText(new String());
        this.fTextBox.setBackground(this.fTableViewer.getControl().getBackground());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.target_provisioners_preference_page");
        Dialog.applyDialogFont((Control)container);
    }

    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            public IBasePluginWizard createWizard() throws CoreException {
                return (IBasePluginWizard)this.wizardElement.createExecutableExtension();
            }
        };
    }

    protected void setDescriptionText(String text) {
        this.fTextBox.setText(text);
    }

    protected void handleSelection() {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        WizardElement currentWizardSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            currentWizardSelection = (WizardElement)iter.next();
        }
        if (currentWizardSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            this.setPageComplete(false);
            return;
        }
        WizardElement finalSelection = currentWizardSelection;
        this.setSelectedNode(this.createWizardNode(finalSelection));
        this.setDescriptionText(finalSelection.getDescription());
        this.setPageComplete(true);
        this.getContainer().updateButtons();
    }

    public IWizard getSelectedWizard() {
        IWizardNode node = this.getSelectedNode();
        if (node != null) {
            return node.getWizard();
        }
        return null;
    }
}

