/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PluginContentPage
extends ContentPage {
    protected static final int P_CLASS_GROUP = 2;
    private Text fClassText;
    private Button fGenerateClass;
    private Button fUIPlugin;
    private Label fClassLabel;
    private Label fLabel;
    private Button fYesButton;
    private Button fNoButton;
    private static final String S_GENERATE_ACTIVATOR = "generateActivator";
    private static final String S_UI_PLUGIN = "uiPlugin";
    private static final String S_RCP_PLUGIN = "rcpPlugin";
    private ModifyListener classListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (PluginContentPage.this.fInitialized) {
                PluginContentPage.this.fChangedGroups |= 2;
            }
            PluginContentPage.this.validatePage();
        }
    };
    private Group fRCPGroup;

    public PluginContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(PDEUIMessages.ContentPage_title);
        this.setDescription(PDEUIMessages.ContentPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPluginPropertiesGroup(container);
        this.createPluginClassGroup(container);
        this.createRCPGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_project_required_data");
    }

    private void createPluginPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(PDEUIMessages.ContentPage_pGroup);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pid);
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pversion);
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pname);
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pprovider);
        this.fProviderText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        this.fLibraryLabel = new Label((Composite)propertiesGroup, 0);
        this.fLibraryLabel.setText(PDEUIMessages.ProjectStructurePage_library);
        this.fLibraryText = this.createText((Composite)propertiesGroup, this.propertiesListener);
    }

    private void createPluginClassGroup(Composite container) {
        Group classGroup = new Group(container, 0);
        classGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        classGroup.setLayoutData((Object)gd);
        classGroup.setText(PDEUIMessages.ContentPage_pClassGroup);
        IDialogSettings settings = this.getDialogSettings();
        this.fGenerateClass = new Button((Composite)classGroup, 32);
        this.fGenerateClass.setText(PDEUIMessages.ContentPage_generate);
        this.fGenerateClass.setSelection(settings != null ? !settings.getBoolean(S_GENERATE_ACTIVATOR) : true);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fGenerateClass.setLayoutData((Object)gd);
        this.fGenerateClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginContentPage.this.fClassLabel.setEnabled(PluginContentPage.this.fGenerateClass.getSelection());
                PluginContentPage.this.fClassText.setEnabled(PluginContentPage.this.fGenerateClass.getSelection());
                PluginContentPage.this.updateData();
                PluginContentPage.this.validatePage();
            }
        });
        this.fClassLabel = new Label((Composite)classGroup, 0);
        this.fClassLabel.setText(PDEUIMessages.ContentPage_classname);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fClassLabel.setLayoutData((Object)gd);
        this.fClassText = this.createText((Composite)classGroup, this.classListener);
        this.fUIPlugin = new Button((Composite)classGroup, 32);
        this.fUIPlugin.setText(PDEUIMessages.ContentPage_uicontribution);
        this.fUIPlugin.setSelection(settings != null ? !settings.getBoolean(S_UI_PLUGIN) : true);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUIPlugin.setLayoutData((Object)gd);
        this.fUIPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginContentPage.this.updateData();
                PluginContentPage.this.validatePage();
            }
        });
    }

    public void updateData() {
        super.updateData();
        PluginFieldData data = (PluginFieldData)this.fData;
        data.setClassname(this.fClassText.getText().trim());
        data.setUIPlugin(this.fUIPlugin.getSelection());
        data.setDoGenerateClass(this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection());
        data.setRCPApplicationPlugin(!this.fData.isSimple() && !this.isPureOSGi() && this.fYesButton.getSelection());
    }

    private void createRCPGroup(Composite container) {
        this.fRCPGroup = new Group(container, 0);
        this.fRCPGroup.setLayout((Layout)new GridLayout(2, false));
        this.fRCPGroup.setLayoutData((Object)new GridData(768));
        this.fRCPGroup.setText(PDEUIMessages.PluginContentPage_rcpGroup);
        this.createRCPQuestion((Composite)this.fRCPGroup, 2);
    }

    private void createRCPQuestion(Composite parent, int horizontalSpan) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        comp.setLayoutData((Object)gd);
        this.fLabel = new Label(comp, 0);
        this.fLabel.setText(PDEUIMessages.PluginContentPage_appQuestion);
        this.fLabel.setLayoutData((Object)new GridData(768));
        IDialogSettings settings = this.getDialogSettings();
        boolean rcpApp = settings != null ? settings.getBoolean(S_RCP_PLUGIN) : false;
        this.fYesButton = new Button(comp, 16);
        this.fYesButton.setText(PDEUIMessages.PluginContentPage_yes);
        this.fYesButton.setSelection(rcpApp);
        gd = new GridData();
        gd.widthHint = PluginContentPage.getButtonWidthHint(this.fYesButton);
        this.fYesButton.setLayoutData((Object)gd);
        this.fYesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginContentPage.this.updateData();
                PluginContentPage.this.getContainer().updateButtons();
            }
        });
        this.fNoButton = new Button(comp, 16);
        this.fNoButton.setText(PDEUIMessages.PluginContentPage_no);
        this.fNoButton.setSelection(!rcpApp);
        gd = new GridData();
        gd.widthHint = PluginContentPage.getButtonWidthHint(this.fNoButton);
        this.fNoButton.setLayoutData((Object)gd);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
            this.fGenerateClass.setEnabled(!this.fData.isSimple());
            this.fClassLabel.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            this.fClassText.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            boolean wasUIPluginEnabled = this.fUIPlugin.isEnabled();
            this.fUIPlugin.setEnabled(!this.fData.isSimple() && !this.isPureOSGi());
            if (!this.fUIPlugin.isEnabled()) {
                this.fUIPlugin.setSelection(false);
            } else if (!wasUIPluginEnabled) {
                this.fUIPlugin.setSelection(true);
            }
            if ((this.fChangedGroups & 2) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.fClassText.setText(String.valueOf(this.computeId().toLowerCase(Locale.ENGLISH)) + ".Activator");
                this.fChangedGroups = oldfChanged;
            }
            this.fRCPGroup.setVisible(!this.fData.isSimple() && !this.isPureOSGi());
        }
        super.setVisible(visible);
    }

    private boolean isPureOSGi() {
        return ((PluginFieldData)this.fData).getOSGiFramework() != null;
    }

    protected void validatePage() {
        String errorMessage = this.validateProperties();
        if (errorMessage == null && this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection()) {
            IStatus status = JavaConventions.validateJavaTypeName((String)this.fClassText.getText().trim(), (String)PDEJavaHelper.getJavaSourceLevel(null), (String)PDEJavaHelper.getJavaComplianceLevel(null));
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    protected String getNameFieldQualifier() {
        return PDEUIMessages.ContentPage_plugin;
    }

    private static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        return Math.max(50, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_GENERATE_ACTIVATOR, !this.fGenerateClass.getSelection());
        if (this.fUIPlugin.isEnabled()) {
            settings.put(S_UI_PLUGIN, !this.fUIPlugin.getSelection());
        }
        settings.put(S_RCP_PLUGIN, this.fYesButton.getSelection());
    }
}

