/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LibraryPluginJarsPage
extends WizardPage {
    protected LibraryPluginFieldData fData;
    protected ArrayList fJarPaths = new ArrayList();
    protected Button fRemove;
    protected TableViewer fTableViewer;

    public LibraryPluginJarsPage(String pageName, LibraryPluginFieldData data) {
        super(pageName);
        this.fData = data;
        this.setTitle(PDEUIMessages.LibraryPluginJarsPage_title);
        this.setDescription(PDEUIMessages.LibraryPluginJarsPage_desc);
    }

    private void chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        String res = dialog.open();
        if (res != null) {
            String path = new File(res).getParent();
            String[] fileNames = dialog.getFileNames();
            int i = 0;
            while (i < fileNames.length) {
                File newJarFile = new File(path, fileNames[i]);
                this.removeJar(fileNames[i]);
                this.fJarPaths.add(newJarFile);
                this.fTableViewer.add((Object)newJarFile);
                ++i;
            }
            this.fRemove.setEnabled(this.fJarPaths.size() > 0);
            this.setPageComplete(this.fJarPaths.size() > 0);
        }
    }

    private void chooseWorkspaceFile() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(true);
        dialog.setTitle(PDEUIMessages.LibraryPluginJarsPage_SelectionDialog_title);
        dialog.setMessage(PDEUIMessages.LibraryPluginJarsPage_SelectionDialog_message);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("jar"));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            int i = 0;
            while (i < files.length) {
                IFile newJarFile = (IFile)files[i];
                this.removeJar(newJarFile.getName());
                this.fJarPaths.add(newJarFile);
                this.fTableViewer.add((Object)newJarFile);
                ++i;
            }
            this.fRemove.setEnabled(this.fJarPaths.size() > 0);
            this.setPageComplete(this.fJarPaths.size() > 0);
        }
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        control.setLayout((Layout)layout);
        Label l = new Label(control, 64);
        l.setText(PDEUIMessages.LibraryPluginJarsPage_label);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        this.fTableViewer = new TableViewer(control, 2050);
        this.fTableViewer.setContentProvider((IContentProvider)new DefaultTableProvider(){

            public Object[] getElements(Object inputElement) {
                return LibraryPluginJarsPage.this.fJarPaths.toArray();
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object obj) {
                String location;
                String name;
                if (obj instanceof IFile) {
                    IFile jarFile = (IFile)obj;
                    name = jarFile.getName();
                    location = jarFile.getParent().getFullPath().toString().substring(1);
                } else {
                    File jarFile = (File)obj;
                    name = jarFile.getName();
                    location = jarFile.getParent();
                }
                return String.valueOf(name) + " - " + location;
            }

            public Image getImage(Object obj) {
                if (obj instanceof IFile) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_JAR_OBJ);
                }
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_JAR_LIB_OBJ);
            }
        });
        data = new GridData(1808);
        this.fTableViewer.getControl().setLayoutData((Object)data);
        this.fTableViewer.setInput((Object)this.fJarPaths);
        this.fTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LibraryPluginJarsPage.this.handleRemove();
                }
            }
        });
        Composite buttons = new Composite(control, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        data = new GridData(1040);
        data.grabExcessVerticalSpace = true;
        buttons.setLayoutData((Object)data);
        Button browseWorkspace = new Button(buttons, 8);
        browseWorkspace.setText(PDEUIMessages.LibraryPluginJarsPage_add);
        browseWorkspace.setLayoutData((Object)new GridData(770));
        SWTUtil.setButtonDimensionHint(browseWorkspace);
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPluginJarsPage.this.chooseWorkspaceFile();
            }
        });
        Button browseFile = new Button(buttons, 8);
        browseFile.setText(PDEUIMessages.LibraryPluginJarsPage_addExternal);
        browseFile.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(browseFile);
        browseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPluginJarsPage.this.chooseFile();
            }
        });
        this.fRemove = new Button(buttons, 8);
        this.fRemove.setText(PDEUIMessages.LibraryPluginJarsPage_remove);
        this.fRemove.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fRemove);
        this.fRemove.setEnabled(this.fJarPaths.size() > 0);
        this.setPageComplete(this.fJarPaths.size() > 0);
        this.fRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPluginJarsPage.this.handleRemove();
            }
        });
        Dialog.applyDialogFont((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.pde.doc.user.new_library_plugin_jar_page");
        this.setControl((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.pde.doc.user.library_plugin_jars");
    }

    private void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object file = it.next();
                this.fJarPaths.remove(file);
                this.fTableViewer.remove(file);
            }
            this.fRemove.setEnabled(this.fJarPaths.size() > 0);
            this.setPageComplete(this.fJarPaths.size() > 0);
        }
    }

    public boolean isPageComplete() {
        return this.fJarPaths.size() > 0;
    }

    private void removeJar(String fileName) {
        int i = 0;
        while (i < this.fJarPaths.size()) {
            String name;
            Object jarFile;
            if (this.fJarPaths.get(i) instanceof IFile) {
                jarFile = (IFile)this.fJarPaths.get(i);
                name = jarFile.getName();
            } else {
                jarFile = (File)this.fJarPaths.get(i);
                name = ((File)jarFile).getName();
            }
            if (name.equals(fileName)) {
                Object jarPath = this.fJarPaths.get(i);
                this.fJarPaths.remove(jarPath);
                this.fTableViewer.remove(jarPath);
            }
            ++i;
        }
    }

    public void updateData() {
        String[] jarPaths = new String[this.fJarPaths.size()];
        int i = 0;
        while (i < this.fJarPaths.size()) {
            Object jarFile;
            if (this.fJarPaths.get(i) instanceof IFile) {
                jarFile = (IFile)this.fJarPaths.get(i);
                jarPaths[i] = jarFile.getLocation().toString();
            } else {
                jarFile = (File)this.fJarPaths.get(i);
                jarPaths[i] = ((File)jarFile).toString();
            }
            ++i;
        }
        this.fData.setLibraryPaths(jarPaths);
    }
}

