/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExecutionEnvironmentAnalyzer;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.team.core.RepositoryProvider;

public class ClasspathComputer {
    private static Hashtable fSeverityTable = null;
    private static final int SEVERITY_ERROR = 3;
    private static final int SEVERITY_WARNING = 2;
    private static final int SEVERITY_IGNORE = 1;

    public static void setClasspath(IProject project, IPluginModelBase model) throws CoreException {
        IClasspathEntry[] entries = ClasspathComputer.getClasspath(project, model, false);
        JavaCore.create((IProject)project).setRawClasspath(entries, null);
    }

    public static IClasspathEntry[] getClasspath(IProject project, IPluginModelBase model, boolean clear) throws CoreException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IBuild build = ClasspathComputer.getBuild(project);
        ClasspathComputer.addSourceAndLibraries(project, model, build, clear, result);
        String ee = ClasspathComputer.getExecutionEnvironment(model.getBundleDescription());
        result.add(ClasspathComputer.createJREEntry(ee));
        ClasspathComputer.setComplianceOptions(JavaCore.create((IProject)project), ExecutionEnvironmentAnalyzer.getCompliance((String)ee));
        result.add(ClasspathComputer.createContainerEntry());
        IClasspathEntry[] entries = result.toArray(new IClasspathEntry[result.size()]);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage((String)validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    public static void addSourceAndLibraries(IProject project, IPluginModelBase model, IBuild build, boolean clear, ArrayList result) throws CoreException {
        HashSet<IPath> paths = new HashSet<IPath>();
        if (!clear) {
            IClasspathEntry[] entries = JavaCore.create((IProject)project).getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3 && paths.add(entry.getPath())) {
                    result.add(entry);
                }
                ++i;
            }
        }
        IClasspathAttribute[] attrs = ClasspathComputer.getClasspathAttributes(project, model);
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IBuildEntry buildEntry;
            IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source." + libraries[i].getName());
            if (buildEntry != null) {
                ClasspathComputer.addSourceFolder(buildEntry, project, paths, result);
            } else if (libraries[i].getName().equals(".")) {
                ClasspathComputer.addJARdPlugin(project, ClasspathUtilCore.getFilename((IPluginModelBase)model), attrs, result);
            } else {
                ClasspathComputer.addLibraryEntry(project, libraries[i], attrs, result);
            }
            ++i;
        }
        if (libraries.length == 0) {
            if (build != null) {
                IBuildEntry buildEntry;
                IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source..");
                if (buildEntry != null) {
                    ClasspathComputer.addSourceFolder(buildEntry, project, paths, result);
                }
            } else if (ClasspathUtilCore.hasBundleStructure((IPluginModelBase)model)) {
                ClasspathComputer.addJARdPlugin(project, ClasspathUtilCore.getFilename((IPluginModelBase)model), attrs, result);
            }
        }
    }

    private static IClasspathAttribute[] getClasspathAttributes(IProject project, IPluginModelBase model) {
        JavadocLocationManager manager;
        String javadoc;
        IClasspathAttribute[] attributes = new IClasspathAttribute[]{};
        if (!RepositoryProvider.isShared((IProject)project) && (javadoc = (manager = PDECore.getDefault().getJavadocLocationManager()).getJavadocLocation(model)) != null) {
            attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadoc)};
        }
        return attributes;
    }

    /*
     * Unable to fully structure code
     */
    private static void addSourceFolder(IBuildEntry buildEntry, IProject project, HashSet paths, ArrayList result) throws CoreException {
        folders = buildEntry.getTokens();
        j = 0;
        while (j < folders.length) {
            block3: {
                block4: {
                    folder = folders[j];
                    path = project.getFullPath().append(folder);
                    if (!paths.add(path)) break block3;
                    if (project.findMember(folder) != null) break block4;
                    CoreUtility.createFolder((IFolder)project.getFolder(folder));
                    ** GOTO lbl-1000
                }
                root = JavaCore.create((IProject)project).getPackageFragmentRoot(path.toString());
                if (root.exists() && root.getKind() == 2) {
                    result.add(root.getRawClasspathEntry());
                } else lbl-1000:
                // 2 sources

                {
                    result.add(JavaCore.newSourceEntry((IPath)path));
                }
            }
            ++j;
        }
    }

    protected static IBuild getBuild(IProject project) throws CoreException {
        IFile buildFile = project.getFile("build.properties");
        WorkspaceBuildModel buildModel = null;
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }

    private static void addLibraryEntry(IProject project, IPluginLibrary library, IClasspathAttribute[] attrs, ArrayList result) throws JavaModelException {
        IClasspathEntry oldEntry;
        String name = ClasspathUtilCore.expandLibraryName((String)library.getName());
        IResource jarFile = project.findMember(name);
        if (jarFile == null) {
            return;
        }
        IPackageFragmentRoot root = JavaCore.create((IProject)project).getPackageFragmentRoot(jarFile);
        if (root.exists() && root.getKind() == 2 && (oldEntry = root.getRawClasspathEntry()).getSourceAttachmentPath() != null && !result.contains(oldEntry)) {
            result.add(oldEntry);
            return;
        }
        IResource resource = project.findMember(ClasspathComputer.getSourceZipName(name));
        IPath srcAttachment = resource != null ? resource.getFullPath() : null;
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarFile.getFullPath(), (IPath)srcAttachment, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attrs, (boolean)library.isExported());
        if (!result.contains(entry)) {
            result.add(entry);
        }
    }

    private static void addJARdPlugin(IProject project, String filename, IClasspathAttribute[] attrs, ArrayList result) {
        String name = ClasspathUtilCore.expandLibraryName((String)filename);
        IResource jarFile = project.findMember(name);
        if (jarFile != null) {
            IResource resource = project.findMember(ClasspathComputer.getSourceZipName(name));
            IPath srcAttachment = resource != null ? resource.getFullPath() : jarFile.getFullPath();
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarFile.getFullPath(), (IPath)srcAttachment, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attrs, (boolean)true);
            if (!result.contains(entry)) {
                result.add(entry);
            }
        }
    }

    public static String getSourceZipName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + "src.zip" : libraryName;
    }

    private static String getExecutionEnvironment(BundleDescription bundleDescription) {
        String[] envs;
        if (bundleDescription != null && (envs = bundleDescription.getExecutionEnvironments()).length > 0) {
            return envs[0];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setComplianceOptions(IJavaProject project, String compliance) {
        Map map = project.getOptions(false);
        if (compliance == null) {
            if (map.size() <= 0) return;
            map.remove("org.eclipse.jdt.core.compiler.compliance");
            map.remove("org.eclipse.jdt.core.compiler.source");
            map.remove("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            map.remove("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
            map.remove("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
        } else if ("1.6".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            map.put("org.eclipse.jdt.core.compiler.source", "1.6");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.5".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            map.put("org.eclipse.jdt.core.compiler.source", "1.5");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.4".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            ClasspathComputer.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
            ClasspathComputer.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.enumIdentifier", "warning");
        } else if ("1.3".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            ClasspathComputer.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
            ClasspathComputer.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        }
        project.setOptions(map);
    }

    private static void updateSeverityComplianceOption(Map map, String key, String value) {
        Integer current_value = null;
        Integer new_value = null;
        String current_string_value = null;
        int current_int_value = 0;
        int new_int_value = 0;
        if (fSeverityTable == null) {
            fSeverityTable = new Hashtable(3);
            fSeverityTable.put("ignore", new Integer(1));
            fSeverityTable.put("warning", new Integer(2));
            fSeverityTable.put("error", new Integer(3));
        }
        if ((current_string_value = (String)map.get(key)) != null && (current_value = (Integer)fSeverityTable.get(current_string_value)) != null) {
            current_int_value = current_value;
        }
        if ((new_value = (Integer)fSeverityTable.get(value)) != null) {
            new_int_value = new_value;
        }
        if (new_int_value > current_int_value) {
            map.put(key, value);
        }
    }

    public static IClasspathEntry createJREEntry(String ee) {
        IExecutionEnvironmentsManager manager;
        IExecutionEnvironment env;
        IPath path = null;
        if (ee != null && (env = (manager = JavaRuntime.getExecutionEnvironmentsManager()).getEnvironment(ee)) != null) {
            path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
        }
        if (path == null) {
            path = JavaRuntime.newDefaultJREContainerPath();
        }
        return JavaCore.newContainerEntry((IPath)path);
    }

    public static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH);
    }
}

