/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public abstract class JarImportOperation
implements IWorkspaceRunnable {
    protected void extractZipFile(File file, IPath destPath, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                this.importContent(provider.getRoot(), destPath, (IImportStructureProvider)provider, null, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void importContent(Object source, IPath destPath, IImportStructureProvider provider, List filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        try {
            ImportOperation op = new ImportOperation(destPath, source, provider, query);
            op.setCreateContainerStructure(false);
            if (filesToImport != null) {
                op.setFilesToImport(filesToImport);
            }
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    protected void extractResources(File file, IResource dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList collected = new ArrayList();
                this.collectResources(provider, provider.getRoot(), true, collected);
                this.importContent(provider.getRoot(), dest.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void extractJavaResources(File file, IResource dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList collected = new ArrayList();
                this.collectJavaResources(provider, provider.getRoot(), collected);
                this.importContent(provider.getRoot(), dest.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void importArchive(IProject project, File archive, IPath destPath) throws CoreException {
        try {
            if (destPath.segmentCount() > 2) {
                CoreUtility.createFolder((IFolder)project.getFolder(destPath.removeLastSegments(1)));
            }
            IFile file = project.getFile(destPath);
            FileInputStream fstream = new FileInputStream(archive);
            if (file.exists()) {
                file.setContents((InputStream)fstream, true, false, null);
            } else {
                file.create((InputStream)fstream, true, null);
            }
            fstream.close();
        }
        catch (IOException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void collectResources(ZipFileStructureProvider provider, Object element, boolean excludeMeta, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!excludeMeta || !provider.getLabel(curr).equals("META-INF")) {
                        this.collectResources(provider, curr, excludeMeta, collected);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    protected void collectNonJavaResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!provider.getLabel(curr).equals("src") && !this.isClassFolder(provider, curr)) {
                        ArrayList list = new ArrayList();
                        this.collectResources(provider, curr, false, list);
                        collected.addAll(list);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    protected void collectJavaFiles(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals("src")) {
                    ArrayList list = new ArrayList();
                    this.collectResources(provider, curr, false, list);
                    collected.addAll(list);
                }
                ++i;
            }
        }
    }

    protected void collectJavaResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && this.isClassFolder(provider, curr)) {
                    ArrayList list = new ArrayList();
                    this.collectResources(provider, curr, false, list);
                    collected.addAll(list);
                }
                ++i;
            }
        }
    }

    private boolean isClassFolder(ZipFileStructureProvider provider, Object element) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) ? this.isClassFolder(provider, curr) : provider.getLabel(curr).endsWith(".class")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean hasEmbeddedSource(ZipFileStructureProvider provider) {
        List children = provider.getChildren((Object)provider.getRoot());
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals("src")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean containsCode(ZipFileStructureProvider provider) {
        List children = provider.getChildren((Object)provider.getRoot());
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && this.isClassFolder(provider, curr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean containsCode(File file) {
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        boolean bl = this.containsCode(new ZipFileStructureProvider(zipFile));
        if (zipFile == null) return bl;
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {
                if (zipFile == null) return true;
            }
            catch (Throwable throwable) {
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                zipFile.close();
                return true;
            }
            catch (IOException iOException3) {}
            return true;
        }
    }

    protected String[] getTopLevelResources(File file) {
        ArrayList<String> result;
        block21: {
            result = new ArrayList<String>();
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(file);
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                    List children = provider.getChildren((Object)provider.getRoot());
                    if (children != null && !children.isEmpty()) {
                        int i = 0;
                        while (i < children.size()) {
                            Object curr = children.get(i);
                            if (provider.isFolder(curr)) {
                                if (!this.isClassFolder(provider, curr)) {
                                    result.add(String.valueOf(provider.getLabel(curr)) + "/");
                                } else if (!result.contains(".")) {
                                    result.add(".");
                                }
                            } else {
                                result.add(provider.getLabel(curr));
                            }
                            ++i;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

