/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.BaseSearchAction;
import org.eclipse.pde.internal.ui.search.PluginSearchQuery;
import org.eclipse.search.ui.ISearchQuery;

public class FindReferencesAction
extends BaseSearchAction {
    private Object fSelectedObject;
    private String fPluginID;

    public FindReferencesAction(Object object) {
        this(object, null);
    }

    public FindReferencesAction(Object object, String pluginID) {
        super(PDEUIMessages.SearchAction_references);
        this.fSelectedObject = object;
        this.fPluginID = pluginID;
        this.initialize();
    }

    private void initialize() {
        this.setImageDescriptor(PDEPluginImages.DESC_PSEARCH_OBJ);
    }

    protected ISearchQuery createSearchQuery() {
        PluginSearchInput input = new PluginSearchInput();
        if (this.fSelectedObject instanceof IPlugin) {
            input.setSearchElement(1);
            input.setSearchString(((IPlugin)this.fSelectedObject).getId());
        } else if (this.fSelectedObject instanceof IPluginExtensionPoint) {
            input.setSearchElement(3);
            IPluginModelBase model = ((IPluginExtensionPoint)this.fSelectedObject).getPluginModel();
            String id = model.getPluginBase().getId();
            if (id == null || id.trim().length() == 0) {
                id = this.fPluginID;
            }
            if (id == null || id.trim().length() == 0) {
                id = "*";
            }
            input.setSearchString(String.valueOf(id) + "." + ((IPluginExtensionPoint)this.fSelectedObject).getId());
        } else if (this.fSelectedObject instanceof IPluginImport) {
            input.setSearchElement(1);
            input.setSearchString(((IPluginImport)this.fSelectedObject).getId());
        }
        input.setSearchLimit(2);
        input.setSearchScope(new PluginSearchScope());
        return new PluginSearchQuery(input);
    }
}

