/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameResourceDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.CreateHeaderChangeOperation;
import org.eclipse.pde.internal.ui.refactoring.FindReferenceOperation;
import org.eclipse.pde.internal.ui.refactoring.RenamePluginInfo;
import org.eclipse.pde.internal.ui.refactoring.RenameProjectChange;

public class RenamePluginProcessor
extends RefactoringProcessor {
    RenamePluginInfo fInfo;

    public RenamePluginProcessor(RenamePluginInfo info) {
        this.fInfo = info;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IResource res = this.fInfo.getBase().getUnderlyingResource();
        if (res == null) {
            status.addFatalError(PDEUIMessages.RenamePluginProcessor_externalBundleError);
        } else if (!res.getProject().getFile("META-INF/MANIFEST.MF").exists()) {
            status.addFatalError(PDEUIMessages.RenamePluginProcessor_noManifestError);
        }
        if (this.fInfo.isRenameProject()) {
            String newName = this.fInfo.getNewID();
            IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newName);
            if (newProject.exists() && !res.getProject().equals((Object)newProject)) {
                status.addFatalError(MessageFormat.format((String)PDEUIMessages.RenameProjectChange_destinationExists, (Object[])new String[]{newName}));
            }
        }
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Object[] getElements() {
        return new Object[]{this.fInfo.getBase()};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return PDEUIMessages.RenamePluginProcessor_processorName;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        if (this.fInfo.isRenameProject()) {
            IParticipantDescriptorFilter filter = new IParticipantDescriptorFilter(){
                static final String PDE_CONTAINER_RENAME_PARTICIPANT = "org.eclipse.pde.ui.manifestFolderRenameParticipant";

                public boolean select(IConfigurationElement element, RefactoringStatus status) {
                    return !PDE_CONTAINER_RENAME_PARTICIPANT.equals(element.getAttribute("id"));
                }
            };
            IProject project = this.fInfo.getBase().getUnderlyingResource().getProject();
            return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)project, (RenameArguments)new RenameArguments(this.fInfo.getNewID(), true), (IParticipantDescriptorFilter)filter, (String[])this.getAffectedNatures(project), (SharableParticipants)sharedParticipants);
        }
        return new RefactoringParticipant[0];
    }

    private String[] getAffectedNatures(IProject project) throws CoreException {
        return project.getDescription().getNatureIds();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(MessageFormat.format((String)PDEUIMessages.RenamePluginProcessor_changeTitle, (Object[])new String[]{this.fInfo.getCurrentID(), this.fInfo.getNewID()}));
        pm.beginTask("", this.getTotalWork());
        CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(this.fInfo.getBase(), "Bundle-SymbolicName", this.fInfo.getCurrentID(), this.fInfo.getNewID());
        op.run((IProgressMonitor)new SubProgressMonitor(pm, 1));
        change.add((Change)op.getChange());
        if (this.fInfo.isRenameProject()) {
            change.add(this.createProjectChange((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        if (this.fInfo.isUpdateReferences()) {
            change.addAll(this.createReferenceChanges((IProgressMonitor)new SubProgressMonitor(pm, 2)));
        }
        return change;
    }

    private int getTotalWork() {
        int total = 1;
        if (this.fInfo.isRenameProject()) {
            ++total;
        }
        if (this.fInfo.isUpdateReferences()) {
            total += 2;
        }
        return total;
    }

    protected Change createProjectChange(IProgressMonitor monitor) {
        RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
        IProject project = this.fInfo.getBase().getUnderlyingResource().getProject();
        String newName = this.fInfo.getNewID();
        if (project.getName().equals(newName)) {
            return null;
        }
        descriptor.setDescription(MessageFormat.format((String)PDEUIMessages.RenamePluginProcessor_renameProjectDesc, (Object[])new String[]{project.getName(), newName}));
        descriptor.setComment("");
        descriptor.setFlags(7);
        descriptor.setResource((IResource)project);
        descriptor.setNewName(this.fInfo.getNewID());
        monitor.done();
        return new RenameProjectChange((RefactoringDescriptor)descriptor, (IResource)project, this.fInfo.getNewID(), null);
    }

    protected Change[] createReferenceChanges(IProgressMonitor monitor) throws CoreException {
        IPluginModelBase currentBase = this.fInfo.getBase();
        BundleDescription desc = currentBase.getBundleDescription();
        if (desc == null) {
            IPluginModelBase savedBase = PluginRegistry.findModel((IProject)currentBase.getUnderlyingResource().getProject());
            BundleDescription bundleDescription = desc = savedBase != null ? savedBase.getBundleDescription() : null;
        }
        if (desc != null) {
            FindReferenceOperation op = new FindReferenceOperation(desc, this.fInfo.getNewID());
            op.run(monitor);
            return op.getChanges();
        }
        return new Change[0];
    }
}

