/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.pde.internal.ui.refactoring.BuildPropertiesChange;
import org.eclipse.pde.internal.ui.refactoring.BundleManifestChange;
import org.eclipse.pde.internal.ui.refactoring.PluginManifestChange;

public abstract class PDERenameParticipant
extends RenameParticipant
implements ISharableParticipant {
    protected IProject fProject;
    protected HashMap fElements;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        String newName = ((RenameArguments)arguments).getNewName();
        if (element instanceof IResource) {
            IPath projectPath = ((IResource)element).getProjectRelativePath();
            newName = projectPath.removeLastSegments(1).append(newName).toString();
        }
        this.fElements.put(element, newName);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        CompositeChange result = new CompositeChange(this.getName());
        if (this.updateManifest()) {
            this.addBundleManifestChange(result, pm);
        }
        if (this.updateBuildProperties()) {
            this.addBuildPropertiesChange(result, pm);
        }
        this.addChange(result, "plugin.xml", pm);
        this.addChange(result, "fragment.xml", pm);
        return result.getChildren().length == 0 ? null : result;
    }

    private void addChange(CompositeChange result, String filename, IProgressMonitor pm) throws CoreException {
        Change change;
        IFile file = this.fProject.getFile(filename);
        if (file.exists() && (change = PluginManifestChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), this.getTextChange(file), pm)) != null) {
            result.add(change);
        }
    }

    protected String[] getNewNames() {
        String[] result = new String[this.fElements.size()];
        Iterator iter = this.fElements.values().iterator();
        int i = 0;
        while (i < this.fElements.size()) {
            result[i] = iter.next().toString();
            ++i;
        }
        return result;
    }

    protected void addBundleManifestChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
        this.addBundleManifestChange(this.fProject.getFile("META-INF/MANIFEST.MF"), result, pm);
    }

    protected void addBundleManifestChange(IFile file, CompositeChange result, IProgressMonitor pm) throws CoreException {
        Change change;
        if (file.exists() && (change = BundleManifestChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }

    protected void addBuildPropertiesChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
        Change change;
        IFile file = this.fProject.getFile("build.properties");
        if (file.exists() && (change = BuildPropertiesChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }

    protected boolean updateManifest() {
        return this.containsElement(true);
    }

    protected boolean updateBuildProperties() {
        return this.containsElement(false);
    }

    protected boolean containsElement(boolean javaElement) {
        Object[] objs = this.fElements.keySet().toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof IJavaElement == javaElement) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

