/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.preferences.CompilersConfigurationTab;
import org.eclipse.pde.internal.ui.preferences.CompilersPreferencePage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class CompilersPropertyPage
extends PropertyPage {
    private ControlEnableState blockEnableState;
    private Button changeWorkspaceSettingsButton;
    private CompilersConfigurationTab configurationBlock;
    private Control configurationBlockControl;
    private Button useProjectButton;
    private Button useWorkspaceButton;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.configurationBlock = new CompilersConfigurationTab(this.getProject());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    CompilersPropertyPage.this.doDialogFieldChanged((Button)e.getSource());
                }
            }
        };
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.useWorkspaceButton = new Button(composite, 16);
        this.useWorkspaceButton.addSelectionListener((SelectionListener)listener);
        this.useWorkspaceButton.setText(PDEUIMessages.CompilersPropertyPage_useworkspacesettings_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.useWorkspaceButton.setLayoutData((Object)gd);
        this.changeWorkspaceSettingsButton = new Button(composite, 8);
        this.changeWorkspaceSettingsButton.setText(PDEUIMessages.CompilersPropertyPage_useworkspacesettings_change);
        this.changeWorkspaceSettingsButton.addSelectionListener((SelectionListener)listener);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.useWorkspaceButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.changeWorkspaceSettingsButton);
        this.useProjectButton = new Button(composite, 16);
        this.useProjectButton.addSelectionListener((SelectionListener)listener);
        this.useProjectButton.setText(PDEUIMessages.CompilersPropertyPage_useprojectsettings_label);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.useProjectButton.setLayoutData((Object)gd);
        GridData data = new GridData(272);
        data.horizontalSpan = 2;
        this.configurationBlockControl = this.configurationBlock.createContents(composite);
        this.configurationBlockControl.setLayoutData((Object)data);
        boolean useProjectSettings = CompilerFlags.getBoolean((IProject)this.getProject(), (String)"compilers.use-project");
        this.useProjectButton.setSelection(useProjectSettings);
        this.useWorkspaceButton.setSelection(!useProjectSettings);
        this.changeWorkspaceSettingsButton.setEnabled(!useProjectSettings);
        this.updateEnableState();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.compilers_property_page");
    }

    private void doDialogFieldChanged(Button button) {
        if (button == this.changeWorkspaceSettingsButton) {
            this.showPreferencePage();
        } else {
            this.updateEnableState();
        }
    }

    private IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IProject)iAdaptable.getAdapter((Class)clazz);
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.useProjectButton.setSelection(false);
            this.useWorkspaceButton.setSelection(true);
            this.updateEnableState();
            this.configurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (!this.configurationBlock.performOk(this.useProjectSettings())) {
            this.getContainer().updateButtons();
            return false;
        }
        return super.performOk();
    }

    private boolean showPreferencePage() {
        PreferenceNode targetNode = new PreferenceNode("org.eclipse.pde.ui.CompilersPreferencePage", (IPreferencePage)new CompilersPreferencePage());
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    private void updateEnableState() {
        if (this.useProjectSettings()) {
            if (this.blockEnableState != null) {
                this.changeWorkspaceSettingsButton.setEnabled(false);
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.changeWorkspaceSettingsButton.setEnabled(true);
            this.blockEnableState = ControlEnableState.disable((Control)this.configurationBlockControl);
        }
    }

    private boolean useProjectSettings() {
        return this.useProjectButton.getSelection();
    }
}

