/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JavaArgumentsTab {
    private Text fProgramArgs;
    private Text fVMArgs;
    private TargetPlatformPreferencePage fPage;
    private Button fAppendLauncherArgs;

    public JavaArgumentsTab(TargetPlatformPreferencePage page) {
        this.fPage = page;
    }

    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Label description = new Label(container, 64);
        description.setText(PDEUIMessages.JavaArgumentsTab_description);
        GridData gd = new GridData();
        gd.widthHint = 450;
        description.setLayoutData((Object)gd);
        Group programGroup = new Group(container, 0);
        programGroup.setLayout((Layout)new GridLayout());
        programGroup.setLayoutData((Object)new GridData(768));
        programGroup.setText(PDEUIMessages.JavaArgumentsTab_progamArgsGroup);
        this.fProgramArgs = new Text((Composite)programGroup, 2626);
        gd = new GridData(1808);
        gd.widthHint = 450;
        gd.heightHint = 60;
        this.fProgramArgs.setLayoutData((Object)gd);
        Button programVars = new Button((Composite)programGroup, 0);
        programVars.setLayoutData((Object)new GridData(128));
        programVars.setText(PDEUIMessages.JavaArgumentsTab_programVariables);
        programVars.addSelectionListener(this.getListener(this.fProgramArgs));
        Group vmGroup = new Group(container, 0);
        vmGroup.setLayout((Layout)new GridLayout(2, false));
        vmGroup.setLayoutData((Object)new GridData(768));
        vmGroup.setText(PDEUIMessages.JavaArgumentsTab_vmArgsGroup);
        this.fVMArgs = new Text((Composite)vmGroup, 2626);
        gd = new GridData(1808);
        gd.widthHint = 450;
        gd.heightHint = 60;
        gd.horizontalSpan = 2;
        this.fVMArgs.setLayoutData((Object)gd);
        this.fAppendLauncherArgs = new Button((Composite)vmGroup, 32);
        this.fAppendLauncherArgs.setText(PDEUIMessages.JavaArgumentsTab_appendLauncherIni);
        Button vmVars = new Button((Composite)vmGroup, 0);
        vmVars.setLayoutData((Object)new GridData(128));
        vmVars.setText(PDEUIMessages.JavaArgumentsTab_vmVariables);
        vmVars.addSelectionListener(this.getListener(this.fVMArgs));
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.launching_args_preference_page");
        return container;
    }

    protected SelectionListener getListener(final Text textControl) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(JavaArgumentsTab.this.fPage.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    textControl.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected void initialize() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        this.fProgramArgs.setText(preferences.getString("program_args"));
        this.fVMArgs.setText(preferences.getString("vm_args"));
        this.fAppendLauncherArgs.setSelection(preferences.getBoolean("vm_launcher_ini"));
    }

    public void performOk() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        preferences.setValue("program_args", this.fProgramArgs.getText());
        preferences.setValue("vm_args", this.fVMArgs.getText());
        preferences.setValue("vm_launcher_ini", this.fAppendLauncherArgs.getSelection());
    }

    protected void performDefaults() {
        this.fProgramArgs.setText("");
        this.fVMArgs.setText("");
    }

    protected void loadTargetProfile(ITarget target) {
        IArgumentsInfo info = target.getArguments();
        if (info == null) {
            this.fProgramArgs.setText("");
            this.fVMArgs.setText("");
            return;
        }
        String progArgs = info.getProgramArguments() == null ? "" : info.getProgramArguments();
        this.fProgramArgs.setText(progArgs);
        String vmArgs = info.getVMArguments() == null ? "" : info.getVMArguments();
        this.fVMArgs.setText(vmArgs);
    }
}

