/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.internal.ui.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.launcher.OSGiValidationOperation;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class OSGiBundleBlock
extends AbstractPluginBlock {
    private ILaunchConfiguration fLaunchConfiguration;

    public OSGiBundleBlock(BundlesTab tab) {
        super(tab);
    }

    protected void createPluginViewer(Composite composite, int span, int indent) {
        super.createPluginViewer(composite, span, indent);
        Tree tree = this.fPluginTreeViewer.getTree();
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText(this.fTab.getName());
        column1.setWidth(300);
        TreeColumn column2 = new TreeColumn(tree, 0x1000000);
        column2.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        column2.setWidth(80);
        TreeColumn column3 = new TreeColumn(tree, 0x1000000);
        column3.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        column3.setWidth(80);
        tree.setHeaderVisible(true);
        this.createEditors();
    }

    private void createEditors() {
        final Tree tree = this.fPluginTreeViewer.getTree();
        final TreeEditor editor1 = new TreeEditor(tree);
        editor1.horizontalAlignment = 0x1000000;
        editor1.minimumWidth = 60;
        final TreeEditor editor2 = new TreeEditor(tree);
        editor2.horizontalAlignment = 0x1000000;
        editor2.grabHorizontal = true;
        editor2.minimumWidth = 60;
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                Control oldEditor = editor1.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((oldEditor = editor2.getEditor()) != null) {
                    oldEditor.dispose();
                }
                if (!OSGiBundleBlock.this.isEditable(item = (TreeItem)e.item)) {
                    return;
                }
                Spinner spinner = new Spinner((Composite)tree, 2048);
                spinner.setMinimum(0);
                String level = item.getText(1);
                int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
                spinner.setSelection(defaultLevel);
                spinner.addModifyListener(new ModifyListener(this, item, spinner){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ TreeItem val$item;
                    private final /* synthetic */ Spinner val$spinner;
                    {
                        this.this$1 = var1_1;
                        this.val$item = treeItem;
                        this.val$spinner = spinner;
                    }

                    public void modifyText(ModifyEvent e) {
                        if (this.val$item.getChecked()) {
                            int selection = this.val$spinner.getSelection();
                            this.val$item.setText(1, selection == 0 ? "default" : Integer.toString(selection));
                            1.access$0(this.this$1).fTab.updateLaunchConfigurationDialog();
                        }
                    }
                });
                editor1.setEditor((Control)spinner, item, 1);
                CCombo combo = new CCombo((Composite)tree, 2056);
                combo.setItems(new String[]{"default", Boolean.toString(true), Boolean.toString(false)});
                combo.setText(item.getText(2));
                combo.pack();
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, item, combo){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ TreeItem val$item;
                    private final /* synthetic */ CCombo val$combo;
                    {
                        this.this$1 = var1_1;
                        this.val$item = treeItem;
                        this.val$combo = cCombo;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (this.val$item.getChecked()) {
                            this.val$item.setText(2, this.val$combo.getText());
                            1.access$0(this.this$1).fTab.updateLaunchConfigurationDialog();
                        }
                    }
                });
                editor2.setEditor((Control)combo, item, 2);
            }

            static /* synthetic */ OSGiBundleBlock access$0(1 var0) {
                return var0.OSGiBundleBlock.this;
            }
        });
    }

    private boolean isEditable(TreeItem item) {
        IPluginModelBase model;
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase && !"org.eclipse.osgi".equals((model = (IPluginModelBase)obj).getPluginBase().getId())) {
            return this.fPluginTreeViewer.getChecked((Object)model);
        }
        return false;
    }

    protected ILabelProvider getLabelProvider() {
        return new OSGiLabelProvider();
    }

    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        StringBuffer wBuffer = new StringBuffer();
        StringBuffer tBuffer = new StringBuffer();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)selected[i];
                String id = model.getPluginBase().getId();
                TreeItem item = (TreeItem)this.fPluginTreeViewer.testFindItem((Object)model);
                if (model.getUnderlyingResource() == null) {
                    this.appendToBuffer(tBuffer, id, item);
                } else {
                    this.appendToBuffer(wBuffer, id, item);
                }
            }
            ++i;
        }
        config.setAttribute("workspace_bundles", wBuffer.length() == 0 ? null : wBuffer.toString());
        config.setAttribute("target_bundles", tBuffer.length() == 0 ? null : tBuffer.toString());
        StringBuffer buffer = new StringBuffer();
        if (this.fAddWorkspaceButton.getSelection()) {
            int i2 = 0;
            while (i2 < this.fWorkspaceModels.length) {
                if (!this.fPluginTreeViewer.getChecked((Object)this.fWorkspaceModels[i2])) {
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append(this.fWorkspaceModels[i2].getPluginBase().getId());
                }
                ++i2;
            }
        }
        config.setAttribute("deselected_workspace_plugins", buffer.length() > 0 ? buffer.toString() : null);
    }

    private void appendToBuffer(StringBuffer buffer, String id, TreeItem item) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append(id);
        buffer.append("@");
        buffer.append(item.getText(1));
        buffer.append(":");
        buffer.append(item.getText(2));
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        super.initializeFrom(configuration);
        this.initWorkspacePluginsState(configuration);
        this.initExternalPluginsState(configuration);
        this.updateCounter();
        this.fLaunchConfiguration = configuration;
    }

    private void initExternalPluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap(configuration);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumExternalChecked = map.size();
        this.resetGroup(this.fExternalPlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    private void resetGroup(NamedElement group) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)group);
        if (widget instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)widget).getItems();
            int i = 0;
            while (i < items.length) {
                if (!items[i].getChecked()) {
                    this.resetText(items[i]);
                }
                ++i;
            }
        }
    }

    private void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumWorkspaceChecked = map.size();
        this.resetGroup(this.fWorkspacePlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    protected void handleGroupStateChanged(Object group, boolean checked) {
        super.handleGroupStateChanged(group, checked);
        Widget item = this.fPluginTreeViewer.testFindItem(group);
        if (item instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)item).getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem child = items[i];
                if (child.getChecked() == (child.getText(1).length() == 0)) {
                    this.resetText(items[i]);
                }
                ++i;
            }
        }
    }

    protected void handleCheckStateChanged(CheckStateChangedEvent event) {
        super.handleCheckStateChanged(event);
        this.resetText((IPluginModelBase)event.getElement());
    }

    protected void setChecked(IPluginModelBase model, boolean checked) {
        super.setChecked(model, checked);
        this.resetText(model);
    }

    protected void setCheckedElements(Object[] checked) {
        super.setCheckedElements(checked);
        this.updateGroup(this.fWorkspacePlugins);
        this.updateGroup(this.fExternalPlugins);
    }

    private void updateGroup(Object group) {
        Widget item = this.fPluginTreeViewer.testFindItem(group);
        if (item instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)item).getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem child = items[i];
                if (child.getChecked() == (child.getText(1).length() == 0)) {
                    this.resetText(items[i]);
                }
                ++i;
            }
        }
    }

    private void setText(IPluginModelBase model, String value) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)model);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            int index = value == null ? -1 : value.indexOf(58);
            item.setText(1, index == -1 ? "" : value.substring(0, index));
            item.setText(2, index == -1 ? "" : value.substring(index + 1));
        }
    }

    private void resetText(IPluginModelBase model) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)model);
        if (widget instanceof TreeItem) {
            this.resetText((TreeItem)widget);
        }
    }

    private void resetText(TreeItem item) {
        if (item.getChecked()) {
            IPluginModelBase model = (IPluginModelBase)item.getData();
            boolean isSystemBundle = "org.eclipse.osgi".equals(model.getPluginBase().getId());
            if (!"default".equals(item.getText(1))) {
                item.setText(1, isSystemBundle ? "" : "default");
            }
            if (!"default".equals(item.getText(2))) {
                item.setText(2, isSystemBundle ? "" : "default");
            }
        } else {
            if (item.getText(1).length() > 0) {
                item.setText(1, "");
            }
            if (item.getText(2).length() > 0) {
                item.setText(2, "");
            }
        }
    }

    protected void handleRestoreDefaults() {
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                this.resetText((IPluginModelBase)selected[i]);
            }
            ++i;
        }
    }

    protected int getTreeViewerStyle() {
        return super.getTreeViewerStyle() | 0x10000;
    }

    protected LaunchValidationOperation createValidationOperation() {
        return new OSGiValidationOperation(this.fLaunchConfiguration);
    }

    class OSGiLabelProvider
    extends PDELabelProvider {
        OSGiLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            return index == 0 ? super.getColumnImage(obj, index) : null;
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return super.getColumnText(obj, index);
                }
            }
            return "";
        }
    }
}

