/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ConfigurationAreaBlock
extends BaseBlock {
    private Button fUseDefaultLocationButton;
    private Button fClearConfig;
    private String fLastEnteredConfigArea;
    private String fConfigName;
    private static String DEFAULT_DIR = "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/";

    public ConfigurationAreaBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ConfigurationTab_configAreaGroup);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.fUseDefaultLocationButton = new Button((Composite)group, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUseDefaultLocationButton.setLayoutData((Object)gd);
        this.fUseDefaultLocationButton.setText(PDEUIMessages.ConfigurationTab_useDefaultLoc);
        this.fUseDefaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaultArea = ConfigurationAreaBlock.this.fUseDefaultLocationButton.getSelection();
                if (useDefaultArea) {
                    ConfigurationAreaBlock.this.fLocationText.setText(String.valueOf(DEFAULT_DIR) + ConfigurationAreaBlock.this.fConfigName);
                } else {
                    ConfigurationAreaBlock.this.fLocationText.setText(ConfigurationAreaBlock.this.fLastEnteredConfigArea);
                }
                ConfigurationAreaBlock.this.enableBrowseSection(!useDefaultArea);
            }
        });
        this.createText((Composite)group, PDEUIMessages.ConfigurationTab_configLog, 20);
        Composite buttons = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.fClearConfig = new Button(buttons, 32);
        this.fClearConfig.setText(PDEUIMessages.ConfigurationTab_clearArea);
        this.fClearConfig.setLayoutData((Object)new GridData(768));
        this.fClearConfig.addSelectionListener((SelectionListener)this.fListener);
        this.createButtons(buttons, new String[]{PDEUIMessages.BaseBlock_workspace, PDEUIMessages.BaseBlock_filesystem, PDEUIMessages.BaseBlock_variables});
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        this.fConfigName = configuration.getName();
        boolean useDefaultArea = configuration.getAttribute("useDefaultConfigArea", true);
        this.fUseDefaultLocationButton.setSelection(useDefaultArea);
        this.enableBrowseSection(!useDefaultArea);
        this.fClearConfig.setSelection(configuration.getAttribute("clearConfig", false));
        this.fLastEnteredConfigArea = configuration.getAttribute("configLocation", "");
        if (useDefaultArea) {
            this.fLocationText.setText(String.valueOf(DEFAULT_DIR) + this.fConfigName);
        } else {
            this.fLocationText.setText(this.fLastEnteredConfigArea);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfigArea", this.fUseDefaultLocationButton.getSelection());
        this.fLastEnteredConfigArea = this.getLocation();
        configuration.setAttribute("configLocation", this.fLastEnteredConfigArea);
        configuration.setAttribute("clearConfig", this.fClearConfig.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration, boolean isJUnit) {
        configuration.setAttribute("useDefaultConfigArea", !isJUnit);
        configuration.setAttribute("clearConfig", isJUnit);
        String location = String.valueOf(DEFAULT_DIR) + (isJUnit ? "pde-junit" : configuration.getName());
        configuration.setAttribute("configLocation", location);
    }

    protected String getName() {
        return PDEUIMessages.ConfigurationAreaBlock_name;
    }
}

