/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;

public class SchemaRearranger {
    private Schema fSchema;

    public SchemaRearranger(Schema schema) {
        this.fSchema = schema;
    }

    public void moveCompositor(ISchemaObject newParent, ISchemaCompositor compositor) {
        ISchemaObject oldParent = compositor.getParent();
        if (newParent == null || compositor == null || newParent.equals(oldParent) || newParent.equals(compositor)) {
            return;
        }
        if (newParent instanceof SchemaElement) {
            SchemaElement element = (SchemaElement)newParent;
            SchemaComplexType type = null;
            if (element.getType() instanceof SchemaComplexType) {
                type = (SchemaComplexType)element.getType();
                type.setCompositor(compositor);
            } else {
                type = new SchemaComplexType(element.getSchema());
                type.setCompositor(compositor);
                element.setType((ISchemaType)type);
            }
        } else if (newParent instanceof SchemaCompositor) {
            ((SchemaCompositor)newParent).addChild((ISchemaObject)compositor);
        } else {
            return;
        }
        if (oldParent instanceof SchemaElement) {
            ISchemaType oldType = ((SchemaElement)oldParent).getType();
            if (oldType instanceof ISchemaComplexType) {
                ((SchemaComplexType)oldType).setCompositor(null);
            }
        } else if (oldParent instanceof SchemaCompositor) {
            ((SchemaCompositor)oldParent).removeChild((ISchemaObject)compositor);
        }
        compositor.setParent(newParent);
    }

    public void moveReference(SchemaElementReference reference, ISchemaCompositor compositor, ISchemaObject sibling) {
        ISchemaCompositor oldCompositor = reference.getCompositor();
        if (compositor == null || reference == null || oldCompositor == null) {
            return;
        }
        if (compositor instanceof SchemaCompositor) {
            if (compositor.equals(oldCompositor)) {
                ((SchemaCompositor)compositor).moveChildToSibling((ISchemaObject)reference, sibling);
            } else {
                ((SchemaCompositor)oldCompositor).removeChild((ISchemaObject)reference);
                reference.setCompositor(compositor);
                ((SchemaCompositor)compositor).addChild((ISchemaObject)reference);
            }
        }
    }

    public void moveElement(ISchemaObject parent, ISchemaElement element, ISchemaObject sibling) {
        if (element == null) {
            return;
        }
        if (this.fSchema.equals(parent)) {
            this.fSchema.moveElementToSibling(element, sibling);
        } else if (parent instanceof ISchemaCompositor) {
            this.linkReference((ISchemaCompositor)parent, element, sibling);
        }
    }

    public void moveAttribute(ISchemaElement newParent, ISchemaAttribute attribute, ISchemaAttribute sibling) {
        ISchemaObject oldParent = attribute.getParent();
        if (attribute == null || newParent == null || oldParent == null) {
            return;
        }
        SchemaComplexType type = null;
        if (newParent.getType() instanceof SchemaComplexType) {
            type = (SchemaComplexType)newParent.getType();
        } else {
            type = new SchemaComplexType(newParent.getSchema());
            ((SchemaElement)newParent).setType((ISchemaType)type);
        }
        if (newParent.equals(oldParent)) {
            type.moveAttributeTo(attribute, sibling);
        } else {
            if (oldParent instanceof ISchemaElement && ((ISchemaElement)oldParent).getType() instanceof SchemaComplexType) {
                SchemaComplexType oldType = (SchemaComplexType)((ISchemaElement)oldParent).getType();
                oldType.removeAttribute(attribute);
            }
            attribute.setParent((ISchemaObject)newParent);
            type.addAttribute(attribute, sibling);
        }
    }

    public void pasteCompositor(ISchemaObject realTarget, ISchemaCompositor compositor, ISchemaObject sibling) {
        if (realTarget instanceof SchemaElement) {
            SchemaElement element = (SchemaElement)realTarget;
            SchemaComplexType type = null;
            if (element.getType() instanceof SchemaComplexType) {
                type = (SchemaComplexType)element.getType();
                type.setCompositor(compositor);
            } else {
                type = new SchemaComplexType(element.getSchema());
                element.setType((ISchemaType)type);
                type.setCompositor(compositor);
            }
        } else if (realTarget instanceof SchemaCompositor) {
            ((SchemaCompositor)realTarget).addChild((ISchemaObject)compositor, sibling);
        }
    }

    public void pasteReference(ISchemaObject realTarget, ISchemaObjectReference object, ISchemaObject sibling) {
        if (realTarget instanceof SchemaCompositor) {
            SchemaCompositor parent = (SchemaCompositor)realTarget;
            ((SchemaElementReference)object).setCompositor((ISchemaCompositor)parent);
            parent.addChild((ISchemaObject)((SchemaElementReference)object), sibling);
        }
    }

    public void pasteElement(ISchemaElement object, ISchemaObject sibling) {
        SchemaElement element = (SchemaElement)object;
        element.setParent((ISchemaObject)this.fSchema);
        this.fSchema.addElement((ISchemaElement)element, (ISchemaElement)sibling);
        this.fSchema.updateReferencesFor((ISchemaElement)element, 1);
    }

    public void pasteAttribute(ISchemaElement realTarget, ISchemaAttribute object, ISchemaObject sibling) {
        SchemaElement element = (SchemaElement)realTarget;
        SchemaAttribute attribute = (SchemaAttribute)object;
        attribute.setParent((ISchemaObject)element);
        ISchemaType type = element.getType();
        SchemaComplexType complexType = null;
        if (!(type instanceof ISchemaComplexType)) {
            complexType = new SchemaComplexType(element.getSchema());
            element.setType((ISchemaType)complexType);
        } else {
            complexType = (SchemaComplexType)type;
        }
        if (sibling instanceof ISchemaAttribute) {
            complexType.addAttribute((ISchemaAttribute)attribute, (ISchemaAttribute)sibling);
        } else {
            complexType.addAttribute((ISchemaAttribute)attribute);
        }
    }

    public void linkReference(ISchemaCompositor realTarget, ISchemaElement object, ISchemaObject sibling) {
        if (sibling instanceof SchemaElementReference) {
            realTarget = ((SchemaElementReference)sibling).getCompositor();
        }
        SchemaCompositor parent = (SchemaCompositor)realTarget;
        String refName = object.getName();
        SchemaElementReference reference = new SchemaElementReference((ISchemaCompositor)parent, refName);
        reference.setReferencedObject((ISchemaObject)this.fSchema.findElement(refName));
        parent.addChild((ISchemaObject)reference, sibling);
    }

    public void deleteCompositor(ISchemaCompositor compositor) {
        ISchemaObject cparent = compositor.getParent();
        if (cparent instanceof ISchemaElement) {
            SchemaElement element = (SchemaElement)cparent;
            ISchemaType type = element.getType();
            if (type instanceof SchemaComplexType && ((SchemaComplexType)type).getAttributeCount() != 0) {
                ((SchemaComplexType)type).setCompositor(null);
            } else {
                element.setType((ISchemaType)new SchemaSimpleType(element.getSchema(), "string"));
            }
        } else if (cparent instanceof SchemaCompositor) {
            ((SchemaCompositor)cparent).removeChild((ISchemaObject)compositor);
        }
    }

    public void deleteAttribute(ISchemaAttribute attribute) {
        ISchemaElement element = (ISchemaElement)attribute.getParent();
        SchemaComplexType type = (SchemaComplexType)element.getType();
        type.removeAttribute(attribute);
    }

    public void deleteElement(ISchemaElement element) {
        if (!(element instanceof ISchemaRootElement)) {
            Schema schema = (Schema)element.getParent();
            schema.removeElement(element);
            schema.updateReferencesFor(element, 2);
        }
    }

    public void deleteReference(SchemaElementReference reference) {
        SchemaCompositor compositor = (SchemaCompositor)reference.getCompositor();
        compositor.removeChild((ISchemaObject)reference);
    }
}

