/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class NewElementAction
extends Action {
    private Schema schema;
    private static final String NAME_COUNTER_KEY = "__schema_element_name";

    public NewElementAction() {
        this.setText(PDEUIMessages.SchemaEditor_NewElement_label);
        this.setImageDescriptor(PDEPluginImages.DESC_GEL_SC_OBJ);
        this.setToolTipText(PDEUIMessages.SchemaEditor_NewElement_tooltip);
    }

    private String getInitialName() {
        Hashtable counters = PDEPlugin.getDefault().getDefaultNameCounters();
        Integer counter = (Integer)counters.get(NAME_COUNTER_KEY);
        counter = counter == null ? new Integer(1) : new Integer(counter + 1);
        counters.put(NAME_COUNTER_KEY, counter);
        return NLS.bind((String)PDEUIMessages.SchemaEditor_NewElement_initialName, (Object)String.valueOf(counter));
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void run() {
        String name = this.getInitialName();
        Object element = name.equals("extension") ? new SchemaRootElement((ISchemaObject)this.schema, name) : new SchemaElement((ISchemaObject)this.schema, name);
        element.setType((ISchemaType)new SchemaSimpleType((ISchema)this.schema, "string"));
        this.schema.addElement((ISchemaElement)element);
        this.schema.updateReferencesFor((ISchemaElement)element, 1);
    }

    public void setSchema(Schema newSchema) {
        this.schema = newSchema;
    }
}

