/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BlankQuery;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyPropertiesDialog;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.ConditionalListSelectionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Version;

public class ImportPackageSection
extends TableSection
implements IModelChangedListener {
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int PROPERTIES_INDEX = 2;
    private ImportPackageHeader fHeader;
    private TableViewer fPackageViewer;
    private Action fAddAction;
    private Action fGoToAction;
    private Action fRemoveAction;
    private Action fPropertiesAction;

    public ImportPackageSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ImportPackageSection_add, PDEUIMessages.ImportPackageSection_remove, PDEUIMessages.ImportPackageSection_properties});
    }

    private boolean isFragment() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
        return model.isFragmentModel();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ImportPackageSection_required);
        if (this.isFragment()) {
            section.setDescription(PDEUIMessages.ImportPackageSection_descFragment);
        } else {
            section.setDescription(PDEUIMessages.ImportPackageSection_desc);
        }
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fPackageViewer = tablePart.getTableViewer();
        this.fPackageViewer.setContentProvider((IContentProvider)new ImportPackageContentProvider());
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPackageViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = e1.toString();
                String s2 = e2.toString();
                if (s1.indexOf(" ") != -1) {
                    s1 = s1.substring(0, s1.indexOf(" "));
                }
                if (s2.indexOf(" ") != -1) {
                    s2 = s2.substring(0, s2.indexOf(" "));
                }
                return super.compare(viewer, (Object)s1, (Object)s2);
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(1808));
        this.makeActions();
        IBundleModel model = this.getBundleModel();
        this.fPackageViewer.setInput((Object)model);
        model.addModelChangedListener((IModelChangedListener)this);
        this.updateButtons();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        int i = 0;
        while (i < sourceObjects.length) {
            ImportPackageObject importPackageObject;
            if (!(sourceObjects[i] instanceof ImportPackageObject)) {
                return false;
            }
            if (this.fHeader != null && this.fHeader.hasPackage((importPackageObject = (ImportPackageObject)sourceObjects[i]).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void dispose() {
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        IBundleModel model = this.getBundleModel();
        if (model == null) {
            return;
        }
        IBundle bundle = model.getBundle();
        int i = 0;
        while (i < sourceObjects.length) {
            Object sourceObject = sourceObjects[i];
            if (sourceObject instanceof ImportPackageObject) {
                ImportPackageObject importPackageObject = (ImportPackageObject)sourceObject;
                importPackageObject.reconnect(model, this.fHeader, this.getVersionAttribute());
                if (this.fHeader == null) {
                    bundle.setHeader(this.getImportedPackageHeader(), "");
                }
                this.fHeader.addPackage((PackageObject)importPackageObject);
            }
            ++i;
        }
    }

    private String getImportedPackageHeader() {
        return "Import-Package";
    }

    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    private void updateButtons() {
        Object[] selected = ((IStructuredSelection)this.fPackageViewer.getSelection()).toArray();
        int size = selected.length;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable() && size > 0);
        tablePart.setButtonEnabled(2, this.shouldEnableProperties(selected));
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleGoToPackage((ISelection)selection);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleOpenProperties();
            }
        }
    }

    private IPackageFragment getPackageFragment(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            if (selection.size() != 1) {
                return null;
            }
            IBaseModel model = this.getPage().getModel();
            if (!(model instanceof IPluginModelBase)) {
                return null;
            }
            return PDEJavaHelper.getPackageFragment((String)((PackageObject)selection.getFirstElement()).getName(), (String)((IPluginModelBase)model).getPluginBase().getId(), (IProject)this.getPage().getPDEEditor().getCommonProject());
        }
        return null;
    }

    private void handleGoToPackage(ISelection selection) {
        IPackageFragment frag = this.getPackageFragment(selection);
        if (frag != null) {
            try {
                IViewPart part = PDEPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
                ShowInPackageViewAction action = new ShowInPackageViewAction((IWorkbenchSite)part.getSite());
                action.run((IJavaElement)frag);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void handleOpenProperties() {
        Object[] selected = ((IStructuredSelection)this.fPackageViewer.getSelection()).toArray();
        ImportPackageObject first = (ImportPackageObject)selected[0];
        DependencyPropertiesDialog dialog = new DependencyPropertiesDialog(this.isEditable(), first);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, -1);
        if (selected.length == 1) {
            dialog.setTitle(((ImportPackageObject)selected[0]).getName());
        } else {
            dialog.setTitle(PDEUIMessages.ExportPackageSection_props);
        }
        if (dialog.open() == 0 && this.isEditable()) {
            String newVersion = dialog.getVersion();
            boolean newOptional = dialog.isOptional();
            int i = 0;
            while (i < selected.length) {
                ImportPackageObject object = (ImportPackageObject)selected[i];
                if (!newVersion.equals(object.getVersion())) {
                    object.setVersion(newVersion);
                }
                if (!newOptional == object.isOptional()) {
                    object.setOptional(newOptional);
                }
                ++i;
            }
        }
    }

    private void handleRemove() {
        Object[] removed = ((IStructuredSelection)this.fPackageViewer.getSelection()).toArray();
        int i = 0;
        while (i < removed.length) {
            this.fHeader.removePackage((PackageObject)removed[i]);
            ++i;
        }
    }

    private void handleAdd() {
        final ConditionalListSelectionDialog dialog = new ConditionalListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new ImportPackageDialogLabelProvider(), PDEUIMessages.ImportPackageSection_dialogButtonLabel);
        Runnable runnable = new Runnable(){

            public void run() {
                ImportPackageSection.this.setElements(dialog);
                dialog.setMultipleSelection(true);
                dialog.setMessage(PDEUIMessages.ImportPackageSection_exported);
                dialog.setTitle(PDEUIMessages.ImportPackageSection_selection);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            if (this.fHeader != null) {
                int i = 0;
                while (i < selected.length) {
                    ImportPackageObject impObject = null;
                    if (selected[i] instanceof ImportItemWrapper) {
                        selected[i] = ((ImportItemWrapper)selected[i]).fUnderlying;
                    }
                    if (selected[i] instanceof ExportPackageDescription) {
                        impObject = new ImportPackageObject((ManifestHeader)this.fHeader, (ExportPackageDescription)selected[i], this.getVersionAttribute());
                    } else if (selected[i] instanceof IPackageFragment) {
                        IPackageFragment fragment = (IPackageFragment)selected[i];
                        impObject = new ImportPackageObject((ManifestHeader)this.fHeader, fragment.getElementName(), null, this.getVersionAttribute());
                    } else if (selected[i] instanceof ExportPackageObject) {
                        ExportPackageObject epo = (ExportPackageObject)selected[i];
                        impObject = new ImportPackageObject((ManifestHeader)this.fHeader, epo.getName(), epo.getVersion(), this.getVersionAttribute());
                    }
                    if (impObject != null) {
                        this.fHeader.addPackage((PackageObject)impObject);
                    }
                    ++i;
                }
            } else {
                this.getBundle().setHeader("Import-Package", this.getValue(selected));
            }
        }
    }

    private String getValue(Object[] objects) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ImportItemWrapper) {
                Version version = ((ImportItemWrapper)objects[i]).getVersion();
                if (buffer.length() > 0) {
                    buffer.append("," + this.getLineDelimiter() + " ");
                }
                buffer.append(((ImportItemWrapper)objects[i]).getName());
                if (version != null && !version.equals((Object)Version.emptyVersion)) {
                    buffer.append(";");
                    buffer.append(this.getVersionAttribute());
                    buffer.append("=\"");
                    buffer.append(version.toString());
                    buffer.append("\"");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private void setElements(ConditionalListSelectionDialog dialog) {
        String name;
        Set forbidden = this.getForbiddenIds();
        boolean allowJava = "true".equals(this.getBundle().getHeader("Eclipse-JREBundle"));
        ArrayList<ImportItemWrapper> elements = new ArrayList<ImportItemWrapper>();
        ArrayList<ImportItemWrapper> conditional = new ArrayList<ImportItemWrapper>();
        IPluginModelBase[] models = PluginRegistry.getActiveModels();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < models.length) {
            String id;
            BundleDescription desc = models[i].getBundleDescription();
            String string = id = desc == null ? null : desc.getSymbolicName();
            if (id != null && !forbidden.contains(id)) {
                ExportPackageHeader header;
                IBundleModel bmodel;
                ExportPackageDescription[] exported = desc.getExportPackages();
                int j = 0;
                while (j < exported.length) {
                    String name2 = exported[j].getName();
                    if (!(("java".equals(name2) || name2.startsWith("java.")) && !allowJava || !names.add(name2) || this.fHeader != null && this.fHeader.hasPackage(name2))) {
                        elements.add(new ImportItemWrapper(exported[j]));
                    }
                    ++j;
                }
                IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
                if (model instanceof IBundlePluginModelBase && (bmodel = ((IBundlePluginModelBase)model).getBundleModel()) != null && (header = (ExportPackageHeader)bmodel.getBundle().getManifestHeader("Export-Package")) != null) {
                    ExportPackageObject[] pkgs = header.getPackages();
                    int j2 = 0;
                    while (j2 < pkgs.length) {
                        name = pkgs[j2].getName();
                        if (names.add(name) && (this.fHeader == null || !this.fHeader.hasPackage(name))) {
                            elements.add(new ImportItemWrapper(pkgs[j2]));
                        }
                        ++j2;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < models.length) {
            try {
                IProject project;
                IResource resource = models[i].getUnderlyingResource();
                IProject iProject = project = resource != null ? resource.getProject() : null;
                if (project != null && project.hasNature("org.eclipse.jdt.core.javanature") && !WorkspaceModelManager.isBinaryProject((IProject)project) && project.exists(ICoreConstants.MANIFEST_PATH)) {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        if (roots[j].getKind() == 1 || roots[j].getKind() == 2 && !roots[j].isExternal()) {
                            IJavaElement[] children = roots[j].getChildren();
                            int k = 0;
                            while (k < children.length) {
                                IPackageFragment f = (IPackageFragment)children[k];
                                name = f.getElementName();
                                if (name.equals("")) {
                                    name = ".";
                                }
                                if ((f.hasChildren() || f.getNonJavaResources().length > 0) && names.add(name)) {
                                    conditional.add(new ImportItemWrapper(f));
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        dialog.setElements(elements.toArray());
        dialog.setConditionalElements(conditional.toArray());
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.fHeader = null;
            this.markStale();
            return;
        }
        if ("Import-Package".equals(event.getChangedProperty())) {
            this.refresh();
            return;
        }
        Object[] objects = event.getChangedObjects();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ImportPackageObject) {
                ImportPackageObject object = (ImportPackageObject)objects[i];
                switch (event.getChangeType()) {
                    case 1: {
                        this.fPackageViewer.add((Object)object);
                        this.fPackageViewer.setSelection((ISelection)new StructuredSelection((Object)object));
                        this.fPackageViewer.getTable().setFocus();
                        break;
                    }
                    case 2: {
                        Table table = this.fPackageViewer.getTable();
                        int index = table.getSelectionIndex();
                        this.fPackageViewer.remove((Object)object);
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                        break;
                    }
                    default: {
                        this.fPackageViewer.refresh((Object)object);
                    }
                }
            }
            ++i;
        }
    }

    public void refresh() {
        this.fPackageViewer.refresh();
        super.refresh();
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiresSection_add){

            public void run() {
                ImportPackageSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fGoToAction = new Action(PDEUIMessages.ImportPackageSection_goToPackage){

            public void run() {
                ImportPackageSection.this.handleGoToPackage(ImportPackageSection.this.fPackageViewer.getSelection());
            }
        };
        this.fRemoveAction = new Action(PDEUIMessages.RequiresSection_delete){

            public void run() {
                ImportPackageSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fPropertiesAction = new Action(PDEUIMessages.ImportPackageSection_propertyAction){

            public void run() {
                ImportPackageSection.this.handleOpenProperties();
            }
        };
    }

    protected void fillContextMenu(IMenuManager manager) {
        boolean singleSelection;
        final ISelection selection = this.fPackageViewer.getSelection();
        manager.add((IAction)this.fAddAction);
        boolean bl = singleSelection = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
        if (singleSelection) {
            manager.add((IAction)this.fGoToAction);
        }
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        if (((IModel)this.getPage().getModel()).getUnderlyingResource() != null) {
            manager.add((IContributionItem)new Separator());
            if (singleSelection) {
                manager.add((IAction)new Action(PDEUIMessages.DependencyExtentSearchResultPage_referencesInPlugin){

                    public void run() {
                        ImportPackageSection.this.doReferenceSearch(selection);
                    }
                });
            }
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)this.getPage().getModel(), false));
        }
        if (this.shouldEnableProperties(((IStructuredSelection)this.fPackageViewer.getSelection()).toArray())) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fPropertiesAction);
        }
    }

    private void doReferenceSearch(ISelection sel) {
        IPackageFragmentRoot[] roots = null;
        try {
            roots = this.getSourceRoots();
        }
        catch (JavaModelException javaModelException) {}
        IPackageFragment fragment = this.getPackageFragment(sel);
        if (fragment != null && roots != null) {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet set = manager.createWorkingSet("temp", (IAdaptable[])roots);
            new FindReferencesInWorkingSetAction((IWorkbenchSite)this.getPage().getEditorSite(), new IWorkingSet[]{set}).run((IJavaElement)fragment);
            manager.removeWorkingSet(set);
        } else if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            PackageObject importObject = (PackageObject)selection.getFirstElement();
            NewSearchUI.runQueryInBackground((ISearchQuery)new BlankQuery(importObject));
        }
    }

    private IPackageFragmentRoot[] getSourceRoots() throws JavaModelException {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1 || roots[i].isArchive() && !roots[i].isExternal()) {
                result.add(roots[i]);
            }
            ++i;
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    private IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context != null ? (IBundleModel)context.getModel() : null;
    }

    private String getLineDelimiter() {
        BundleInputContext inputContext = this.getBundleContext();
        if (inputContext != null) {
            return inputContext.getLineDelimiter();
        }
        return System.getProperty("line.separator");
    }

    private IBundle getBundle() {
        IBundleModel model = this.getBundleModel();
        return model != null ? model.getBundle() : null;
    }

    private String getVersionAttribute() {
        return this.getVersionAttribute(this.getBundle());
    }

    private String getVersionAttribute(IBundle bundle) {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle);
        return manifestVersion < 2 ? "specification-version" : "version";
    }

    private Set getForbiddenIds() {
        HashSet<String> set = new HashSet<String>();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
        String id = model.getPluginBase().getId();
        if (id != null) {
            set.add(id);
        }
        IPluginImport[] imports = model.getPluginBase().getImports();
        State state = TargetPlatformHelper.getState();
        int i = 0;
        while (i < imports.length) {
            this.addDependency(state, imports[i].getId(), set);
            ++i;
        }
        return set;
    }

    private void addDependency(State state, String bundleID, Set set) {
        if (bundleID == null || !set.add(bundleID)) {
            return;
        }
        BundleDescription desc = state.getBundle(bundleID, null);
        if (desc == null) {
            return;
        }
        BundleDescription[] fragments = desc.getFragments();
        int i = 0;
        while (i < fragments.length) {
            this.addDependency(state, fragments[i].getSymbolicName(), set);
            ++i;
        }
        BundleSpecification[] specs = desc.getRequiredBundles();
        int j = 0;
        while (j < specs.length) {
            if (specs[j].isResolved() && specs[j].isExported()) {
                this.addDependency(state, specs[j].getName(), set);
            }
            ++j;
        }
    }

    protected boolean createCount() {
        return true;
    }

    private boolean shouldEnableProperties(Object[] selected) {
        if (selected.length == 0) {
            return false;
        }
        if (selected.length == 1) {
            return true;
        }
        String version = ((ImportPackageObject)selected[0]).getVersion();
        boolean optional = ((ImportPackageObject)selected[0]).isOptional();
        int i = 1;
        while (i < selected.length) {
            ImportPackageObject object = (ImportPackageObject)selected[i];
            if (version == null ? object.getVersion() != null || optional != object.isOptional() : !version.equals(object.getVersion()) || optional != object.isOptional()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class ImportItemWrapper {
        Object fUnderlying;

        public ImportItemWrapper(Object underlying) {
            this.fUnderlying = underlying;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImportItemWrapper) {
                ImportItemWrapper item = (ImportItemWrapper)obj;
                return this.getName().equals(item.getName());
            }
            return false;
        }

        public String getName() {
            if (this.fUnderlying instanceof ExportPackageDescription) {
                return ((ExportPackageDescription)this.fUnderlying).getName();
            }
            if (this.fUnderlying instanceof IPackageFragment) {
                return ((IPackageFragment)this.fUnderlying).getElementName();
            }
            if (this.fUnderlying instanceof ExportPackageObject) {
                return ((ExportPackageObject)this.fUnderlying).getName();
            }
            return null;
        }

        public Version getVersion() {
            String version;
            if (this.fUnderlying instanceof ExportPackageDescription) {
                return ((ExportPackageDescription)this.fUnderlying).getVersion();
            }
            if (this.fUnderlying instanceof ExportPackageObject && (version = ((ExportPackageObject)this.fUnderlying).getVersion()) != null) {
                return new Version(version);
            }
            return null;
        }

        boolean hasVersion() {
            return this.hasEPD() && ((ExportPackageDescription)this.fUnderlying).getVersion() != null;
        }

        boolean hasEPD() {
            return this.fUnderlying instanceof ExportPackageDescription;
        }
    }

    class ImportPackageContentProvider
    extends DefaultTableProvider {
        ImportPackageContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (ImportPackageSection.this.fHeader == null) {
                Bundle bundle = (Bundle)ImportPackageSection.this.getBundle();
                ImportPackageSection.this.fHeader = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
            }
            return ImportPackageSection.this.fHeader == null ? new Object[]{} : ImportPackageSection.this.fHeader.getPackages();
        }
    }

    class ImportPackageDialogLabelProvider
    extends LabelProvider {
        ImportPackageDialogLabelProvider() {
        }

        public Image getImage(Object element) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }

        public String getText(Object element) {
            StringBuffer buffer = new StringBuffer();
            ImportItemWrapper p = (ImportItemWrapper)element;
            buffer.append(p.getName());
            Version version = p.getVersion();
            if (version != null && !Version.emptyVersion.equals((Object)version)) {
                buffer.append(' ');
                buffer.append(PDELabelProvider.formatVersion(version.toString()));
            }
            return buffer.toString();
        }
    }
}

