/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormFilteredTree
extends FilteredTree {
    private FormToolkit toolkit;
    private FormEntry fEntryFilter;

    public FormFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
    }

    protected void createControl(Composite parent, int treeStyle) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        GridLayout layout = FormLayoutFactory.createClearGridLayout(false, 1);
        layout.verticalSpacing = 3;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = FormLayoutFactory.createClearGridLayout(false, 2);
            filterLayout.horizontalSpacing = 5;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        this.treeComposite.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected Text doCreateFilterText(Composite parent) {
        int style = 4 | this.toolkit.getBorderStyle();
        this.fEntryFilter = new FormEntry(parent, this.toolkit, null, style);
        this.toolkit.paintBordersFor(parent);
        this.setBackground(this.toolkit.getColors().getBackground());
        return this.fEntryFilter.getText();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer = super.doCreateTreeViewer(parent, this.toolkit.getBorderStyle());
        this.toolkit.paintBordersFor(viewer.getTree().getParent());
        return viewer;
    }

    public void createUIListenerEntryFilter(IContextPart part) {
        this.fEntryFilter.setFormEntryListener(new FormEntryAdapter(part){

            public void browseButtonSelected(FormEntry entry) {
            }

            public void linkActivated(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void selectionChanged(FormEntry entry) {
            }

            public void textDirty(FormEntry entry) {
            }

            public void textValueChanged(FormEntry entry) {
            }
        });
    }
}

