/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.plugin.IDocumentElement;
import org.eclipse.pde.internal.core.text.plugin.IDocumentExtension;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLElementProposalComputer;
import org.eclipse.pde.internal.ui.editor.plugin.FormFilteredTree;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.plugin.NewElementAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionEditorWizard;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionWizard;
import org.eclipse.pde.ui.IExtensionEditorWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExtensionsSection
extends TreeSection
implements IModelChangedListener,
IPropertyChangeListener {
    private TreeViewer fExtensionTree;
    private Image fExtensionImage;
    private Image fGenericElementImage;
    private FormFilteredTree fFilteredTree;
    private SchemaRegistry fSchemaRegistry;
    private Action fNewExtensionAction;
    private Hashtable fEditorWizards;
    private SortAction fSortAction;
    private CollapseAction fCollapseAction;
    private static final String[] COMMON_LABEL_PROPERTIES = new String[]{"label", "name", "id"};

    public ExtensionsSection(PDEFormPage page, Composite parent) {
        String[] stringArray = new String[5];
        stringArray[0] = PDEUIMessages.ManifestEditor_DetailExtension_new;
        stringArray[1] = PDEUIMessages.ManifestEditor_DetailExtension_edit;
        stringArray[3] = PDEUIMessages.ManifestEditor_DetailExtension_up;
        stringArray[4] = PDEUIMessages.ManifestEditor_DetailExtension_down;
        super(page, parent, 128, stringArray);
        this.fHandleDefaultButton = false;
    }

    private static void addItemsForExtensionWithSchema(MenuManager menu, IPluginExtension extension, IPluginParent parent) {
        String tagName;
        ISchema schema = ExtensionsSection.getSchema(extension);
        ISchemaElement elementInfo = schema.findElement(tagName = parent == extension ? "extension" : parent.getName());
        if (elementInfo != null && elementInfo.getType() instanceof ISchemaComplexType && parent instanceof IDocumentNode) {
            HashSet elementSet = XMLElementProposalComputer.computeElementProposal(elementInfo, (IDocumentNode)parent);
            Iterator iterator = elementSet.iterator();
            while (iterator.hasNext()) {
                NewElementAction action = new NewElementAction((ISchemaElement)iterator.next(), parent);
                menu.add((IAction)action);
            }
        }
    }

    private static ISchema getSchema(IPluginParent parent) {
        if (parent instanceof IPluginExtension) {
            return ExtensionsSection.getSchema((IPluginExtension)parent);
        }
        if (parent instanceof IPluginElement) {
            return ExtensionsSection.getSchema((IPluginElement)parent);
        }
        return null;
    }

    private static ISchema getSchema(IPluginExtension extension) {
        String point = extension.getPoint();
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        return registry.getSchema(point);
    }

    static ISchemaElement getSchemaElement(IPluginElement element) {
        ISchema schema = ExtensionsSection.getSchema(element);
        if (schema != null) {
            return schema.findElement(element.getName());
        }
        return null;
    }

    private static ISchema getSchema(IPluginElement element) {
        IPluginObject parent = element.getParent();
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ExtensionsSection.getSchema((IPluginExtension)parent);
        }
        return null;
    }

    public void createClient(Section section, FormToolkit toolkit) {
        this.initializeImages();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fExtensionTree = treePart.getTreeViewer();
        this.fExtensionTree.setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.fExtensionTree.setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setDescription(PDEUIMessages.ExtensionsSection_sectionDescExtensionsMaster);
        section.setText(PDEUIMessages.ManifestEditor_DetailExtension_title);
        this.initialize((IPluginModelBase)this.getPage().getModel());
        this.createSectionToolbar(section, toolkit);
        this.fFilteredTree.createUIListenerEntryFilter(this);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fSortAction = new SortAction((StructuredViewer)this.fExtensionTree, PDEUIMessages.ExtensionsPage_sortAlpha, null, null, this);
        toolBarManager.add((IAction)this.fSortAction);
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fExtensionTree, PDEUIMessages.ExtensionsPage_collapseAll);
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateUpDownButtons(selection.getFirstElement());
        this.getTreePart().setButtonEnabled(1, this.isSelectionEditable(selection));
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.handleMove(true);
                break;
            }
            case 4: {
                this.handleMove(false);
            }
        }
    }

    public void dispose() {
        if (this.fFilteredTree != null) {
            this.fFilteredTree.dispose();
        }
        this.fEditorWizards = null;
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginExtension || object instanceof IPluginElement) {
            this.fExtensionTree.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object object;
        ISelection selection = this.fExtensionTree.getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        MenuManager newMenu = null;
        if (ssel.size() == 1) {
            IPluginParent parent;
            object = ssel.getFirstElement();
            if (object instanceof IPluginParent && (parent = (IPluginParent)object).getModel().getUnderlyingResource() != null) {
                newMenu = ExtensionsSection.fillContextMenu(this.getPage(), parent, manager);
                manager.add((IContributionItem)new Separator());
            }
        } else if (ssel.size() > 1) {
            Action delAction = new Action(){

                public void run() {
                    ExtensionsSection.this.handleDelete();
                }
            };
            delAction.setText(PDEUIMessages.Actions_delete_label);
            manager.add((IAction)delAction);
            manager.add((IContributionItem)new Separator());
            delAction.setEnabled(this.isEditable());
        }
        if (newMenu == null) {
            newMenu = new MenuManager(PDEUIMessages.Menus_new_label);
            manager.add((IContributionItem)newMenu);
        }
        if (ssel.size() == 1) {
            manager.add((IContributionItem)new Separator());
            object = ssel.getFirstElement();
            if (object instanceof IPluginExtension) {
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext(selection));
                actionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator());
            }
        }
        if (!newMenu.isEmpty()) {
            newMenu.add((IContributionItem)new Separator());
        }
        newMenu.add((IAction)this.fNewExtensionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().addClipboardActions(manager);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager) {
        return ExtensionsSection.fillContextMenu(page, parent, manager, false);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager, boolean addSiblingItems) {
        return ExtensionsSection.fillContextMenu(page, parent, manager, addSiblingItems, true);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, final IPluginParent parent, IMenuManager manager, boolean addSiblingItems, boolean fullMenu) {
        MenuManager menu = new MenuManager(PDEUIMessages.Menus_new_label);
        IPluginExtension extension = ExtensionsSection.getExtension(parent);
        ISchema schema = ExtensionsSection.getSchema(extension);
        if (schema == null) {
            menu.add((IAction)new NewElementAction(null, parent));
        } else {
            IPluginObject parentsParent;
            ExtensionsSection.addItemsForExtensionWithSchema(menu, extension, parent);
            if (addSiblingItems && !((parentsParent = parent.getParent()) instanceof IPluginExtension)) {
                IPluginParent pparent = (IPluginParent)parentsParent;
                menu.add((IContributionItem)new Separator());
                ExtensionsSection.addItemsForExtensionWithSchema(menu, extension, pparent);
            }
        }
        manager.add((IContributionItem)menu);
        manager.add((IContributionItem)new Separator());
        if (fullMenu) {
            Action deleteAction = new Action(PDEUIMessages.Actions_delete_label){

                public void run() {
                    try {
                        IPluginObject parentsParent = parent.getParent();
                        if (parent instanceof IPluginExtension) {
                            IPluginBase plugin = (IPluginBase)parentsParent;
                            plugin.remove((IPluginExtension)parent);
                        } else {
                            IPluginParent parentElement = (IPluginParent)parent.getParent();
                            parentElement.remove((IPluginObject)parent);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            deleteAction.setEnabled(page.getModel().isEditable());
            manager.add((IAction)deleteAction);
        }
        return menu;
    }

    static IPluginExtension getExtension(IPluginParent parent) {
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = (IPluginParent)parent.getParent();
        }
        return (IPluginExtension)parent;
    }

    private void handleDelete() {
        IStructuredSelection sel = (IStructuredSelection)this.fExtensionTree.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            IPluginObject object = (IPluginObject)iter.next();
            try {
                if (object instanceof IPluginElement) {
                    IPluginElement ee = (IPluginElement)object;
                    IPluginParent parent = (IPluginParent)ee.getParent();
                    parent.remove((IPluginObject)ee);
                    continue;
                }
                if (!(object instanceof IPluginExtension)) continue;
                IPluginExtension extension = (IPluginExtension)object;
                IPluginBase plugin = extension.getPluginBase();
                plugin.remove(extension);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNew() {
        final IProject project = this.getPage().getPDEEditor().getCommonProject();
        BusyIndicator.showWhile((Display)this.fExtensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ((ManifestEditor)ExtensionsSection.this.getPage().getEditor()).ensurePluginContextPresence();
                NewExtensionWizard wizard = new NewExtensionWizard(this, project, (IPluginModelBase)ExtensionsSection.this.getPage().getModel(), (ManifestEditor)ExtensionsSection.this.getPage().getPDEEditor()){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean performFinish() {
                        return super.performFinish();
                    }
                };
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                dialog.open();
            }
        });
    }

    private void handleEdit(IConfigurationElement element, IStructuredSelection selection) {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        try {
            final IExtensionEditorWizard wizard = (IExtensionEditorWizard)element.createExecutableExtension("class");
            wizard.init(project, model, selection);
            BusyIndicator.showWhile((Display)this.fExtensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                    dialog.open();
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fExtensionTree.getSelection();
        ArrayList editorWizards = this.getEditorWizards(selection);
        if (editorWizards == null) {
            return;
        }
        if (editorWizards.size() == 1) {
            this.handleEdit((IConfigurationElement)editorWizards.get(0), selection);
        } else {
            IProject project = this.getPage().getPDEEditor().getCommonProject();
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            final ExtensionEditorWizard wizard = new ExtensionEditorWizard(project, model, selection);
            BusyIndicator.showWhile((Display)this.fExtensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                    dialog.open();
                }
            });
        }
    }

    private ArrayList getEditorWizards(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object obj = selection.getFirstElement();
        String pointId = null;
        if (obj instanceof IPluginExtension) {
            pointId = ((IPluginExtension)obj).getPoint();
        } else if (obj instanceof IPluginElement) {
            IPluginObject parent = ((IPluginElement)obj).getParent();
            while (parent != null) {
                if (parent instanceof IPluginExtension) {
                    pointId = ((IPluginExtension)parent).getPoint();
                    break;
                }
                parent = parent.getParent();
            }
        }
        if (pointId == null) {
            return null;
        }
        if (this.fEditorWizards == null) {
            this.loadExtensionWizards();
        }
        return (ArrayList)this.fEditorWizards.get(pointId);
    }

    private void loadExtensionWizards() {
        this.fEditorWizards = new Hashtable();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.newExtension");
        int i = 0;
        while (i < elements.length) {
            String pointId;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("editorWizard") && (pointId = element.getAttribute("point")) != null) {
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)this.fEditorWizards.get(pointId);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    this.fEditorWizards.put(pointId, list);
                }
                list.add(element);
            }
            ++i;
        }
    }

    private boolean isSelectionEditable(IStructuredSelection selection) {
        if (!this.getPage().getModel().isEditable()) {
            return false;
        }
        return this.getEditorWizards(selection) != null;
    }

    public void initialize(IPluginModelBase model) {
        this.fExtensionTree.setInput((Object)model.getPluginBase());
        this.selectFirstExtension();
        boolean editable = model.isEditable();
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, editable);
        treePart.setButtonEnabled(1, false);
        treePart.setButtonEnabled(3, false);
        treePart.setButtonEnabled(4, false);
        model.addModelChangedListener((IModelChangedListener)this);
        this.fNewExtensionAction = new Action(){

            public void run() {
                ExtensionsSection.this.handleNew();
            }
        };
        this.fNewExtensionAction.setText(PDEUIMessages.ManifestEditor_DetailExtension_newExtension);
        this.fNewExtensionAction.setImageDescriptor(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.fNewExtensionAction.setEnabled(editable);
    }

    private void selectFirstExtension() {
        Tree tree = this.fExtensionTree.getTree();
        TreeItem[] items = tree.getItems();
        if (items.length == 0) {
            return;
        }
        TreeItem firstItem = items[0];
        Object obj = firstItem.getData();
        this.fExtensionTree.setSelection((ISelection)new StructuredSelection(obj));
    }

    void fireSelection() {
        this.fExtensionTree.setSelection(this.fExtensionTree.getSelection());
    }

    public void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.fExtensionImage = provider.get(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.fGenericElementImage = provider.get(PDEPluginImages.DESC_GENERIC_XML_OBJ);
    }

    public void refresh() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        this.fExtensionTree.setInput((Object)model.getPluginBase());
        this.selectFirstExtension();
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.fExtensionTree.getSelection());
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginBase && event.getChangeType() == 3 && event.getChangedProperty().equals("extension_order")) {
            IStructuredSelection sel = (IStructuredSelection)this.fExtensionTree.getSelection();
            IPluginExtension extension = (IPluginExtension)sel.getFirstElement();
            this.fExtensionTree.refresh();
            this.fExtensionTree.setSelection((ISelection)new StructuredSelection((Object)extension));
            return;
        }
        if (changeObject instanceof IPluginExtension || changeObject instanceof IPluginElement && ((IPluginElement)changeObject).getParent() instanceof IPluginParent) {
            IPluginObject parent;
            IPluginObject pobj = (IPluginObject)changeObject;
            Object object = parent = changeObject instanceof IPluginExtension ? ((IPluginModelBase)this.getPage().getModel()).getPluginBase() : pobj.getParent();
            if (event.getChangeType() == 1) {
                this.fExtensionTree.add((Object)parent, (Object)pobj);
                this.fExtensionTree.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.fExtensionTree.getTree().setFocus();
            } else if (event.getChangeType() == 2) {
                this.fExtensionTree.remove((Object)pobj);
            } else if (event.getChangedProperty().equals("sibling_order")) {
                IStructuredSelection sel = (IStructuredSelection)this.fExtensionTree.getSelection();
                IPluginObject child = (IPluginObject)sel.getFirstElement();
                this.fExtensionTree.refresh((Object)child.getParent());
                this.fExtensionTree.setSelection((ISelection)new StructuredSelection((Object)child));
            } else {
                this.fExtensionTree.update(changeObject, null);
            }
        }
    }

    private Image resolveObjectImage(Object obj) {
        if (obj instanceof IPluginExtension) {
            return this.fExtensionImage;
        }
        Image elementImage = this.fGenericElementImage;
        if (obj instanceof IPluginElement) {
            String bodyText;
            boolean hasBodyText;
            IPluginElement element = (IPluginElement)obj;
            Image customImage = ExtensionsSection.getCustomImage(element);
            if (customImage != null) {
                elementImage = customImage;
            }
            boolean bl = hasBodyText = (bodyText = element.getText()) != null && bodyText.length() > 0;
            if (hasBodyText) {
                elementImage = PDEPlugin.getDefault().getLabelProvider().get(elementImage, 8);
            }
        }
        return elementImage;
    }

    private static boolean isStorageModel(IPluginObject object) {
        IPluginModelBase modelBase = object.getPluginModel();
        return modelBase.getInstallLocation() == null;
    }

    static Image getCustomImage(IPluginElement element) {
        if (ExtensionsSection.isStorageModel((IPluginObject)element)) {
            return null;
        }
        ISchemaElement elementInfo = ExtensionsSection.getSchemaElement(element);
        if (elementInfo != null && elementInfo.getIconProperty() != null) {
            String iconProperty = elementInfo.getIconProperty();
            IPluginAttribute att = element.getAttribute(iconProperty);
            String iconPath = null;
            if (att != null && att.getValue() != null) {
                iconPath = att.getValue();
            }
            if (iconPath != null) {
                return ExtensionsSection.getImageFromPlugin(element, iconPath);
            }
        }
        return null;
    }

    private static Image getImageFromPlugin(IPluginElement element, String iconPathName) {
        if (iconPathName.startsWith("%")) {
            return null;
        }
        IPluginModelBase model = element.getPluginModel();
        if (model == null) {
            return null;
        }
        return PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(model, iconPathName);
    }

    private String resolveObjectName(Object obj) {
        return ExtensionsSection.resolveObjectName(this.getSchemaRegistry(), obj);
    }

    private SchemaRegistry getSchemaRegistry() {
        if (this.fSchemaRegistry == null) {
            this.fSchemaRegistry = PDECore.getDefault().getSchemaRegistry();
        }
        return this.fSchemaRegistry;
    }

    public static String resolveObjectName(SchemaRegistry schemaRegistry, Object obj) {
        boolean fullNames = PDEPlugin.isFullNameModeEnabled();
        if (obj instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)obj;
            if (!fullNames) {
                return extension.getPoint();
            }
            if (extension.getName() != null) {
                return extension.getTranslatedName();
            }
            ISchema schema = schemaRegistry.getSchema(extension.getPoint());
            if (schema != null) {
                return schema.getName();
            }
            return extension.getPoint();
        }
        if (obj instanceof IPluginElement) {
            IPluginElement element = (IPluginElement)obj;
            String baseName = element.getName();
            String fullName = null;
            ISchemaElement elementInfo = ExtensionsSection.getSchemaElement(element);
            IPluginAttribute labelAtt = null;
            if (elementInfo != null && elementInfo.getLabelProperty() != null) {
                labelAtt = element.getAttribute(elementInfo.getLabelProperty());
            }
            if (labelAtt == null) {
                int i = 0;
                while (i < COMMON_LABEL_PROPERTIES.length) {
                    labelAtt = element.getAttribute(COMMON_LABEL_PROPERTIES[i]);
                    if (labelAtt != null) break;
                    ++i;
                }
                if (labelAtt == null && element.getAttributeCount() == 1) {
                    labelAtt = element.getAttributes()[0];
                }
            }
            if (labelAtt != null && labelAtt.getValue() != null) {
                fullName = ExtensionsSection.stripShortcuts(labelAtt.getValue());
            }
            fullName = element.getResourceString(fullName);
            if (fullNames) {
                return fullName != null ? fullName : baseName;
            }
            if (fullName == null) {
                return baseName;
            }
            if (BidiUtil.isBidiPlatform()) {
                return String.valueOf(fullName) + " \u200f(\u200e" + baseName + ')';
            }
            return String.valueOf(fullName) + " (" + baseName + ')';
        }
        return obj.toString();
    }

    public void setFocus() {
        if (this.fExtensionTree != null) {
            this.fExtensionTree.getTree().setFocus();
        }
    }

    public static String stripShortcuts(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != '&') {
                if (c == '@') break;
                output.append(c);
            }
            ++i;
        }
        return output.toString();
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        boolean allExtensions = true;
        boolean allElements = true;
        int i = 0;
        while (i < sourceObjects.length) {
            if (sourceObjects[i] instanceof IPluginExtension) {
                allElements = false;
            } else if (sourceObjects[i] instanceof IPluginElement) {
                allExtensions = false;
            } else {
                return false;
            }
            ++i;
        }
        if (allExtensions) {
            return true;
        }
        if (!allElements) {
            return false;
        }
        if (!(targetObject instanceof IPluginParent)) {
            return false;
        }
        if (!(targetObject instanceof IDocumentNode)) {
            return false;
        }
        IPluginParent targetParent = (IPluginParent)targetObject;
        ISchema schema = ExtensionsSection.getSchema(targetParent);
        if (schema == null) {
            return true;
        }
        String tagName = null;
        tagName = targetParent instanceof IPluginExtension ? "extension" : targetParent.getName();
        ISchemaElement schemaElement = schema.findElement(tagName);
        if (schemaElement == null) {
            return false;
        }
        if (!(schemaElement.getType() instanceof ISchemaComplexType)) {
            return false;
        }
        HashSet elementSet = XMLElementProposalComputer.computeElementProposal(schemaElement, (IDocumentNode)targetObject);
        if (sourceObjects.length > 1) {
            return this.canPasteSourceElements((IPluginElement[])sourceObjects, elementSet);
        }
        return this.canPasteSourceElement((IPluginElement)sourceObjects[0], elementSet);
    }

    private boolean canPasteSourceElements(IPluginElement[] sourceElements, HashSet targetElementSet) {
        HashSet<String> targetElementNameSet = new HashSet<String>();
        Iterator iterator = targetElementSet.iterator();
        while (iterator.hasNext()) {
            targetElementNameSet.add(((ISchemaElement)iterator.next()).getName());
        }
        int i = 0;
        while (i < sourceElements.length) {
            String sourceTagName = sourceElements[i].getName();
            if (!targetElementNameSet.contains(sourceTagName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canPasteSourceElement(IPluginElement sourceElement, HashSet targetElementSet) {
        boolean canPaste = false;
        String sourceTagName = sourceElement.getName();
        Iterator iterator = targetElementSet.iterator();
        while (iterator.hasNext()) {
            String targetTagName = ((ISchemaElement)iterator.next()).getName();
            if (!sourceTagName.equals(targetTagName)) continue;
            canPaste = true;
            break;
        }
        return canPaste;
    }

    private IPluginModelBase getPluginModelBase() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (!(model instanceof IBundlePluginModelBase)) {
            return null;
        }
        ISharedExtensionsModel extensionModel = ((IBundlePluginModelBase)model).getExtensionsModel();
        if (extensionModel == null || !(extensionModel instanceof IPluginModelBase)) {
            return null;
        }
        return (IPluginModelBase)extensionModel;
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        ((ManifestEditor)this.getPage().getEditor()).ensurePluginContextPresence();
        IPluginModelBase model = this.getPluginModelBase();
        if (model == null) {
            return;
        }
        IPluginBase pluginBase = model.getPluginBase();
        try {
            int i = 0;
            while (i < sourceObjects.length) {
                ISchema schema;
                Object sourceObject = sourceObjects[i];
                if (sourceObject instanceof IDocumentExtension && sourceObject instanceof IPluginExtension && pluginBase instanceof IDocumentNode) {
                    IDocumentExtension extension = (IDocumentExtension)sourceObject;
                    schema = ExtensionsSection.getSchema((IPluginExtension)extension);
                    extension.reconnect((ISharedPluginModel)model, schema, (IDocumentNode)pluginBase);
                    pluginBase.add((IPluginExtension)extension);
                } else if (sourceObject instanceof IDocumentElement && sourceObject instanceof IPluginElement && targetObject instanceof IPluginParent && targetObject instanceof IDocumentNode) {
                    IDocumentElement element = (IDocumentElement)sourceObject;
                    schema = ExtensionsSection.getSchema((IPluginElement)element);
                    element.reconnect((ISharedPluginModel)model, schema, (IDocumentNode)targetObject);
                    ((IPluginParent)targetObject).add((IPluginObject)((IPluginElement)element));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleMove(boolean up) {
        IStructuredSelection sel = (IStructuredSelection)this.fExtensionTree.getSelection();
        IPluginObject object = (IPluginObject)sel.getFirstElement();
        if (object instanceof IPluginElement) {
            IPluginParent parent = (IPluginParent)object.getParent();
            IPluginObject[] children = parent.getChildren();
            int index = parent.getIndexOf(object);
            int newIndex = up ? index - 1 : index + 1;
            IPluginObject child2 = children[newIndex];
            try {
                parent.swap(object, child2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else if (object instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)object;
            IPluginBase plugin = extension.getPluginBase();
            IPluginExtension[] extensions = plugin.getExtensions();
            int index = plugin.getIndexOf(extension);
            int newIndex = up ? index - 1 : index + 1;
            IPluginExtension e2 = extensions[newIndex];
            try {
                plugin.swap(extension, e2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void updateUpDownButtons(Object item) {
        boolean sorted;
        if (!this.getPage().getModel().isEditable()) {
            return;
        }
        boolean bl = sorted = this.fSortAction != null && this.fSortAction.isChecked();
        if (sorted) {
            this.getTreePart().setButtonEnabled(3, false);
            this.getTreePart().setButtonEnabled(4, false);
            return;
        }
        boolean upEnabled = false;
        boolean downEnabled = false;
        if (item instanceof IPluginElement) {
            IPluginElement element = (IPluginElement)item;
            IPluginParent parent = (IPluginParent)element.getParent();
            int index = parent.getIndexOf((IPluginObject)element);
            if (index > 0) {
                upEnabled = true;
            }
            if (index < parent.getChildCount() - 1) {
                downEnabled = true;
            }
        } else if (item instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)item;
            IExtensions extensions = (IExtensions)extension.getParent();
            int index = extensions.getIndexOf(extension);
            int size = extensions.getExtensions().length;
            if (index > 0) {
                upEnabled = true;
            }
            if (index < size - 1) {
                downEnabled = true;
            }
        }
        this.getTreePart().setButtonEnabled(3, upEnabled);
        this.getTreePart().setButtonEnabled(4, downEnabled);
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.fFilteredTree = new FormFilteredTree(parent, style, new PatternFilter());
        parent.setData("filtered", (Object)Boolean.TRUE);
        return this.fFilteredTree.getViewer();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (((Object)((Object)this.fSortAction)).equals(event.getSource()) && "result".equals(event.getProperty())) {
            StructuredViewer viewer = this.getStructuredViewerPart().getViewer();
            IStructuredSelection ssel = (IStructuredSelection)viewer.getSelection();
            this.updateUpDownButtons(ssel.size() != 1 ? null : ssel.getFirstElement());
        }
    }

    protected void selectExtensionElement(ISelection selection) {
        this.fExtensionTree.setSelection(selection, true);
    }

    class ExtensionContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ExtensionContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Object[] children = null;
            if (parent instanceof IPluginBase) {
                children = ((IPluginBase)parent).getExtensions();
            } else if (parent instanceof IPluginExtension) {
                children = ((IPluginExtension)parent).getChildren();
            } else if (parent instanceof IPluginElement) {
                children = ((IPluginElement)parent).getChildren();
            }
            if (children == null) {
                children = new Object[]{};
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginExtension) {
                return ((IPluginModelBase)ExtensionsSection.this.getPage().getModel()).getPluginBase();
            }
            if (child instanceof IPluginObject) {
                return ((IPluginObject)child).getParent();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }
    }

    class ExtensionLabelProvider
    extends LabelProvider {
        ExtensionLabelProvider() {
        }

        public String getText(Object obj) {
            return ExtensionsSection.this.resolveObjectName(obj);
        }

        public Image getImage(Object obj) {
            return ExtensionsSection.this.resolveObjectImage(obj);
        }
    }
}

