/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple.details;

import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSHelpObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.cheatsheet.CSAbstractSubDetails;
import org.eclipse.pde.internal.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SimpleCSHelpDetails
extends CSAbstractSubDetails {
    private Text fHelpText = null;
    private ComboPart fHelpCombo = null;
    private Label fHelpLabel = null;
    private ISimpleCSHelpObject fHelpObject = null;
    private Section fHelpSection = null;
    private boolean fBlockListeners = false;
    private static final String F_NO_HELP = PDEUIMessages.SimpleCSCommandDetails_6;
    private static final String F_HELP_CONTEXT_ID = PDEUIMessages.SimpleCSHelpDetails_HelpContextID;
    private static final String F_HELP_DOCUMENT_LINK = PDEUIMessages.SimpleCSHelpDetails_HelpDocumentLink;

    public SimpleCSHelpDetails(ICSMaster section) {
        super(section, "simplecs-context");
    }

    public void setData(ISimpleCSHelpObject object) {
        this.fHelpObject = object;
    }

    public void createDetails(Composite parent) {
        int columnSpan = 2;
        FormToolkit toolkit = this.getToolkit();
        GridData data = null;
        Label label = null;
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fHelpSection = toolkit.createSection(parent, 386);
        this.fHelpSection.clientVerticalSpacing = 6;
        this.fHelpSection.setText(PDEUIMessages.SimpleCSSharedUIFactory_1);
        this.fHelpSection.setDescription(PDEUIMessages.SimpleCSSharedUIFactory_2);
        this.fHelpSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        data = new GridData(768);
        this.fHelpSection.setLayoutData((Object)data);
        Composite helpSectionClient = toolkit.createComposite((Composite)this.fHelpSection);
        helpSectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, columnSpan));
        label = toolkit.createLabel(helpSectionClient, PDEUIMessages.SimpleCSHelpDetails_Type, 64);
        label.setForeground(foreground);
        this.fHelpCombo = new ComboPart();
        this.fHelpCombo.createControl(helpSectionClient, toolkit, 8);
        this.fHelpCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fHelpCombo.add(F_NO_HELP);
        this.fHelpCombo.add(F_HELP_CONTEXT_ID);
        this.fHelpCombo.add(F_HELP_DOCUMENT_LINK);
        this.fHelpCombo.setText(F_NO_HELP);
        this.fHelpLabel = toolkit.createLabel(helpSectionClient, PDEUIMessages.SimpleCSHelpDetails_Value, 64);
        this.fHelpLabel.setForeground(foreground);
        this.fHelpText = toolkit.createText(helpSectionClient, null);
        data = new GridData(768);
        this.fHelpText.setLayoutData((Object)data);
        toolkit.paintBordersFor(helpSectionClient);
        this.fHelpSection.setClient((Control)helpSectionClient);
        this.markDetailsPart((Control)this.fHelpSection);
    }

    public void hookListeners() {
        this.fHelpCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSHelpDetails.this.fHelpObject == null) {
                    return;
                }
                String selection = SimpleCSHelpDetails.this.fHelpCombo.getSelection();
                if (!selection.equals(F_NO_HELP)) {
                    if (selection.equals(F_HELP_CONTEXT_ID)) {
                        SimpleCSHelpDetails.this.fHelpObject.setHref(null);
                    } else {
                        SimpleCSHelpDetails.this.fHelpObject.setContextId(null);
                    }
                    SimpleCSHelpDetails.this.fHelpLabel.setVisible(true);
                    SimpleCSHelpDetails.this.fHelpText.setVisible(true);
                    SimpleCSHelpDetails.this.fHelpText.setFocus();
                    SimpleCSHelpDetails.this.fHelpText.setText("");
                } else {
                    SimpleCSHelpDetails.this.fHelpLabel.setVisible(false);
                    SimpleCSHelpDetails.this.fHelpText.setVisible(false);
                    SimpleCSHelpDetails.this.fHelpObject.setContextId(null);
                    SimpleCSHelpDetails.this.fHelpObject.setHref(null);
                }
            }
        });
        this.fHelpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SimpleCSHelpDetails.this.fBlockListeners) {
                    return;
                }
                if (SimpleCSHelpDetails.this.fHelpObject == null) {
                    return;
                }
                String selection = SimpleCSHelpDetails.this.fHelpCombo.getSelection();
                if (selection.equals(F_HELP_CONTEXT_ID)) {
                    SimpleCSHelpDetails.this.fHelpObject.setContextId(SimpleCSHelpDetails.this.fHelpText.getText());
                } else {
                    SimpleCSHelpDetails.this.fHelpObject.setHref(SimpleCSHelpDetails.this.fHelpText.getText());
                }
            }
        });
    }

    public void updateFields() {
        if (this.fHelpObject == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        boolean expanded = false;
        this.fBlockListeners = true;
        if (PDETextHelper.isDefined((String)this.fHelpObject.getContextId())) {
            this.fHelpText.setText(this.fHelpObject.getContextId());
            this.fHelpCombo.setText(F_HELP_CONTEXT_ID);
            expanded = true;
        } else if (PDETextHelper.isDefined((String)this.fHelpObject.getHref())) {
            this.fHelpText.setText(this.fHelpObject.getHref());
            this.fHelpCombo.setText(F_HELP_DOCUMENT_LINK);
            expanded = true;
        } else {
            this.fHelpCombo.setText(F_NO_HELP);
        }
        this.fBlockListeners = false;
        this.fHelpSection.setExpanded(expanded);
        this.fHelpText.setEnabled(editable);
        this.fHelpText.setVisible(expanded);
        this.fHelpLabel.setVisible(expanded);
        this.fHelpCombo.setEnabled(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }
}

