/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;

class APTProblem
extends CategorizedProblem
implements IProblem {
    private static final String[] NO_ARGS = new String[0];
    private final MessagerImpl.Severity _severity;
    private int _startingOffset;
    private int _endingOffset;
    private int _line;
    private IFile _resource;
    private final String _message;
    private final String _markerType;
    private final String[] _arguments;

    APTProblem(String msg, MessagerImpl.Severity severity, IFile file, int startingOffset, int endingOffset, int line, String[] arguments, boolean isNonReconcile) {
        this._message = msg;
        this._severity = severity;
        this._startingOffset = startingOffset;
        this._endingOffset = endingOffset;
        this._line = line;
        this._resource = file;
        this._arguments = arguments;
        this._markerType = isNonReconcile ? "org.eclipse.jdt.apt.core.nonreconcile.compile.problem" : "org.eclipse.jdt.apt.core.compile.problem";
    }

    public int getID() {
        if (this._arguments != null) {
            return 900;
        }
        return 901;
    }

    public String[] getArguments() {
        return this._arguments == null ? NO_ARGS : (String[])this._arguments.clone();
    }

    public String getMessage() {
        return this._message;
    }

    public char[] getOriginatingFileName() {
        return this._resource.getName().toCharArray();
    }

    public int getSourceStart() {
        return this._startingOffset;
    }

    public int getSourceEnd() {
        return this._endingOffset;
    }

    public int getSourceLineNumber() {
        return this._line;
    }

    public void setSourceStart(int sourceStart) {
        this._startingOffset = sourceStart;
    }

    public void setSourceEnd(int sourceEnd) {
        this._endingOffset = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this._line = lineNumber;
    }

    public boolean isError() {
        return this._severity == MessagerImpl.Severity.ERROR;
    }

    public boolean isWarning() {
        return this._severity == MessagerImpl.Severity.WARNING;
    }

    public String toString() {
        return this._message == null ? "<null message>" : this._message;
    }

    public int getCategoryID() {
        return 0;
    }

    public String getMarkerType() {
        return this._markerType;
    }
}

