/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.universal.WelcomeCustomizationPreferencePage;
import org.eclipse.ui.intro.IIntroSite;

public class CustomizeAction
extends Action {
    public static final String P_PAGE_ID = "pageId";
    private IIntroSite site;
    private IConfigurationElement element;

    public CustomizeAction(IIntroSite site, IConfigurationElement element) {
        this.site = site;
        this.element = element;
    }

    public void run() {
        String pageId = IntroPlugin.getDefault().getIntroModelRoot().getCurrentPageId();
        this.run(pageId);
    }

    public static IConfigurationElement getPageElement() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.preferencePages");
        int i = 0;
        while (i < elements.length) {
            String att;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("page") && (att = element.getAttribute("class")) != null && att.equals("org.eclipse.ui.intro.universal.ExtensionFactory:welcomeCustomization")) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private void run(String pageId) {
        PreferenceManager pm = new PreferenceManager();
        IPreferenceNode node = this.createPreferenceNode(pageId);
        pm.addToRoot(node);
        IWorkbenchWindow window = this.site.getWorkbenchWindow();
        PreferenceDialog dialog = new PreferenceDialog(window.getShell(), pm);
        dialog.open();
    }

    private IPreferenceNode createPreferenceNode(final String pageId) {
        if (this.element == null) {
            return null;
        }
        String id = this.element.getAttribute("id");
        String label = this.element.getAttribute("name");
        String className = "org.eclipse.ui.internal.intro.shared.WelcomeCustomizationPreferencePage";
        if (id == null || label == null || className == null) {
            return null;
        }
        return new PreferenceNode(id, label, null, className){

            public void createPage() {
                WelcomeCustomizationPreferencePage page = new WelcomeCustomizationPreferencePage();
                page.setTitle(this.getLabelText());
                page.setCurrentPage(pageId);
                this.setPage((IPreferencePage)page);
            }
        };
    }
}

