/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocContribution;
import org.xml.sax.SAXException;

public class RemoteTocParser {
    private DocumentReader reader;

    public ITocContribution[] parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        if (this.reader == null) {
            this.reader = new DocumentReader();
        }
        UAElement root = this.reader.read(in);
        IUAElement[] children = root.getChildren();
        ITocContribution[] contributions = new ITocContribution[children.length];
        int i = 0;
        while (i < children.length) {
            UAElement child = (UAElement)children[i];
            IUAElement[] contribChildren = child.getChildren();
            String[] extraDocuments = new String[contribChildren.length - 1];
            int j = 0;
            while (j < extraDocuments.length) {
                extraDocuments[j] = ((UAElement)contribChildren[j + 1]).getAttribute("href");
                ++j;
            }
            TocContribution contribution = new TocContribution();
            contribution.setCategoryId(child.getAttribute("categoryId"));
            contribution.setContributorId(child.getAttribute("contributorId"));
            contribution.setExtraDocuments(extraDocuments);
            contribution.setId(child.getAttribute("id"));
            contribution.setLocale(child.getAttribute("locale"));
            contribution.setPrimary("true".equals(child.getAttribute("isPrimary")));
            contribution.setToc((Toc)contribChildren[0]);
            contributions[i] = contribution;
            ++i;
        }
        return contributions;
    }
}

