/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.ExtensionMap;
import org.eclipse.ui.internal.intro.impl.model.History;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.viewer.IntroModelContentProvider;
import org.eclipse.ui.internal.intro.impl.model.viewer.IntroModelLabelProvider;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;

public abstract class AbstractIntroPartImplementation {
    private CustomizableIntroPart introPart = null;
    private IMemento memento;
    protected History history = new History();
    boolean logUIcreationTime = true;
    protected Action backAction = new Action(){
        {
            this.setToolTipText(Messages.Browser_backwardButton_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/backward_nav.gif"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/backward_nav.gif"));
        }

        public void run() {
            AbstractIntroPartImplementation.this.navigateBackward();
        }
    };
    protected Action forwardAction = new Action(){
        {
            this.setToolTipText(Messages.Browser_forwardButton_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/forward_nav.gif"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/forward_nav.gif"));
        }

        public void run() {
            AbstractIntroPartImplementation.this.navigateForward();
        }
    };
    protected Action homeAction = new Action(){
        {
            this.setToolTipText(Messages.Browser_homeButton_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/home_nav.gif"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/home_nav.gif"));
        }

        public void run() {
            AbstractIntroPartImplementation.this.navigateHome();
        }
    };
    protected Action viewIntroModelAction = new Action(){
        {
            this.setToolTipText(Messages.IntroPart_showContentButton_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("contents_view.gif"));
        }

        public void run() {
            ElementTreeSelectionDialog treeViewer = new ElementTreeSelectionDialog(AbstractIntroPartImplementation.this.getIntroPart().getIntroSite().getShell(), (ILabelProvider)new IntroModelLabelProvider(), (ITreeContentProvider)new IntroModelContentProvider());
            treeViewer.setInput((Object)AbstractIntroPartImplementation.this.getModel());
            treeViewer.open();
        }
    };

    public abstract void createPartControl(Composite var1);

    public void init(IIntroPart introPart, IMemento memento) {
        this.introPart = (CustomizableIntroPart)introPart;
        this.memento = memento;
    }

    public IntroModelRoot getModel() {
        return IntroPlugin.getDefault().getIntroModelRoot();
    }

    public CustomizableIntroPart getIntroPart() {
        return this.introPart;
    }

    public void updateHistory(String location) {
        this.history.updateHistory(location);
        this.updateNavigationActionsState();
    }

    public void updateHistory(AbstractIntroPage page) {
        this.history.updateHistory(page);
        this.updateNavigationActionsState();
    }

    public abstract void setFocus();

    protected abstract void updateNavigationActionsState();

    public abstract boolean navigateBackward();

    public abstract boolean navigateForward();

    public abstract boolean navigateHome();

    public void dispose() {
    }

    protected void addToolBarActions() {
        IActionBars actionBars = this.getIntroPart().getIntroSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.viewIntroModelAction);
        toolBarManager.update(true);
        actionBars.updateActionBars();
    }

    public void standbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        PerformanceStats stats;
        PerformanceStats setStandbyStateStats = null;
        long start = 0L;
        if (Log.logPerformance) {
            if (this.logUIcreationTime && PerformanceStats.ENABLED) {
                stats = PerformanceStats.getStats((String)"org.eclipse.ui.intro/perf/uiZoom", (Object)"intro");
                stats.endRun();
                Util.logPerformanceMessage("(perf stats) time spent in UI code before content is displayed (standbyStateChanged event is fired) ", stats.getRunningTime());
                stats.reset();
            }
            setStandbyStateStats = PerformanceStats.getStats((String)"org.eclipse.ui.intro/perf/setStandbyState", (Object)"intro");
            setStandbyStateStats.startRun();
            start = System.currentTimeMillis();
        }
        this.doStandbyStateChanged(standby, isStandbyPartNeeded);
        if (Log.logPerformance) {
            if (PerformanceStats.ENABLED) {
                setStandbyStateStats.endRun();
                Util.logPerformanceMessage("(perf stats) setting standby state (zooming, displaying content) took:", setStandbyStateStats.getRunningTime());
                setStandbyStateStats.reset();
            } else {
                Util.logPerformanceTime("setting standby state (zooming, generating content, setText() ) took:", start);
            }
            if (this.logUIcreationTime) {
                if (PerformanceStats.ENABLED) {
                    stats = PerformanceStats.getStats((String)"org.eclipse.ui.intro/perf/createView", (Object)"intro");
                    stats.endRun();
                    Util.logPerformanceMessage("END - (perf stats): creating CustomizableIntroPart view took:", stats.getRunningTime());
                    stats.reset();
                } else {
                    Util.logPerformanceTime("END: creating CustomizableIntroPart view took:", IntroPlugin.getDefault().gettUICreationStartTime());
                }
                this.logUIcreationTime = false;
            }
        }
    }

    protected abstract void doStandbyStateChanged(boolean var1, boolean var2);

    public void saveState(IMemento memento) {
        this.saveCurrentPage(memento);
    }

    protected void saveCurrentPage(IMemento memento) {
        IntroModelRoot model = this.getModel();
        if (memento == null || model == null) {
            return;
        }
        String currentPage = model.getCurrentPageId();
        if (currentPage != null && currentPage.length() > 0) {
            memento.putString("currentPage", currentPage);
        }
    }

    protected String getCachedCurrentPage() {
        String newContentPage = ExtensionMap.getInstance().getStartPage();
        if (newContentPage != null) {
            return newContentPage;
        }
        IMemento memento = this.getMemento();
        if (memento == null) {
            return null;
        }
        return memento.getString("currentPage");
    }

    public IMemento getMemento() {
        return this.memento;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.history.clear();
        this.handleRegistryChanged(event);
    }

    protected abstract void handleRegistryChanged(IRegistryChangeEvent var1);

    public History getHistory() {
        return this.history;
    }
}

