;;;; File: scm-codegen.scm
;;;; Copyright (C) 2005 Andreas Rottmann
;;;;
;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU Lesser General Public
;;;; License as published by the Free Software Foundation; either
;;;; version 2, or (at your option) any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;; Lesser General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU Lesser General Public
;;;; License along with this software; see the file COPYING.  If not,
;;;; write to the Free Software Foundation, 675 Mass Ave, Cambridge,
;;;; MA 02139, USA.
;;;;

;;; Commentary:
;;
; This module provides the generate-wrapset method for creating
; Scheme-based wrappers.
;;
;;; Code:
(define-module (g-wrap scm-codegen)
  #:use-module (oop goops)

  #:use-module (g-wrap)
  #:use-module (g-wrap util)

  #:export (declarations-cg))

(define (generate-wrapset-scm wrapset port)
  (define (dsp-list lst)
    (for-each (lambda (s) (display s port)) lst))
  (define (rndr expressions)
    (render (make-scm-code expressions) port))
  
  (let ((wrapset-name-c-sym (any-str->c-sym-str
                             (symbol->string (name wrapset))))
        (client-types (compute-client-types wrapset))
        (items (reverse (slot-ref wrapset 'items))))

    (define (render-items cg)
      (for-each (lambda (item)
                  (rndr (cg wrapset item)))
                items))
    
    ;;(format #t "client types: ~S\n" client-types)
    (dsp-list
     (list
      ";; Generated by G-Wrap-TNG: an experimental wrapper engine\n"
      "\n"))

    (format #t "decl-cg: ~S\n" (generic-function-methods declarations-cg))
    (rndr (declarations-cg wrapset))
    (render-items declarations-cg)))

(define-method (generate-wrapset (wrapset <gw-wrapset>)
                                 (basename <string>))
  (let ((wrapset-source-name (string-append basename ".scm")))
    (call-with-output-file/cleanup
     wrapset-source-name
     (lambda (port)
       (generate-wrapset-scm wrapset port)))))

;;; Default implementations (no-ops)

(define-method (declarations-cg (wrapset <gw-wrapset>))
  '())

(define-method (declarations-cg (wrapset <gw-wrapset>) (item <gw-item>))
  '())
