#!/bin/sh
# mktags.sh
# Copyright (C) 2005-2007 John Eriksson
#
# Description:
# Makes nice tags for the official oggs by Kohn.
# Make sure they have proper filenames and are located in a good 
# directory: "The Album Name (yyyy)"
# with names: "The Artist - xx - The Song.ogg"
#

NAME="mktags.sh"
VERSION="1.1"

usage() {
echo "Usage: mktags.sh [GENRE] [OPTIONS]..."
echo "Make nice ogg tags for the official Kohn ogg's."
echo
echo "  -n			work-around for artist with '-' in name"
echo "  -h, --help		print this help and exit"
echo "  -v, --version		output version information and exit"
echo
echo "Report bugs to <johne@rootlinux.org>."
exit 1
}

version() {
echo "$NAME $VERSION"
exit 0
}

if [ "$1" = "-v" -o "$1" = "--version" ]; then
  version
fi

if [ "$1" = "-h" -o "$1" = "--help" -o -z "$1" ]; then
  usage
fi

crunch(){
 read STRING;
 echo $STRING;
}

for i in *.ogg; do

SONG="`echo $i | cut -f3-90 -d\- | sed s/"\.ogg"// | sed "s|STAR|*|g" | sed "s|SLASH|/|g" | sed "s|DASH|-|" | crunch`"
SONGNO="`echo $i | cut -f2 -d\- | crunch`"
ARTIST="`echo $i | cut -f1 -d\- | sed "s|STAR|*|g" | sed "s|SLASH|/|g" | sed "s|DASH|-|" | crunch`"

# album and year (from folder name)
ALBUM="`basename \"$PWD\" | cut -f1 -d\( | crunch`"
YEAR="`echo $PWD | cut -f2 -d\( | sed s/\)// | crunch`"

# print out a nice line
echo "$ARTIST - $ALBUM - $SONGNO - $SONG"

# run vorbiscomment
vorbiscomment -R -w \
-t "ARTIST=$ARTIST" \
-t "TITLE=$SONG" \
-t "ALBUM=$ALBUM" \
-t "DATE=$YEAR" \
-t "GENRE=$1" \
-t "TRACKNUMBER=$SONGNO" \
"$i" #"$i.ogg"

done

# EOF

