#!/bin/sh
# konconv.sh 1.2
# Copyright (C) 2005-2007 John Eriksson
#
# Description:
# Converts files named with klq to kon or the
# other way around.

NAME="konconv.sh"
VERSION="1.2"

usage() {
echo "Usage: $NAME [OPTION]..."
echo "Convert all files in pwd in old kon format to new"
echo "kon format or from/to klq and kon."
echo
echo "  -o, --original	from original cd (make kon not klq)"
echo "  -l, --tolow		convert from (new) kon to klq"
echo "  -k, --tokon		convert from klq to (new) kon"
echo "  -p, --playlist		make playlist and md5 only"
echo "  -h, --help		print this help and exit"
echo "  -v, --version		output version information and exit"
echo
echo "Report bugs to <johne@rootlinux.org>."
exit 1
}

version() {
echo "$NAME $VERSION"
exit 0
}

if [ "$1" = "-v" -o "$1" = "--version" ]; then
  version
fi

if [ "$1" = "-h" -o "$1" = "--help" ]; then
  usage
fi

if ! (ls *.ogg >/dev/null 2>&1); then
  echo "Found no ogg files here."
  exit 1
fi

crunch() {
 read STRING;
 echo $STRING;
}

# how to transform the filename
transform() {
  read STRING;
  NEWSTRING="`echo $STRING | sed "s|STAR||" | sed "s|SLASH||g" | 
  sed "s|DASH|-|g" | sed "s|  ||g" | tr \  \_ | tr A-Z a-z | sed s/Å/a/g | 
  sed s/å/a/g | sed s/Ö/o/g | sed s/ö/o/g | sed s/Ä/a/g | sed s/ä/a/g | 
  sed s/Ö/o/g |  sed s/ø/o/g | sed s/^\_//g | sed s/\'//g | 
  sed s/\'//g | sed "s|\!||g" | sed "s|\?||g" | sed "s|\,||g" | 
  sed s/é/e/g | sed s/://g | sed "s|\.||g" | sed 's|\"||g'`"
  echo $NEWSTRING;
}

# "globala grejer"
YEAR="`echo $PWD | cut -f2 -d\( | sed s/\)// | crunch`"
ALBUM="`basename \"$PWD\" | cut -f1 -d\( | cut -f2-50 -d\- | transform`"

GLOB1="$1"

make_playlist_and_md5() {

  FILENAME="00-`ls --color=no 01* | cut -f2 -d\-`-$ALBUM-cda-$YEAR"

  if [ "$GLOB1" = "-o" -o "$GLOB1" = "--original" ]; then
    FILENAME="$FILENAME-kon"
   else
    FILENAME="$FILENAME-klq"
  fi

  echo "YEAR $YEAR"
  echo "ALBUM $ALBUM"

  echo $FILENAME.md5
  md5sum *.ogg > $FILENAME.md5

  echo $FILENAME.m3u
  ls --color=no *.ogg > $FILENAME.m3u
}

if [ "$1" = "-p" -o "$2" = "-p" ]; then
  make_playlist_and_md5
  exit 0
fi

if [ "$1" = "-l" -o "$1" = "--tolow" ]; then
  FROM="kon"
  TO="klq"
 elif [ "$1" = "-k" -o "$1" = "--tokon" ]; then
  FROM="klq"
  TO="kon"
 else
  CONV="no"
fi
if [ "$CONV" != "no" ]; then
  for i in *; do
    mv "$i" "`echo $i | sed s/$FROM/$TO/`"
  done
  exit 0
fi

if (ls *-kon.ogg >/dev/null 2>&1) || (ls *-klq.ogg >/dev/null 2>&1); then
  echo "Files in this folder are probably already converted."
  exit 1
fi

for i in *.ogg; do

NUM="`echo $i | cut -f2 -d\- | crunch`"
ARTIST="`echo $i | cut -f1 -d\- | transform`"
SONG="`echo $i | cut -f3-50 -d\- | sed s/.ogg// | transform`"

if [ "$1" = "-o" -o "$1" = "--original" ]; then
    SUFFIX="kon"
  else
    SUFFIX="klq"
fi

echo "$NUM-$ARTIST-$SONG-$SUFFIX.ogg"

mv "$i" "$NUM-$ARTIST-$SONG-$SUFFIX.ogg"

done

make_playlist_and_md5

# EOF
