//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtkmm.h>
#include <gdkmm.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include <gst/interfaces/xoverlay.h>
#include <gst/video/gstvideosink.h>
#include <gst/video/video.h>

#include <unistd.h>

#include <ctime>
#include <cstring>
#include <cstdio>
#include <iostream>

#include "ui_toolbox.hh"
#include "video-widget.hh"

#include "x_play.hh"

namespace Bmp
{
  VideoWidget::VideoWidget ()
       : xoverlay (0)
  {
    GTK_WIDGET_UNSET_FLAGS (GTK_WIDGET(gobj()), GTK_DOUBLE_BUFFERED);
  }

  void
  VideoWidget::set_xoverlay (GstElement *element)
  {
    if (!is_realized()) Gtk::Widget::realize ();

    lock.lock (); 
    xoverlay = GST_X_OVERLAY (element); 
    lock.unlock ();

    gst_x_overlay_set_xwindow_id (xoverlay, GDK_WINDOW_XWINDOW (video->gobj()));
  }

  void
  VideoWidget::unset_xoverlay ()
  {
    lock.lock ();
    xoverlay = 0;
    lock.unlock ();
  }

  void
  VideoWidget::on_realize ()
  {
    int attributes_mask = 0;
    GdkColor colour;

    // Widget window 
    GdkWindowAttr attributes;
    attributes.window_type = GDK_WINDOW_CHILD;
    attributes.x = get_allocation().get_x(); 
    attributes.y = get_allocation().get_y(); 
    attributes.width = get_allocation().get_width(); 
    attributes.height = get_allocation().get_height(); 
    attributes.wclass = GDK_INPUT_OUTPUT;
    attributes.visual = get_visual ()->gobj();
    attributes.colormap = get_colormap ()->gobj();
    attributes.event_mask = get_events ();
    attributes.event_mask |= GDK_EXPOSURE_MASK |
                             GDK_POINTER_MOTION_MASK |
                             GDK_BUTTON_PRESS_MASK |
                             GDK_KEY_PRESS_MASK | GDK_SUBSTRUCTURE_MASK;

    attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;
    set_window (Gdk::Window::create (get_parent_window(), &attributes, attributes_mask));
    gdk_window_set_user_data (get_window()->gobj(), gpointer (GTK_WIDGET(this->gobj())));

    // Video window
    attributes.window_type = GDK_WINDOW_CHILD;
    attributes.x = 0;
    attributes.y = 0;
    attributes.width = get_allocation().get_width(); 
    attributes.height = get_allocation().get_height(); 
    attributes.wclass = GDK_INPUT_OUTPUT;
    attributes.event_mask = get_events ();
    attributes.event_mask |= GDK_EXPOSURE_MASK |
                             GDK_POINTER_MOTION_MASK |
                             GDK_BUTTON_PRESS_MASK |
                             GDK_KEY_PRESS_MASK;
    attributes_mask = GDK_WA_X | GDK_WA_Y;

    video = (Gdk::Window::create (get_window(), &attributes, attributes_mask));
    gdk_window_set_user_data (get_window()->gobj(), gpointer (GTK_WIDGET(this->gobj())));

    gdk_color_parse ("black", &colour);
    gtk_widget_modify_bg (GTK_WIDGET (gobj()), GTK_STATE_NORMAL, &colour);
    GTK_WIDGET (gobj())->style = gtk_style_attach (GTK_WIDGET (gobj())->style, get_window()->gobj()); 
    gtk_style_set_background (GTK_WIDGET(gobj())->style, get_window()->gobj(), GTK_STATE_NORMAL);

    gdk_window_set_background (video->gobj(), &colour);

    GTK_WIDGET_SET_FLAGS (GTK_WIDGET(gobj()), GTK_REALIZED);
  }

  bool
  VideoWidget::on_configure_event (GdkEventConfigure *event)
  {
    video->resize (event->width, event->height);
    get_window()->resize (event->width, event->height);
    if (xoverlay)
      {
        gst_x_overlay_expose (xoverlay);
        gst_x_overlay_set_xwindow_id (xoverlay, GDK_WINDOW_XWINDOW (video->gobj()));
      }
    return false;
  }

  void
  VideoWidget::on_map ()
  {
    Gtk::Widget::on_map ();
    video->show ();
  }

  bool
  VideoWidget::on_expose_event (GdkEventExpose *event)
  {
    if (event && event->count > 0) return true;

    if (xoverlay && ::play->vis_playing())
      {
        gst_x_overlay_expose (xoverlay);
      }
    else
      {
        Cairo::RefPtr<Cairo::Context> cr = Util::create_gdk_cairo_context (video);
        cr->set_source_rgba (.0, .0, .0, 1.0);
        cr->paint ();
      }
    return true; 
  }
} // namespace Bmp
