//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glib/gi18n.h>
#include <gtkmm.h>
#include <gdkmm.h>

#include "main.hh"
#include "paths.hh"
#include "ui_toolbox.hh"
#include "splash-screen.hh"

namespace Bmp
{
  SplashWindow::SplashWindow ()
      : Gtk::Window (Gtk::WINDOW_TOPLEVEL),
        m_image (Gdk::Pixbuf::create_from_file (Glib::build_filename (BMP_IMAGE_DIR, "logo-splash.png"))),
        m_image_w (m_image->get_width()),
        m_image_h (m_image->get_height()),
        m_bar_w (m_image_w - 48),
        m_bar_h (20),
        m_bar_x (24),
        m_bar_y (m_image_h - 30),
        m_has_alpha (Util::has_alpha()),
        m_percent (0.0)
  {
      set_title (_("BMP Starting..."));
      set_skip_taskbar_hint (true);
      set_skip_pager_hint (true);

      set_position (Gtk::WIN_POS_CENTER);
      set_resizable (false);

      set_type_hint (Gdk::WINDOW_TYPE_HINT_SPLASHSCREEN);
      set_decorated (false);

      set_app_paintable (true);
      add_events (Gdk::ALL_EVENTS_MASK);

      set_size_request (m_image_w, m_image_h);

      if (!m_has_alpha)
        {
          Glib::RefPtr<Gdk::Pixmap> mask_pixmap_window1, mask_pixmap_window2;
          Glib::RefPtr<Gdk::Bitmap> mask_bitmap_window1, mask_bitmap_window2;
          m_image->render_pixmap_and_mask (mask_pixmap_window1, mask_bitmap_window1, 0);
          m_image->render_pixmap_and_mask (mask_pixmap_window2, mask_bitmap_window2, 128);
          shape_combine_mask (mask_bitmap_window2, 0, 0);
        }
      else
        {
          set_colormap (Util::get_rgba_colormap());
        }
  }

  void
  SplashWindow::set_message (char const * message, double percent)
  {
    m_percent = percent;
    m_message = message;
    queue_draw ();
    while (gtk_events_pending()) gtk_main_iteration();
  }

  void
  SplashWindow::on_realize ()
  {
    Gtk::Window::on_realize ();
    m_layout = create_pango_layout ("");
  }

  bool
  SplashWindow::on_expose_event (GdkEventExpose *event)
  {
    Cairo::RefPtr<Cairo::Context> m_cr = Util::create_gdk_cairo_context (get_window ());

    m_cr->set_operator (Cairo::OPERATOR_SOURCE);
    if (m_has_alpha)
      {
        m_cr->set_source_rgba (.0, .0, .0, .0);
        m_cr->paint ();
      }

    gdk_cairo_set_source_pixbuf (m_cr->cobj(), m_image->gobj(), 0, 0);
    m_cr->paint ();

    m_cr->set_operator( Cairo::OPERATOR_ATOP );
    double w = m_bar_w * m_percent;
    m_cr->set_source_rgba( 1., 1., 1., 0.2 ); 
    m_cr->rectangle( m_bar_x , m_bar_y , w , m_bar_h );
    m_cr->fill ();

    m_cr->set_operator( Cairo::OPERATOR_ATOP );
    m_cr->set_line_width( 1.0 );
    m_cr->rectangle( m_bar_x, m_bar_y, m_bar_w, m_bar_h ); 
    m_cr->set_source_rgba( 1., 1., 1., 0.8 ); 
    m_cr->stroke ();

    int lw, lh;

    Pango::FontDescription desc = get_style()->get_font ();
    pango_font_description_set_absolute_size (desc.gobj(), 11 * PANGO_SCALE);
    pango_layout_set_font_description (m_layout->gobj(), desc.gobj ()); 

    m_layout->set_markup (m_message); 
    m_layout->get_pixel_size (lw, lh);

    m_cr->set_operator( Cairo::OPERATOR_ATOP );
    m_cr->move_to( m_bar_x + ((m_bar_w - lw)/2), m_bar_y + ((m_bar_h - lh)/2)); 
    m_cr->set_source_rgba( 1., 1., 1., 0.8);
    pango_cairo_show_layout (m_cr->cobj(), m_layout->gobj());

    return false;
  }
} // namespace Bmp
