//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_PODCAST_TYPES_HH 
#define BMP_PODCAST_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <vector>

#include <glibmm.h>
#include <glibmm/markup.h>

#include <bmp/base_types.hh>

namespace Bmp
{
  namespace PodCastTools
  {
    struct PodCastItem
    {
      // Item General Attributes
      oustring      title;
      oustring      description;
      oustring      link;
      oustring      copyright;
      oustring      pub_date;

      // Enclosure (Stream)
      oustring      enclosure_url;
      oustring      enclosure_type;
      unsigned int  enclosure_length;

      // GUID
      bool          guid_permalink;
      oustring      guid_value;

      // Our own data
      bool          listened_to;
      bool          downloaded;
      std::string   localfilename;
    };
    typedef std::vector<PodCastItem> VPodCastItems;

    struct PodCastOverlayItem
    {
      bool listened_to;
      bool downloaded;
      std::string localfilename;

      PodCastOverlayItem ()
      {
        listened_to = false;
        downloaded  = false;
        localfilename = std::string ();
      }
    };
    typedef std::map<Glib::ustring, PodCastOverlayItem> MOverlayItems;

    struct PodCast 
    {
      // PodCast
      oustring  title;
      oustring  description;
      oustring  link;
      oustring  last_build_date;
      oustring  pub_date;
      oustring  generator;

      // Image (Optional)
      oustring      image_url;
      oustring      image_title;
      oustring      image_link;
      oustring      image_description;

      VPodCastItems items;

      // Our own data
      std::string   cast_uuid;
      Glib::ustring uri;
      time_t        last_poll_time;
      MOverlayItems overlay_items;
    };

    typedef std::vector<Glib::ustring> PodCastList;
    typedef std::map<Glib::ustring, PodCast> MPodCasts;

    void overlay_from_item (PodCastItem const& item, PodCastOverlayItem & overlay_item);

#include "exception.hh"

    EXCEPTION(NetworkError)
    EXCEPTION(ParsingError)
    EXCEPTION(InvalidUriError)
    EXCEPTION(PodCastExistsError)
    EXCEPTION(InvalidPodcastListError)
    EXCEPTION(PodCastNotLoadedError)
    EXCEPTION(PodCastInvalidError)

  }
}
#endif
