//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_GAIM_SEND_TRACK_HH 
#define BMP_GAIM_SEND_TRACK_HH 

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/markup.h>
#include <gtkmm.h>
#include <libglademm.h>

#include "gaim-dbus.hh"

namespace Bmp
{
  namespace Gaim
  {
    class SendFile : public Gtk::Dialog
    {
      public:

        SendFile (BaseObjectType                       *cobject,
                   const Glib::RefPtr<Gnome::Glade::Xml> &xml);
        ~SendFile ();
        static SendFile* create ();

        int run (Gaim::DBUS::OnlineBuddies const& buddies, Glib::ustring const& uri); 
        Bmp::Gaim::DBUS::Buddy get_current_buddy ();

      private:

        class BuddiesCR
            : public Gtk::TreeModel::ColumnRecord
        {
        public:

            Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> >  protocol;
            Gtk::TreeModelColumn<Glib::ustring>               alias;
            Gtk::TreeModelColumn<Glib::ustring>               name;
            Gtk::TreeModelColumn<Gaim::DBUS::Buddy>           buddy;

            BuddiesCR ()
            {
                add (protocol);
                add (alias);
                add (name);
                add (buddy);
            }
        };
        BuddiesCR buddies_cr;

        // GladeXML+Widgets
        Glib::RefPtr<Gnome::Glade::Xml> ref_xml;

        Gtk::TreeView                  *treeview;
        Glib::RefPtr<Gtk::ListStore>    liststore;

        Gtk::Label                     *label_filename;
        Gtk::Button                    *okbutton1;
    };
  }
}
#endif
