//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <revision.h>
#include <build.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <locale.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include <glib-object.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>

#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus.h>

#include <bmp/dbus.hh>
#include <src/paths.hh>

static GMainLoop          *mainloop = NULL; 
static DBusGConnection    *dbus     = NULL;
static DBusConnection     *c_bus    = NULL;

static DBusGProxy         *o_bus    = NULL,
                          *o_bmp    = NULL;

static void setup_i18n (void)
{
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALE_DIR);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
}

static void name_owner_changed (DBusGProxy *proxy, char *name, char *old_owner, char *new_owner, gpointer data)
{
  if (!name || (name && strcmp (name, BMP_DBUS_SERVICE))) return;

  if (strlen (old_owner) && !strlen (new_owner))
    { 
      if (g_getenv ("DISPLAY"))
        {
          gtk_init (0, NULL);
          GtkWidget *dialog = gtk_message_dialog_new_with_markup (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
                                                    _("<big><b>BMP Terminated without Reporting the Shutdown</b></big>\n\n"
                                                      "If this was unexpected (if you didn't kill it with 'kill' on purpose, or maybe if "
                                                      "you did, but the app hung before you did so, or if you don't even know what 'kill' is at all) "
                                                      "then please report the problem situation as a bug at "
                                                      "<b>http://bugs.beep-media-player.org</b>"));
          gtk_window_set_title (GTK_WINDOW (dialog), _("BMP Exited Unexpectedly - BMP"));
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
        }
      exit (EXIT_SUCCESS);
    }
}

static void on_bmp_shutdown_complete (DBusGProxy *proxy, gpointer data)
{
  dbus_g_proxy_disconnect_signal (o_bus, "NameOwnerChanged", G_CALLBACK (name_owner_changed), NULL);
  g_main_loop_quit (mainloop);
}

int main (int n_args, char **args)
{
  GError            *error          = NULL;
  DBusError          dbus_error;

  g_type_init ();
  dbus_g_type_specialized_init ();
  mainloop = g_main_loop_new (NULL, FALSE); 
  setup_i18n ();

  dbus = dbus_g_bus_get (DBUS_BUS_SESSION, &error);

  if (error)
    {
      g_log (G_LOG_DOMAIN, G_LOG_LEVEL_ERROR, "DBus Error: %s", error->message);
      g_error_free (error);
      return EXIT_FAILURE;
    }

  // We assume here the dbus daemon could be reached since we've been activated by it
  if (!dbus)
    {
      return EXIT_FAILURE;      
    }

  dbus_error_init (&dbus_error);

  c_bus = dbus_g_connection_get_connection (dbus);
  dbus_connection_setup_with_g_main (c_bus, g_main_context_default()); 

  o_bus = dbus_g_proxy_new_for_name (dbus, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
  dbus_g_proxy_add_signal (o_bus, "NameOwnerChanged", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
  dbus_g_proxy_connect_signal (o_bus, "NameOwnerChanged", G_CALLBACK (name_owner_changed), NULL, NULL);

  o_bmp = dbus_g_proxy_new_for_name_owner (dbus, BMP_DBUS_SERVICE, BMP_DBUS_PATH, BMP_DBUS_INTERFACE, &error);
  if (!o_bmp)
  {
    g_log (G_LOG_DOMAIN, G_LOG_LEVEL_ERROR, "BMP DBus Interface not present");
  }

  if (error)
  {
    g_log (G_LOG_DOMAIN, G_LOG_LEVEL_ERROR, "DBus Error: %s", error->message);
    g_error_free (error);
    return FALSE;
  }

  dbus_g_proxy_add_signal (o_bmp, "ShutdownComplete", G_TYPE_INVALID);
  dbus_g_proxy_connect_signal (o_bmp, "ShutdownComplete", G_CALLBACK (on_bmp_shutdown_complete), NULL, NULL);

  guint request_name_result = 0;

  if (!dbus_g_proxy_call (o_bus, "RequestName", &error,
                          G_TYPE_STRING, BMP_DBUS_SENTINEL_SERVICE,
                          G_TYPE_UINT, 0,
                          G_TYPE_INVALID,
                          G_TYPE_UINT, &request_name_result,
                          G_TYPE_INVALID))
      {
        g_error ("%s: Failed RequestName request: %s", G_STRFUNC, error->message);
        g_error_free (error);
        error = NULL;
      }

  switch (request_name_result)
    {
      case DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER:
          {
            break;
          }

        case DBUS_REQUEST_NAME_REPLY_EXISTS:
          {
            break;
          }
    }

  g_main_loop_run (mainloop);

  return EXIT_SUCCESS;
}
