//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <glibmm.h>

#include <src/util_string.hh>
#include <src/util_file.hh>

#include <src/uri++.hh>
#include <src/vfs.hh>

#include <src/x_library.hh>

namespace Bmp
{
  namespace VFS
  {
      class PluginContainerQuery : public Bmp::VFS::PluginContainerBase
      {
        public:

          virtual bool
          can_process (Glib::ustring const& uri)
          {
            Bmp::URI u (uri);
            return (u.get_protocol () == Bmp::URI::PROTOCOL_QUERY); 
          }

          virtual bool 
          handle_read	(Handle & handle,
                       VUri & list)
          {
            using namespace Bmp::DB;
            using namespace Bmp::Library;

            try {
                Bmp::URI::Query q;
                Bmp::URI u (handle.get_uri());
                u.unescape ();
                u.parse_query (q);
                Bmp::DB::VAttributes attrs;
                
                for (Bmp::URI::Query::const_iterator qpair = q.begin (); qpair != q.end (); ++qpair)
                  {
                    Bmp::URI::QueryPair const& qp = (*qpair);
                    Bmp::URI::QElement const& element = qp.second;
                    attrs.push_back (Bmp::DB::Attribute (DB::EXACT, element.first, element.second));	
                  }

                VRows vector;
                library->query (attrs, vector);
                
                for (VRows::iterator row = vector.begin (); row != vector.end (); ++row)
                  {
                    Track track (*row);
                    list.push_back (track.location.get());
                  }
              }
            catch (Bmp::URI::Exception& cxe)
              {
                g_log (G_LOG_DOMAIN, G_LOG_LEVEL_WARNING, "%s: URI Exception: %s", G_STRFUNC, cxe.what());
                return false;
              }
            return true;	
          }

          virtual bool
          can_write ()
          {
            return false;
          }

          virtual bool
          handle_write (Handle & handle, VUri const& uri_list)
          {
            return false;
          }

          virtual Bmp::VFS::ExportData
          get_export_data ()
          {
            static Bmp::VFS::ExportData export_data ("Query Parser", ""); 
            return export_data;
          }
      };
  }
}
  
extern "C" Bmp::VFS::PluginContainerBase* plugin_create (void)
{
  return new Bmp::VFS::PluginContainerQuery;
}

extern "C" void plugin_delete (Bmp::VFS::PluginContainerQuery* p)
{
  delete p;
}
