/*
 *  makecdct.c  --  part of the build process of CPT 4.0
 * 
 *  Author: Jeff Edwards
 * 
 *  This program is hereby placed in the public domain, June 2000,
 *  ---Jeff Edwards---
 *
 * =================================================================

   This program reads an ASCII text file, breaks it into words 
   delineated by white space, and builds an equivalent 'c' file
   containing the text as an initialized array of unsigned char
   pointers.

 Usage:  makecdct <infile> <outfile> <arrayname>

   ----------------------------------------------------------------
   Rev 00  08/27/98  From 'makectxt.c'.
   Rev 01  11/10/98  Fooling with .c logic
   Rev 02  10/11/03  Minor cleanup
   ----------------------------------------------------------------  
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

FILE *infile, *outfile;

int main (int argc, char *argv[])
{

   char filename[81];

   int c,i,n;
   int charcount;
   int firstword;
   int wordcount;

   if (argc == 4) goto argcok;
error:
   printf("MAKECDCT reads an ASCII text file, breaks it into words\n");
   printf("delineated by white space, and builds an equivalent 'c'\n");
   printf("file containing the text as an initialized array of unsigned\n");
   printf("char pointers.\n\n");
   printf ("Usage: makecdct <infile> <outfile> <arrayname>\n");
   exit(1);

argcok:

   infile = fopen(argv[1],"rb");
   if (infile == NULL) goto error;

   strcpy(filename,argv[2]);   /* output file name */
   n = strlen(filename);
   for (i=0; i < n; i++)
     if (filename[i] == '.') break;
   if (i == n) strcat(filename,".c");
   /* 
    *  The remove() forces a new date on the output file. Under DJGPP,
    *  sometimes 'make' acts funny without it.
    */
   remove(filename);
   outfile = fopen(filename,"wb");
   if (outfile == NULL) {
      printf ("Unable to open %s\n",filename);
      goto error;
   }

   fprintf(outfile,"/* Generated from '%s' by 'makecdct'. */\n",argv[1]);
   fprintf(outfile,"unsigned char *%s[]={",argv[3]);
   charcount = 1;

   charcount = 0;
   wordcount = 0;
   firstword = 1;
loop1:
   c = getc(infile);
   if (c == EOF) goto eof1;
   if (c <= ' ') {
      if (charcount == 0) goto loop1;
      /*
       *  The end of a word
       */
      fputc('"',outfile);
      charcount = 0;
      wordcount++;
      goto loop1;
   }
   if (charcount == 0) {
      /*
       *  The beginning of a word
       */
      if (!firstword) fputc(',',outfile);
      firstword = 0;
      fputc('\n',outfile);
      fputc('"',outfile);
   }
   fputc(c,outfile);
   charcount++;
   goto loop1;
       
eof1:
   if (charcount != 0) {
      fputc('"',outfile);
      wordcount++;
   }
   fprintf(outfile,"\n};\n");
   fprintf(outfile,"int %s_size=%d;\n",argv[3],wordcount);
   fclose(infile);
   fclose(outfile);
   
   exit(0);

}  /* end of makecdct() */

