/*
 *  The CPT4 character set consists of the 'unknown character',
 *  the 'mask character', and the ASCII character set from ' '
 *  through  '~' but omitting the lower case alphabet.
 */
#ifndef _CPT4DEF
#define UCHAR_PSEUDO_ASCII 1
#define MCHAR_PSEUDO_ASCII 2
#define UNK_CHARSET_INDEX 0
#define MSK_CHARSET_INDEX 1
#define SPC_CHARSET_INDEX 2
#define CHARSET_CNT 71
typedef struct
{
  char *ff_name;
  char width;
  char cs_ink_width;
  char cs_ink_height;
  char ab_ink_width;
  char ab_ink_height;
  char ab_offset_dn;
  char ab_offset_rt;
  char lbr[CHARSET_CNT];
  char rbr[CHARSET_CNT];
  char asc[CHARSET_CNT];
  char dsc[CHARSET_CNT];
  unsigned char *bitpatterns;
} cpt4_ff_t;
#define _CPT4DEF
#endif
cpt4_ff_t fnt9x15b_font = {
  "fnt9x15b",
   9, /* width         */
   8, /* cs_ink_width  */
  14, /* cs_ink_height */
   8, /* ab_ink_width  */
  10, /* ab_ink_height */
   1, /* ab_offset_dn  */
   0, /* ab_offset_rt  */
  {   /* lbr */
      0,  0,  0,  3,  2,  1,  1,  0,  0,  3,  2,  2,  1,  0,  3,  0,
      2,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  1,  0,
      1,  1,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  1,  0,  1,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  0,  2,
      1,  0,  2,  2,  3,  2,  0
  },
  {   /* rbr */
      8,  8,  0,  5,  7,  8,  8,  8,  8,  5,  7,  7,  8,  8,  6,  8,
      6,  8,  8,  7,  8,  8,  8,  8,  8,  8,  8,  8,  6,  6,  7,  8,
      7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  7,  7,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  7,  8,  7,
      7,  8,  6,  7,  5,  7,  8
  },
  {   /* asc */
     10, 11,  0, 10, 10,  9, 10, 10, 10, 10, 11, 11,  7,  8,  2,  5,
      2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  7,  7, 10,  6,
     10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 10, 11,
     10,  0, 11, 11, 10, 11, 10
  },
  {   /* dsc */
      0,  3,  0,  0, -7, -1,  1,  0,  0, -6,  1,  1, -2, -1,  3, -4,
      1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  3,  0, -2,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  1,
     -6,  1, -8,  1,  0,  1, -7
  },
  NULL /* bitpatterns array */
};
unsigned char fnt9x15b_data[] = {
/* UNK */
  0x00,0xFF,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0xFF,0x00,0x00,0x00,
/* MSK */
  0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,
/* ' ' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '!' */
  0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x00,0x00,0x00,
/* '"' */
  0x00,0x36,0x36,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '#' */
  0x00,0x00,0x36,0x36,0x7F,0x36,0x36,0x7F,0x36,0x36,0x00,0x00,0x00,0x00,
/* '$' */
  0x00,0x08,0x3E,0x6B,0x68,0x78,0x3E,0x0F,0x0B,0x6B,0x3E,0x08,0x00,0x00,
/* '%' */
  0x00,0x43,0xE6,0xE6,0x4C,0x18,0x18,0x32,0x67,0x67,0xC2,0x00,0x00,0x00,
/* '&' */
  0x00,0x38,0x6C,0x6C,0x78,0x30,0x79,0xCF,0xC6,0xCE,0x7B,0x00,0x00,0x00,
/* ''' */
  0x00,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '(' */
  0x06,0x0C,0x18,0x18,0x30,0x30,0x30,0x30,0x18,0x18,0x0C,0x06,0x00,0x00,
/* ')' */
  0x30,0x18,0x0C,0x0C,0x06,0x06,0x06,0x06,0x0C,0x0C,0x18,0x30,0x00,0x00,
/* '*' */
  0x00,0x00,0x00,0x00,0x36,0x1C,0x7F,0x1C,0x36,0x00,0x00,0x00,0x00,0x00,
/* '+' */
  0x00,0x00,0x00,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x00,0x00,0x00,0x00,
/* ',' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x0C,0x0C,0x18,
/* '-' */
  0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '.' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x18,0x00,0x00,
/* '/' */
  0x00,0x03,0x06,0x06,0x0C,0x18,0x18,0x30,0x60,0x60,0xC0,0x00,0x00,0x00,
/* '0' */
  0x00,0x18,0x3C,0x66,0xC3,0xC3,0xC3,0xC3,0x66,0x3C,0x18,0x00,0x00,0x00,
/* '1' */
  0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,
/* '2' */
  0x00,0x3C,0x66,0xC3,0x03,0x06,0x0C,0x18,0x30,0x60,0xFF,0x00,0x00,0x00,
/* '3' */
  0x00,0x7C,0xC6,0x03,0x06,0x1C,0x06,0x03,0x03,0xC6,0x7C,0x00,0x00,0x00,
/* '4' */
  0x00,0x06,0x0E,0x1E,0x36,0x66,0xC6,0xFF,0x06,0x06,0x06,0x00,0x00,0x00,
/* '5' */
  0x00,0xFE,0xC0,0xC0,0xDC,0xE6,0x03,0x03,0xC3,0x66,0x3C,0x00,0x00,0x00,
/* '6' */
  0x00,0x3C,0x66,0xC2,0xC0,0xDC,0xE6,0xC3,0xC3,0x66,0x3C,0x00,0x00,0x00,
/* '7' */
  0x00,0xFF,0x03,0x03,0x06,0x0C,0x0C,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
/* '8' */
  0x00,0x3C,0x66,0xC3,0x66,0x3C,0x66,0xC3,0xC3,0x66,0x3C,0x00,0x00,0x00,
/* '9' */
  0x00,0x3C,0x66,0xC3,0xC3,0x67,0x3B,0x03,0x43,0x66,0x3C,0x00,0x00,0x00,
/* ':' */
  0x00,0x00,0x00,0x00,0x18,0x3C,0x18,0x00,0x00,0x18,0x3C,0x18,0x00,0x00,
/* ';' */
  0x00,0x00,0x00,0x00,0x18,0x3C,0x18,0x00,0x00,0x1C,0x1C,0x0C,0x0C,0x18,
/* '<' */
  0x00,0x06,0x0C,0x18,0x30,0x60,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,
/* '=' */
  0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
/* '>' */
  0x00,0x60,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,
/* '?' */
  0x00,0x3E,0x63,0x63,0x03,0x06,0x0C,0x18,0x00,0x18,0x18,0x00,0x00,0x00,
/* '@' */
  0x00,0x3C,0x66,0xC3,0xCF,0xDB,0xDB,0xCE,0xC0,0x63,0x3E,0x00,0x00,0x00,
/* 'A' */
  0x00,0x18,0x3C,0x66,0xC3,0xC3,0xC3,0xFF,0xC3,0xC3,0xC3,0x00,0x00,0x00,
/* 'B' */
  0x00,0xFC,0xC6,0xC3,0xC6,0xFC,0xC6,0xC3,0xC3,0xC6,0xFC,0x00,0x00,0x00,
/* 'C' */
  0x00,0x3E,0x63,0xC1,0xC0,0xC0,0xC0,0xC0,0xC1,0x63,0x3E,0x00,0x00,0x00,
/* 'D' */
  0x00,0xFC,0xC6,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0xC6,0xFC,0x00,0x00,0x00,
/* 'E' */
  0x00,0x7F,0x60,0x60,0x60,0x7E,0x60,0x60,0x60,0x60,0x7F,0x00,0x00,0x00,
/* 'F' */
  0x00,0xFF,0xC0,0xC0,0xC0,0xFC,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,
/* 'G' */
  0x00,0x3E,0x63,0xC0,0xC0,0xC0,0xC7,0xC3,0xC3,0x63,0x3E,0x00,0x00,0x00,
/* 'H' */
  0x00,0xC3,0xC3,0xC3,0xC3,0xFF,0xC3,0xC3,0xC3,0xC3,0xC3,0x00,0x00,0x00,
/* 'I' */
  0x00,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,
/* 'J' */
  0x00,0x1E,0x06,0x06,0x06,0x06,0x06,0x06,0x46,0x6C,0x38,0x00,0x00,0x00,
/* 'K' */
  0x00,0xC3,0xC6,0xCC,0xD8,0xF0,0xF0,0xD8,0xCC,0xC6,0xC3,0x00,0x00,0x00,
/* 'L' */
  0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x7F,0x00,0x00,0x00,
/* 'M' */
  0x00,0xC3,0xE7,0xFF,0xDB,0xDB,0xDB,0xC3,0xC3,0xC3,0xC3,0x00,0x00,0x00,
/* 'N' */
  0x00,0xC3,0xE3,0xF3,0xF3,0xDB,0xDB,0xCF,0xC7,0xC7,0xC3,0x00,0x00,0x00,
/* 'O' */
  0x00,0x3C,0x66,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0x66,0x3C,0x00,0x00,0x00,
/* 'P' */
  0x00,0xFE,0xC3,0xC3,0xC3,0xFE,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,
/* 'Q' */
  0x00,0x3C,0x66,0xC3,0xC3,0xC3,0xC3,0xDB,0xCF,0x66,0x3D,0x00,0x00,0x00,
/* 'R' */
  0x00,0xFE,0xC3,0xC3,0xC3,0xFE,0xF8,0xCC,0xC6,0xC3,0xC3,0x00,0x00,0x00,
/* 'S' */
  0x00,0x7E,0xC3,0xC0,0xC0,0x7E,0x03,0x03,0x03,0xC3,0x7E,0x00,0x00,0x00,
/* 'T' */
  0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
/* 'U' */
  0x00,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0x66,0x3C,0x00,0x00,0x00,
/* 'V' */
  0x00,0xC3,0xC3,0xC3,0x66,0x66,0x66,0x3C,0x3C,0x18,0x18,0x00,0x00,0x00,
/* 'W' */
  0x00,0xC3,0xC3,0xC3,0xC3,0xDB,0xDB,0xDB,0xFF,0xE7,0xC3,0x00,0x00,0x00,
/* 'X' */
  0x00,0xC3,0xC3,0x66,0x3C,0x18,0x18,0x3C,0x66,0xC3,0xC3,0x00,0x00,0x00,
/* 'Y' */
  0x00,0xC3,0xC3,0x66,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
/* 'Z' */
  0x00,0x7F,0x03,0x03,0x06,0x0C,0x18,0x30,0x60,0x60,0x7F,0x00,0x00,0x00,
/* '[' */
  0x3E,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3E,0x00,0x00,
/* '\' */
  0x00,0xC0,0x60,0x60,0x30,0x18,0x18,0x0C,0x06,0x06,0x03,0x00,0x00,0x00,
/* ']' */
  0x3E,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x3E,0x00,0x00,
/* '^' */
  0x00,0x18,0x3C,0x66,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '_' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,
/* '`' */
  0x30,0x18,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '{' */
  0x0E,0x18,0x18,0x18,0x18,0x30,0x30,0x18,0x18,0x18,0x18,0x0E,0x00,0x00,
/* '|' */
  0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
/* '}' */
  0x38,0x0C,0x0C,0x0C,0x0C,0x06,0x06,0x0C,0x0C,0x0C,0x0C,0x38,0x00,0x00,
/* '~' */
  0x00,0x73,0xDB,0xCE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
