/*
 *  The CPT4 character set consists of the 'unknown character',
 *  the 'mask character', and the ASCII character set from ' '
 *  through  '~' but omitting the lower case alphabet.
 */
#ifndef _CPT4DEF
#define UCHAR_PSEUDO_ASCII 1
#define MCHAR_PSEUDO_ASCII 2
#define UNK_CHARSET_INDEX 0
#define MSK_CHARSET_INDEX 1
#define SPC_CHARSET_INDEX 2
#define CHARSET_CNT 71
typedef struct
{
  char *ff_name;
  char width;
  char cs_ink_width;
  char cs_ink_height;
  char ab_ink_width;
  char ab_ink_height;
  char ab_offset_dn;
  char ab_offset_rt;
  char lbr[CHARSET_CNT];
  char rbr[CHARSET_CNT];
  char asc[CHARSET_CNT];
  char dsc[CHARSET_CNT];
  unsigned char *bitpatterns;
} cpt4_ff_t;
#define _CPT4DEF
#endif
cpt4_ff_t fnt7x13b_font = {
  "fnt7x13b",
   7, /* width         */
   6, /* cs_ink_width  */
  11, /* cs_ink_height */
   6, /* ab_ink_width  */
  10, /* ab_ink_height */
   1, /* ab_offset_dn  */
   0, /* ab_offset_rt  */
  {   /* lbr */
      0,  0,  0,  2,  1,  1,  0,  0,  0,  2,  1,  1,  0,  0,  1,  0,
      1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  1,
      0,  0,  1,  1,  2,  1,  0
  },
  {   /* rbr */
      6,  6,  0,  4,  6,  6,  6,  6,  6,  4,  5,  5,  6,  6,  5,  6,
      5,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  5,  5,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  5,  6,  5,
      6,  6,  5,  5,  4,  5,  6
  },
  {   /* asc */
      9, 10,  0,  9,  9,  9,  9,  9,  9,  9,  9,  9,  7,  7,  3,  4,
      2,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  7,  7,  9,  6,
      9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
      9,  1, 10,  9,  9,  9,  9
  },
  {   /* dsc */
      1,  1,  0,  0, -6,  0,  0,  0,  0, -5,  0,  0, -1, -1,  1, -3,
      1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0, -2,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     -5,  1, -7,  0,  0,  0, -6
  },
  NULL /* bitpatterns array */
};
unsigned char fnt7x13b_data[] = {
/* UNK */
  0x00,0xFC,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0xFC,
/* MSK */
  0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,
/* ' ' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '!' */
  0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x30,0x00,
/* '"' */
  0x00,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '#' */
  0x00,0x28,0x28,0x7C,0x7C,0x28,0x7C,0x7C,0x28,0x28,0x00,
/* '$' */
  0x00,0x30,0x78,0xB4,0xB0,0x78,0x34,0xB4,0x78,0x30,0x00,
/* '%' */
  0x00,0xE4,0xAC,0xE8,0x18,0x30,0x60,0x5C,0xD4,0x9C,0x00,
/* '&' */
  0x00,0x70,0xD8,0xD8,0xD8,0x70,0xD4,0xDC,0xD8,0x74,0x00,
/* ''' */
  0x00,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
/* '(' */
  0x00,0x18,0x30,0x30,0x60,0x60,0x60,0x30,0x30,0x18,0x00,
/* ')' */
  0x00,0x60,0x30,0x30,0x18,0x18,0x18,0x30,0x30,0x60,0x00,
/* '*' */
  0x00,0x00,0x00,0x48,0x30,0xFC,0xFC,0x30,0x48,0x00,0x00,
/* '+' */
  0x00,0x00,0x00,0x30,0x30,0xFC,0xFC,0x30,0x30,0x00,0x00,
/* ',' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x30,0x60,
/* '-' */
  0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,
/* '.' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x78,0x30,
/* '/' */
  0x00,0x0C,0x0C,0x18,0x18,0x30,0x60,0x60,0xC0,0xC0,0x00,
/* '0' */
  0x00,0x30,0x48,0xCC,0xCC,0xCC,0xCC,0xCC,0x48,0x30,0x00,
/* '1' */
  0x00,0x30,0x70,0xB0,0x30,0x30,0x30,0x30,0x30,0xFC,0x00,
/* '2' */
  0x00,0x78,0xCC,0xCC,0x0C,0x38,0x60,0xC0,0xC0,0xFC,0x00,
/* '3' */
  0x00,0xFC,0x0C,0x18,0x30,0x78,0x0C,0x0C,0xCC,0x78,0x00,
/* '4' */
  0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xCC,0xFC,0x0C,0x0C,0x00,
/* '5' */
  0x00,0xFC,0xC0,0xC0,0xF8,0xCC,0x0C,0x0C,0xCC,0x78,0x00,
/* '6' */
  0x00,0x78,0xCC,0xC0,0xC0,0xF8,0xCC,0xCC,0xCC,0x78,0x00,
/* '7' */
  0x00,0xFC,0x0C,0x0C,0x18,0x18,0x30,0x30,0x60,0x60,0x00,
/* '8' */
  0x00,0x78,0xCC,0xCC,0xCC,0x78,0xCC,0xCC,0xCC,0x78,0x00,
/* '9' */
  0x00,0x78,0xCC,0xCC,0xCC,0x7C,0x0C,0x0C,0xCC,0x78,0x00,
/* ':' */
  0x00,0x00,0x00,0x30,0x78,0x30,0x00,0x00,0x30,0x78,0x30,
/* ';' */
  0x00,0x00,0x00,0x30,0x78,0x30,0x00,0x38,0x38,0x30,0x60,
/* '<' */
  0x00,0x0C,0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x0C,0x00,
/* '=' */
  0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00,0x00,
/* '>' */
  0x00,0xC0,0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0xC0,0x00,
/* '?' */
  0x00,0x78,0xCC,0xCC,0x0C,0x38,0x30,0x00,0x30,0x30,0x00,
/* '@' */
  0x00,0x78,0x8C,0x8C,0xBC,0xAC,0xBC,0x80,0x8C,0x78,0x00,
/* 'A' */
  0x00,0x78,0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0xCC,0x00,
/* 'B' */
  0x00,0xF8,0xCC,0xCC,0xCC,0xF8,0xCC,0xCC,0xCC,0xF8,0x00,
/* 'C' */
  0x00,0x78,0xCC,0xC0,0xC0,0xC0,0xC0,0xC0,0xCC,0x78,0x00,
/* 'D' */
  0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xF8,0x00,
/* 'E' */
  0x00,0xFC,0xC0,0xC0,0xC0,0xF8,0xC0,0xC0,0xC0,0xFC,0x00,
/* 'F' */
  0x00,0xFC,0xC0,0xC0,0xC0,0xF8,0xC0,0xC0,0xC0,0xC0,0x00,
/* 'G' */
  0x00,0x78,0xCC,0xC0,0xC0,0xDC,0xCC,0xCC,0xCC,0x7C,0x00,
/* 'H' */
  0x00,0xCC,0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0xCC,0x00,
/* 'I' */
  0x00,0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xFC,0x00,
/* 'J' */
  0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0x78,0x00,
/* 'K' */
  0x00,0xC4,0xCC,0xD8,0xF0,0xE0,0xF0,0xD8,0xCC,0xC4,0x00,
/* 'L' */
  0x00,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFC,0x00,
/* 'M' */
  0x00,0x84,0xCC,0xFC,0xFC,0xCC,0xCC,0xCC,0xCC,0xCC,0x00,
/* 'N' */
  0x00,0xCC,0xCC,0xEC,0xEC,0xFC,0xDC,0xDC,0xCC,0xCC,0x00,
/* 'O' */
  0x00,0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x00,
/* 'P' */
  0x00,0xF8,0xCC,0xCC,0xCC,0xF8,0xC0,0xC0,0xC0,0xC0,0x00,
/* 'Q' */
  0x00,0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0xEC,0xDC,0x78,0x0C,
/* 'R' */
  0x00,0xF8,0xCC,0xCC,0xCC,0xF8,0xF0,0xD8,0xCC,0xC4,0x00,
/* 'S' */
  0x00,0x78,0xCC,0xC0,0xC0,0x78,0x0C,0x0C,0xCC,0x78,0x00,
/* 'T' */
  0x00,0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,
/* 'U' */
  0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x00,
/* 'V' */
  0x00,0xCC,0xCC,0xCC,0x48,0x48,0x78,0x30,0x30,0x30,0x00,
/* 'W' */
  0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0xFC,0xCC,0x84,0x00,
/* 'X' */
  0x00,0x84,0xCC,0x48,0x78,0x30,0x78,0x48,0xCC,0x84,0x00,
/* 'Y' */
  0x00,0xCC,0xCC,0x78,0x78,0x30,0x30,0x30,0x30,0x30,0x00,
/* 'Z' */
  0x00,0xFC,0x0C,0x0C,0x18,0x30,0x60,0xC0,0xC0,0xFC,0x00,
/* '[' */
  0x00,0x78,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x78,0x00,
/* '\' */
  0x00,0xC0,0xC0,0x60,0x60,0x30,0x18,0x18,0x0C,0x0C,0x00,
/* ']' */
  0x00,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x78,0x00,
/* '^' */
  0x00,0x30,0x78,0xCC,0x84,0x00,0x00,0x00,0x00,0x00,0x00,
/* '_' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,
/* '`' */
  0x60,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* '{' */
  0x00,0x38,0x60,0x60,0x30,0x60,0x30,0x60,0x60,0x38,0x00,
/* '|' */
  0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,
/* '}' */
  0x00,0x70,0x18,0x18,0x30,0x18,0x30,0x18,0x18,0x70,0x00,
/* '~' */
  0x00,0x64,0xFC,0x98,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
