/*
 *  The CPT4 character set consists of the 'unknown character',
 *  the 'mask character', and the ASCII character set from ' '
 *  through  '~' but omitting the lower case alphabet.
 */
#ifndef _CPT4DEF
#define UCHAR_PSEUDO_ASCII 1
#define MCHAR_PSEUDO_ASCII 2
#define UNK_CHARSET_INDEX 0
#define MSK_CHARSET_INDEX 1
#define SPC_CHARSET_INDEX 2
#define CHARSET_CNT 71
typedef struct
{
  char *ff_name;
  char width;
  char cs_ink_width;
  char cs_ink_height;
  char ab_ink_width;
  char ab_ink_height;
  char ab_offset_dn;
  char ab_offset_rt;
  char lbr[CHARSET_CNT];
  char rbr[CHARSET_CNT];
  char asc[CHARSET_CNT];
  char dsc[CHARSET_CNT];
  unsigned char *bitpatterns;
} cpt4_ff_t;
#define _CPT4DEF
#endif
cpt4_ff_t fnt12x24m_font = {
  "fnt12x24m",
  12, /* width         */
  12, /* cs_ink_width  */
  24, /* cs_ink_height */
  12, /* ab_ink_width  */
  22, /* ab_ink_height */
   2, /* ab_offset_dn  */
   0, /* ab_offset_rt  */
  {   /* lbr */
      0,  0,  0,  4,  1,  0,  0,  0,  0,  3,  4,  1,  0,  1,  3,  0,
      3,  0,  0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  4,  4,  1,  0,
      1,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  1,
      0,  0,  2,  5,  5,  1,  0
  },
  {   /* rbr */
     12, 12,  0,  7,  9, 11, 11, 11, 11,  6, 10,  7, 10, 11,  6, 11,
      6, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 11,  7,  7, 11, 11,
     11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11,  8, 11, 11, 11, 12,
     11, 11, 11, 11, 11, 11, 10, 11, 11, 11, 11, 11, 11, 10, 11,  7,
     11, 11,  9, 10,  7,  6, 11
  },
  {   /* asc */
     20, 22,  0, 20, 22, 21, 21, 21, 20, 22, 22, 22, 16, 17,  4, 11,
      4, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 14, 14, 20, 14,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 21, 22,
     22,  0, 22, 22, 22, 22, 22
  },
  {   /* dsc */
      2,  2,  0, -1,-16,  1,  1,  1, -1,-16,  2,  2, -4, -3,  2, -9,
     -1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1,  2,  0, -6,
      0, -1,  0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1,  2, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  1,  2,
    -16,  2,-17,  2,  2,  2,-18
  },
  NULL /* bitpatterns array */
};
unsigned char fnt12x24m_data[] = {
/* UNK */
  0x00,0x00,0x00,0x00,0xFF,0xF0,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,
  0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,
  0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,
  0x80,0x10,0x80,0x10,0xFF,0xF0,
/* MSK */
  0xAA,0xA0,0x55,0x50,0xAA,0xA0,0x55,0x50,0xAA,0xA0,0x55,0x50,0xAA,0xA0,
  0x55,0x50,0xAA,0xA0,0x55,0x50,0xAA,0xA0,0x55,0x50,0xAA,0xA0,0x55,0x50,
  0xAA,0xA0,0x55,0x50,0xAA,0xA0,0x55,0x50,0xAA,0xA0,0x55,0x50,0xAA,0xA0,
  0x55,0x50,0xAA,0xA0,0x55,0x50,
/* ' ' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '!' */
  0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
  0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x04,0x00,0x04,0x00,0x04,0x00,
  0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '"' */
  0x73,0x80,0x73,0x80,0x31,0x80,0x31,0x80,0x21,0x00,0x42,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '#' */
  0x00,0x00,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,
  0x7F,0xE0,0x7F,0xE0,0x11,0x00,0x11,0x00,0x11,0x00,0x11,0x00,0x11,0x00,
  0x11,0x00,0xFF,0xC0,0xFF,0xC0,0x22,0x00,0x22,0x00,0x22,0x00,0x22,0x00,
  0x22,0x00,0x22,0x00,0x00,0x00,
/* '$' */
  0x00,0x00,0x04,0x00,0x04,0x00,0x1F,0x00,0x64,0xC0,0xC4,0x60,0xC4,0x60,
  0xC4,0x00,0xC4,0x00,0xE4,0x00,0x7C,0x00,0x1F,0x00,0x07,0xC0,0x04,0xE0,
  0x04,0x60,0x04,0x60,0x04,0x60,0xC4,0x60,0xC4,0x60,0x64,0xC0,0x1F,0x00,
  0x04,0x00,0x04,0x00,0x00,0x00,
/* '%' */
  0x00,0x00,0x78,0x20,0xCC,0x20,0xCC,0x40,0xCC,0x40,0xCC,0x80,0xCC,0x80,
  0x79,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x04,0x00,0x08,0x00,
  0x08,0x00,0x10,0x00,0x13,0xC0,0x26,0x60,0x26,0x60,0x46,0x60,0x46,0x60,
  0x86,0x60,0x83,0xC0,0x00,0x00,
/* '&' */
  0x00,0x00,0x00,0x00,0x1E,0x00,0x21,0x00,0x61,0x80,0x61,0x80,0x61,0x80,
  0x63,0x00,0x66,0x00,0x34,0x00,0x18,0x00,0x18,0x00,0x2C,0x00,0x44,0x00,
  0xC6,0x60,0xC3,0x20,0xC1,0x60,0xC1,0xC0,0xC0,0x80,0x61,0xC0,0x3F,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* ''' */
  0x1C,0x00,0x1C,0x00,0x0C,0x00,0x0C,0x00,0x08,0x00,0x10,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '(' */
  0x00,0x40,0x00,0x80,0x01,0x80,0x01,0x00,0x03,0x00,0x02,0x00,0x06,0x00,
  0x06,0x00,0x04,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x04,0x00,0x06,0x00,0x06,0x00,0x02,0x00,0x03,0x00,0x01,0x00,
  0x01,0x80,0x00,0x80,0x00,0x40,
/* ')' */
  0x40,0x00,0x20,0x00,0x30,0x00,0x10,0x00,0x18,0x00,0x08,0x00,0x0C,0x00,
  0x0C,0x00,0x04,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x04,0x00,0x0C,0x00,0x0C,0x00,0x08,0x00,0x18,0x00,0x10,0x00,
  0x30,0x00,0x20,0x00,0x40,0x00,
/* '*' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,
  0x0C,0x00,0xCC,0xC0,0xED,0xC0,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x3F,0x00,
  0xED,0xC0,0xCC,0xC0,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '+' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x7F,0xE0,0x7F,0xE0,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* ',' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x0C,0x00,
  0x0C,0x00,0x08,0x00,0x10,0x00,
/* '-' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE0,0xFF,0xE0,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '.' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '/' */
  0x00,0x00,0x00,0x20,0x00,0x60,0x00,0x40,0x00,0xC0,0x00,0x80,0x01,0x80,
  0x01,0x00,0x03,0x00,0x02,0x00,0x06,0x00,0x04,0x00,0x0C,0x00,0x08,0x00,
  0x18,0x00,0x10,0x00,0x30,0x00,0x20,0x00,0x60,0x00,0x40,0x00,0xC0,0x00,
  0x80,0x00,0x80,0x00,0x00,0x00,
/* '0' */
  0x00,0x00,0x00,0x00,0x0E,0x00,0x1B,0x00,0x31,0x80,0x20,0x80,0x60,0xC0,
  0x40,0x40,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,
  0xC0,0x60,0xC0,0x60,0x40,0x40,0x60,0xC0,0x20,0x80,0x31,0x80,0x1B,0x00,
  0x0E,0x00,0x00,0x00,0x00,0x00,
/* '1' */
  0x00,0x00,0x00,0x00,0x06,0x00,0x0E,0x00,0x1E,0x00,0x7E,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x3F,0xC0,0x00,0x00,0x00,0x00,
/* '2' */
  0x00,0x00,0x00,0x00,0x0E,0x00,0x31,0x80,0x60,0xC0,0x40,0x60,0x80,0x60,
  0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x01,0x80,0x03,0x00,0x02,0x00,
  0x04,0x00,0x08,0x00,0x10,0x00,0x20,0x20,0x40,0x20,0x40,0x60,0xFF,0xE0,
  0xFF,0xE0,0x00,0x00,0x00,0x00,
/* '3' */
  0x00,0x00,0x00,0x00,0x3E,0x00,0x63,0x80,0x81,0x80,0x00,0xC0,0x00,0xC0,
  0x00,0xC0,0x00,0x80,0x01,0x00,0x1E,0x00,0x3F,0x80,0x01,0xC0,0x00,0xE0,
  0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xC0,0x01,0x80,0x07,0x00,
  0xF8,0x00,0x00,0x00,0x00,0x00,
/* '4' */
  0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x03,0x80,0x03,0x80,0x05,0x80,
  0x05,0x80,0x09,0x80,0x09,0x80,0x11,0x80,0x11,0x80,0x21,0x80,0x21,0x80,
  0x41,0x80,0x41,0x80,0xFF,0xE0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
  0x07,0xE0,0x00,0x00,0x00,0x00,
/* '5' */
  0x00,0x00,0x00,0x00,0x7F,0xE0,0x7F,0xC0,0x40,0x00,0x40,0x00,0x40,0x00,
  0x40,0x00,0x40,0x00,0x5F,0x00,0x71,0x80,0x60,0xC0,0x40,0x60,0x00,0x60,
  0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x03,0x80,
  0x7C,0x00,0x00,0x00,0x00,0x00,
/* '6' */
  0x00,0x00,0x00,0x00,0x03,0x80,0x0C,0x00,0x10,0x00,0x30,0x00,0x60,0x00,
  0x60,0x00,0xC0,0x00,0xC0,0x00,0xCF,0x00,0xF0,0xC0,0xC0,0x60,0xC0,0x60,
  0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0x60,0xC0,0x60,0xC0,0x31,0x80,
  0x0E,0x00,0x00,0x00,0x00,0x00,
/* '7' */
  0x00,0x00,0x00,0x00,0xFF,0xE0,0xFF,0xE0,0xC0,0x20,0x80,0x40,0x80,0x80,
  0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x06,0x00,0x06,0x00,
  0x04,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x00,0x00,0x00,0x00,
/* '8' */
  0x00,0x00,0x00,0x00,0x0E,0x00,0x31,0x80,0x20,0x80,0x60,0xC0,0x60,0xC0,
  0x60,0xC0,0x60,0xC0,0x30,0x80,0x39,0x00,0x1E,0x00,0x1F,0x00,0x23,0xC0,
  0x40,0xC0,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0x40,0x40,0x60,0xC0,
  0x1F,0x00,0x00,0x00,0x00,0x00,
/* '9' */
  0x00,0x00,0x00,0x00,0x0E,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,0xC0,0x60,
  0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0x40,0x60,0x61,0xE0,0x1E,0x60,
  0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x01,0x80,0x01,0x00,0x06,0x00,
  0x38,0x00,0x00,0x00,0x00,0x00,
/* ':' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* ';' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x06,0x00,
  0x06,0x00,0x04,0x00,0x08,0x00,
/* '<' */
  0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,
  0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0x30,0x00,
  0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,
  0x00,0x20,0x00,0x00,0x00,0x00,
/* '=' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xE0,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xE0,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '>' */
  0x00,0x00,0x00,0x00,0x40,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,
  0x06,0x00,0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0xC0,
  0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,
  0x40,0x00,0x00,0x00,0x00,0x00,
/* '?' */
  0x00,0x00,0x00,0x00,0x0F,0x00,0x30,0xC0,0x60,0x60,0x60,0x60,0x70,0x60,
  0x30,0x60,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x02,0x00,0x04,0x00,
  0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '@' */
  0x00,0x00,0x00,0x00,0x1F,0x00,0x20,0x80,0x60,0xC0,0x40,0x40,0xC0,0x60,
  0x8D,0x20,0x97,0x20,0xB3,0x20,0xB3,0x20,0xB3,0x20,0xB3,0x20,0xB3,0x20,
  0xB3,0x20,0xB7,0x60,0x9D,0xC0,0xC0,0x00,0x40,0x00,0x60,0x20,0x20,0xC0,
  0x1F,0x00,0x00,0x00,0x00,0x00,
/* 'A' */
  0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0B,0x00,0x0B,0x00,
  0x0B,0x00,0x09,0x80,0x11,0x80,0x11,0x80,0x11,0x80,0x20,0xC0,0x20,0xC0,
  0x3F,0xC0,0x20,0xC0,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0xE0,0xF0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'B' */
  0x00,0x00,0x00,0x00,0xFE,0x00,0x61,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,
  0x60,0xC0,0x60,0xC0,0x60,0x80,0x61,0x00,0x7E,0x00,0x61,0x80,0x60,0xC0,
  0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0xC0,0x61,0x80,0xFE,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'C' */
  0x00,0x00,0x00,0x00,0x07,0x20,0x18,0xE0,0x30,0x60,0x30,0x20,0x60,0x00,
  0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,
  0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x20,0x30,0x20,0x18,0xC0,0x07,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'D' */
  0x00,0x00,0x00,0x00,0xFC,0x00,0x63,0x00,0x61,0x80,0x60,0xC0,0x60,0xC0,
  0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
  0x60,0x60,0x60,0x60,0x60,0xC0,0x60,0xC0,0x61,0x80,0x63,0x00,0xFC,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'E' */
  0x00,0x00,0x00,0x00,0xFF,0xC0,0x60,0xC0,0x60,0x40,0x60,0x20,0x60,0x00,
  0x60,0x00,0x61,0x00,0x61,0x00,0x63,0x00,0x7F,0x00,0x63,0x00,0x61,0x00,
  0x61,0x00,0x60,0x00,0x60,0x00,0x60,0x20,0x60,0x40,0x60,0xC0,0xFF,0xC0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'F' */
  0x00,0x00,0x00,0x00,0xFF,0xC0,0x60,0xC0,0x60,0x40,0x60,0x20,0x60,0x00,
  0x60,0x00,0x61,0x00,0x61,0x00,0x63,0x00,0x7F,0x00,0x63,0x00,0x61,0x00,
  0x61,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'G' */
  0x00,0x00,0x00,0x00,0x0E,0x40,0x31,0xC0,0x60,0xC0,0x60,0x40,0xC0,0x00,
  0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC3,0xE0,0xC0,0xC0,
  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x60,0xC0,0x60,0xC0,0x31,0xC0,0x0E,0x40,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'H' */
  0x00,0x00,0x00,0x00,0xF1,0xE0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
  0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x7F,0xC0,0x60,0xC0,0x60,0xC0,
  0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0xF1,0xE0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'I' */
  0x00,0x00,0x00,0x00,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x3F,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'J' */
  0x00,0x00,0x00,0x00,0x07,0xE0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
  0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
  0x01,0x80,0x61,0x80,0xE1,0x80,0xC1,0x80,0xC1,0x80,0x63,0x00,0x1C,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'K' */
  0x00,0x00,0x00,0x00,0xF1,0xE0,0x60,0x40,0x60,0x80,0x60,0x80,0x61,0x00,
  0x62,0x00,0x62,0x00,0x64,0x00,0x68,0x00,0x7C,0x00,0x7C,0x00,0x66,0x00,
  0x66,0x00,0x63,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x60,0xC0,0xF1,0xE0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'L' */
  0x00,0x00,0x00,0x00,0xF0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,
  0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,
  0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x20,0x60,0x40,0x60,0xC0,0xFF,0xC0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'M' */
  0x00,0x00,0x00,0x00,0xE0,0x70,0x60,0x60,0x60,0xE0,0x70,0xE0,0x70,0xE0,
  0x71,0x60,0x59,0x60,0x59,0x60,0x5B,0x60,0x4E,0x60,0x4E,0x60,0x4E,0x60,
  0x44,0x60,0x44,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0xE0,0xF0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'N' */
  0x00,0x00,0x00,0x00,0xE0,0xE0,0x60,0x40,0x70,0x40,0x70,0x40,0x70,0x40,
  0x58,0x40,0x58,0x40,0x4C,0x40,0x4C,0x40,0x46,0x40,0x46,0x40,0x43,0x40,
  0x43,0x40,0x43,0x40,0x41,0xC0,0x41,0xC0,0x40,0xC0,0x40,0xC0,0xE0,0x40,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'O' */
  0x00,0x00,0x00,0x00,0x1F,0x00,0x60,0xC0,0x40,0x40,0xC0,0x60,0xC0,0x60,
  0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,
  0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0x40,0x40,0x60,0xC0,0x1F,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'P' */
  0x00,0x00,0x00,0x00,0xFE,0x00,0x61,0x80,0x60,0xC0,0x60,0x60,0x60,0x60,
  0x60,0x60,0x60,0x60,0x60,0x60,0x60,0xC0,0x61,0x80,0x7E,0x00,0x60,0x00,
  0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xF0,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'Q' */
  0x00,0x00,0x00,0x00,0x1E,0x00,0x61,0x80,0x40,0x80,0xC0,0xC0,0xC0,0xC0,
  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,
  0xC0,0xC0,0xC0,0xC0,0xCC,0xC0,0xD2,0xC0,0x62,0x80,0x63,0x80,0x1E,0x00,
  0x03,0x20,0x01,0xE0,0x00,0xC0,
/* 'R' */
  0x00,0x00,0x00,0x00,0xFE,0x00,0x61,0x80,0x60,0x80,0x60,0xC0,0x60,0xC0,
  0x60,0xC0,0x60,0xC0,0x60,0x80,0x61,0x80,0x7E,0x00,0x62,0x00,0x61,0x00,
  0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0xA0,0x61,0xA0,0xF0,0xC0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'S' */
  0x00,0x00,0x00,0x00,0x1E,0x40,0x61,0xC0,0xC0,0xC0,0xC0,0x40,0xC0,0x00,
  0xC0,0x00,0xE0,0x00,0x70,0x00,0x3E,0x00,0x0F,0x80,0x01,0xC0,0x00,0xE0,
  0x00,0x60,0x00,0x60,0x00,0x60,0x80,0x60,0xC0,0xC0,0xE1,0x80,0x9E,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'T' */
  0x00,0x00,0x00,0x00,0xFF,0xC0,0xCC,0xC0,0x8C,0x40,0x8C,0x40,0x8C,0x40,
  0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x1E,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'U' */
  0x00,0x00,0x00,0x00,0xF0,0xE0,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,
  0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,
  0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,0x30,0x80,0x1F,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'V' */
  0x00,0x00,0x00,0x00,0xF0,0xE0,0x60,0x40,0x60,0x40,0x60,0x40,0x60,0x40,
  0x30,0x80,0x30,0x80,0x30,0x80,0x30,0x80,0x19,0x00,0x19,0x00,0x19,0x00,
  0x1B,0x00,0x0A,0x00,0x0E,0x00,0x0E,0x00,0x04,0x00,0x04,0x00,0x04,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'W' */
  0x00,0x00,0x00,0x00,0xE0,0x60,0xC0,0x20,0xC0,0x20,0xC0,0x20,0xC0,0x20,
  0xC0,0x20,0xC6,0x20,0xC6,0x20,0xC6,0x20,0xC6,0x20,0xC6,0x20,0xCF,0x20,
  0xCB,0x20,0x6B,0x40,0x6B,0x40,0x71,0x40,0x71,0xC0,0x31,0x80,0x31,0x80,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'X' */
  0x00,0x00,0x00,0x00,0xF0,0xE0,0x60,0x40,0x60,0x40,0x30,0x80,0x30,0x80,
  0x19,0x00,0x19,0x00,0x0A,0x00,0x0E,0x00,0x04,0x00,0x0E,0x00,0x0A,0x00,
  0x13,0x00,0x13,0x00,0x21,0x80,0x21,0x80,0x40,0xC0,0x40,0xC0,0xE1,0xE0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'Y' */
  0x00,0x00,0x00,0x00,0xF0,0xE0,0x60,0x40,0x60,0x40,0x30,0x80,0x30,0x80,
  0x30,0x80,0x19,0x00,0x19,0x00,0x0F,0x00,0x0E,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x1F,0x80,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* 'Z' */
  0x00,0x00,0x00,0x00,0x7F,0xE0,0x40,0xC0,0x40,0xC0,0x81,0x80,0x01,0x80,
  0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,
  0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x20,0x60,0x40,0x60,0xC0,0xFF,0xC0,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '[' */
  0x00,0xC0,0x03,0x80,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
  0x0E,0x00,0x03,0x80,0x00,0xC0,
/* '\' */
  0x00,0x00,0x80,0x00,0xC0,0x00,0x40,0x00,0x60,0x00,0x20,0x00,0x30,0x00,
  0x10,0x00,0x18,0x00,0x08,0x00,0x0C,0x00,0x04,0x00,0x06,0x00,0x02,0x00,
  0x03,0x00,0x01,0x00,0x01,0x80,0x00,0x80,0x00,0xC0,0x00,0x40,0x00,0x60,
  0x00,0x20,0x00,0x20,0x00,0x00,
/* ']' */
  0x60,0x00,0x78,0x00,0x1E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x1E,0x00,0x78,0x00,0x60,0x00,
/* '^' */
  0x04,0x00,0x0E,0x00,0x1F,0x00,0x3B,0x80,0x60,0xC0,0xC0,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '_' */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xE0,0xFF,0xE0,
/* '`' */
  0x18,0x00,0x3C,0x00,0x1E,0x00,0x07,0x00,0x01,0x80,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
/* '{' */
  0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
  0x01,0x80,0x01,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x02,0x00,0x01,0x00,
  0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
  0x00,0x80,0x00,0x80,0x00,0x40,
/* '|' */
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
  0x06,0x00,0x06,0x00,0x06,0x00,
/* '}' */
  0x40,0x00,0x20,0x00,0x20,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
  0x30,0x00,0x30,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0x08,0x00,0x10,0x00,
  0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
  0x20,0x00,0x20,0x00,0x40,0x00,
/* '~' */
  0x38,0x20,0x7C,0x60,0xC7,0xC0,0x83,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00
};
