/*
 *  cpt4qmsg  --  popup messages with two buttons for CPT4 4.1 for X / Linux
 * 
 *  Author: Jeff Edwards
 * 
 *  This program is hereby placed in the public domain, June 2000,
 *  ---Jeff Edwards---
 *
 * =================================================================
 *
 *  Display a popup message with two buttons.
 *    - modal
 *    - won't resize
 * 
 *  The caller is expected to declare a STATIC GtkWidget pointer
 *  for this function's use and pass this function a pointer to
 *  it as its first argument.
 * 
 *  This function sets the caller's pointer to point to the new
 *  window's widget, and in addition arranges for gtk_widget_destroyed()
 *  to set the caller's pointer to NULL so that the caller can arrange
 *  to destroy the new message window if it's parent is destroyed (i.e.,
 *  by the window manager).
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include "cpt4qmsg.h"

void cpt4qmsg(
   GtkWidget **win,	      
   GtkWidget *parent,
   GdkColor *bg_color,
   GdkColor *fg_color,
   char *title,
   char *msg,
   char *Lbuttontxt,
   char *Rbuttontxt,
   void (*Lbuttonclicked_func) (GtkButton *, gpointer),
   void (*Rbuttonclicked_func) (GtkButton *, gpointer),
   gpointer Lbuttondata,
   gpointer Rbuttondata
) {
   int i;
   GtkStyle  *style;
   GtkWidget *frame;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *event_box;
   GtkWidget *label;
   GtkWidget *button;
   
   *win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW(*win), title);
   gtk_window_set_transient_for(GTK_WINDOW(*win), GTK_WINDOW(parent));
   gtk_window_set_resizable(GTK_WINDOW(*win),0);
   g_signal_connect(G_OBJECT(*win), "destroy",
	            G_CALLBACK(gtk_widget_destroyed),
                    (gpointer)win);
   gtk_window_set_modal(GTK_WINDOW(*win),1);
   gtk_window_set_position(GTK_WINDOW(*win), GTK_WIN_POS_MOUSE);
   style = gtk_style_copy((*win)->style);
   for (i=0;i<5;i++) {
      style->fg[i] = *fg_color;
      style->bg[i] = *bg_color;
   }
   /*
    *  The last argument in the next statement sets the spacing
    *  between the message frame and the buttons.
    */
   vbox = gtk_vbox_new(FALSE, 5);
   /*
    *  The last argument in the next statement sets the spacing around
    *  the inside edge of the window.
    */
   gtk_container_set_border_width (GTK_CONTAINER(vbox),5);
   gtk_container_add(GTK_CONTAINER(*win), vbox);
   gtk_widget_show(vbox);
   
   frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_ETCHED_IN);
   gtk_container_set_border_width (GTK_CONTAINER(frame),0);
   gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0); 
   gtk_widget_show(frame);
   
   event_box = gtk_event_box_new();
   gtk_widget_set_style(event_box, style);
   gtk_container_set_border_width (GTK_CONTAINER(event_box),0);
   gtk_container_add(GTK_CONTAINER(frame), event_box);
   gtk_widget_show (event_box);
   
   hbox = gtk_hbox_new(FALSE, 0);
   /*
    *  The border width set in the next statement sets the amount of 
    *  space between the message text and the frame.
    */
   gtk_container_set_border_width (GTK_CONTAINER(hbox),10);
   gtk_container_add(GTK_CONTAINER(event_box), hbox);
   gtk_widget_show (hbox);
   
   label = gtk_label_new(msg);
   gtk_widget_set_style(label, style);
   gtk_container_add(GTK_CONTAINER(hbox), label);
   gtk_widget_show (label);
    
   /*
    *  The last argument in the next statement sets the amount of space
    *  between the two buttons.
    */
   hbox = gtk_hbox_new(TRUE, 7);
   gtk_container_set_border_width (GTK_CONTAINER(hbox),0);
   gtk_widget_show (hbox);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0); 

   button = gtk_button_new_with_label(Lbuttontxt);
   gtk_widget_set_style(label, style);
   g_signal_connect (G_OBJECT(button), "clicked",
		     G_CALLBACK(Lbuttonclicked_func),
                     Lbuttondata);
   gtk_box_pack_start(GTK_BOX (hbox), button, TRUE, TRUE, 0);
   gtk_widget_show(button);

   button = gtk_button_new_with_label(Rbuttontxt);
   gtk_widget_set_style(label, style);
   g_signal_connect (G_OBJECT(button), "clicked",
		     G_CALLBACK(Rbuttonclicked_func),
                     Rbuttondata);
   gtk_box_pack_start(GTK_BOX (hbox), button, TRUE, TRUE, 0);
   gtk_widget_show(button);

   gtk_widget_show(*win);
  
   return; 
   
} /* end of cpt4qmsg() */
		 
