/*
 *  cpt4pmsg  --  popup messages for CPT4 version 4.1 for Linux
 * 
 *  Author: Jeff Edwards
 * 
 *  This program is hereby placed in the public domain, June 2000,
 *  ---Jeff Edwards---
 *
 * =================================================================
 *
 *  Display a popup message with a dismiss button
 *    - modal
 *    - won't resize
 */
#include <stdio.h>
#include <gtk/gtk.h>

static GtkStyle  *style;
static void (*callback) (void);

static void pmsg_destroyed (GtkObject *object, gpointer data)
{
   GtkWidget **p;
   
   p = (GtkWidget **)data;
   if (p != NULL) *p = NULL;

   /*
    *  Attempt to recover if the window manager kills the pmsg instead
    *  of the user clicking the button.
    */
   if (callback != NULL) {
      (*callback)();
      callback = NULL;
   }
   return;
   
}/* end of pmsg_destroyed() */

static void button_clicked (GtkWidget *widget, gpointer data)
{

   gtk_widget_destroy(*((GtkWidget **)data));
   if (callback != NULL) {
      (*callback)();
      callback = NULL;
   }
   return;
   
} /* end of button_pressed() */

void cpt4pmsg(GtkWidget **pmsg_window, GtkWidget *parent,
	      GdkColor *bg_color, GdkColor *fg_color,
	      char *button_title, char *title,  char *msg,
	      void (*closed_func) (void)
             )
{
   int i;
   GtkWidget *frame;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *event_box;
   GtkWidget *label;
   GtkWidget *button;

   callback = closed_func;
   
   *pmsg_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW(*pmsg_window), title);
   gtk_window_set_transient_for(GTK_WINDOW(*pmsg_window),
				GTK_WINDOW(parent));
   gtk_window_set_resizable(GTK_WINDOW(*pmsg_window),FALSE);
   g_signal_connect(*pmsg_window, "destroy",
                    G_CALLBACK (pmsg_destroyed),
                    (gpointer)pmsg_window);
   gtk_widget_add_events (*pmsg_window, GDK_STRUCTURE_MASK);
   gtk_window_set_modal(GTK_WINDOW(*pmsg_window),1);
   gtk_window_set_position(GTK_WINDOW(*pmsg_window), GTK_WIN_POS_MOUSE);
   style = gtk_style_copy((*pmsg_window)->style);
   for (i=0;i<5;i++) {
      style->fg[i] = *fg_color;
      style->bg[i] = *bg_color;
   }
   vbox = gtk_vbox_new(FALSE, 5);
   gtk_container_set_border_width (GTK_CONTAINER(vbox),5);
   gtk_container_add(GTK_CONTAINER(*pmsg_window), vbox);
   gtk_widget_show(vbox);
   
   frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_ETCHED_IN);
   gtk_container_set_border_width (GTK_CONTAINER(frame),0);
   gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0); 
   gtk_widget_show(frame);
   
   event_box = gtk_event_box_new();
   gtk_widget_set_style(event_box, style);
   gtk_container_set_border_width (GTK_CONTAINER(event_box),0);
   gtk_container_add(GTK_CONTAINER(frame), event_box);
   gtk_widget_show (event_box);
   
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width (GTK_CONTAINER(hbox),10);
   gtk_container_add(GTK_CONTAINER(event_box), hbox);
   gtk_widget_show (hbox);
   
   label = gtk_label_new(msg);
   gtk_widget_set_style(label, style);
   gtk_container_add(GTK_CONTAINER(hbox), label);
   gtk_widget_show (label);
    
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width (GTK_CONTAINER(hbox),0);
   gtk_widget_show (hbox);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0); 

   button = gtk_button_new_with_label(button_title);
   gtk_widget_set_style(label, style);
   g_signal_connect (G_OBJECT(button),"clicked",
		     G_CALLBACK(button_clicked),
                     (gpointer)pmsg_window);
   gtk_box_pack_end(GTK_BOX (hbox), button, TRUE, FALSE, 0);
   gtk_widget_show(button);

   gtk_widget_show(*pmsg_window);
  
   return; 
   
} /* end of cpt4pmsg() */
		 
