/*
 *  Help window for CPT4 version 4.1 for X / Linux
 * 
 *  Copyright (c) 2003 by Jeff Edwards
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "cpt4help.h"

/* The following defined in the main app file */ 
extern GdkColor cpt_help_bg_color;

static GtkTextBuffer *buffer;
static GtkWidget *text_view;
static GtkWidget *scrolled;
static GtkObject *scrolled_adj;
static GtkWidget *window;
static int state=0;

gint delete_event( GtkWidget *widget, GdkEvent *event, gpointer data)
{
   if (state == 1) {
      gtk_widget_hide(window);
      state = 2;
   }
   return(TRUE);
}

void cpt4help(GtkWidget *appwindow)
{
   int i,n;
   int height,width;
   char c,tmpstr[151];
   GtkWidget *label;
   PangoLayout *layout;
   PangoRectangle ink_rect;
   
   if (state == 0) goto construct;
   if (state == 1) return;
   gtk_widget_show(window);
   state = 1;
   return;
   
   /*
    *  We're going to try to make the help window just wide enough for the
    *  first line of text and 3/4 the height of the application window.
    */ 
construct:   
   for (i=0;i<150;i++) {
      /*
       * Here we copy the first line of help into a temporary string.
       */
      c = *(helptext+i);
      if ((c == 0) || (c == '\n')) break;
      tmpstr[i] = c;
   }
   if ((i > 0) && (c == '\n')) {
      tmpstr[i] = 0;
      label = gtk_label_new(tmpstr);
      layout = gtk_label_get_layout(GTK_LABEL(label));
      pango_layout_get_pixel_extents(layout,&ink_rect,NULL);
      width = ink_rect.width;
      n =  7*(appwindow->allocation.width)/8;
      if (width > n) width = n;
   }
   else width = 3*(appwindow->allocation.width)/4;
   height = 3*(appwindow->allocation.height)/4;   
   
   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_transient_for(GTK_WINDOW(window),
				GTK_WINDOW(appwindow));
   g_signal_connect(window, "delete_event",
                    G_CALLBACK (delete_event),
                    NULL);
   
   gtk_window_set_modal(GTK_WINDOW(window),0);
   gtk_window_set_resizable(GTK_WINDOW(window),TRUE);
   gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
   gtk_window_set_title (GTK_WINDOW (window), "CPT4 Help");
   gtk_container_set_border_width (GTK_CONTAINER (window), 0);

   window->style->base[0] = cpt_help_bg_color;
   window->style->base[1] = cpt_help_bg_color;
   window->style->base[2] = cpt_help_bg_color;
   window->style->base[3] = cpt_help_bg_color;
   window->style->base[4] = cpt_help_bg_color;

   scrolled_adj = gtk_adjustment_new(0.0,  /* value */
                                     0.0,  /* lower */
                                     0.0,  /* upper */
                                     0.0,  /* step_increment */
                                     0.0,  /* page_increment */
                                     0.0); /* page_size */
   
   scrolled = gtk_scrolled_window_new (NULL, GTK_ADJUSTMENT(scrolled_adj));
   gtk_container_set_border_width (GTK_CONTAINER (scrolled), 0);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),
                                   GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
   gtk_container_add (GTK_CONTAINER (window), scrolled);
   gtk_widget_show (scrolled);
   
   buffer = gtk_text_buffer_new(NULL);
   gtk_text_buffer_set_text(buffer,helptext,-1);
   text_view = gtk_text_view_new_with_buffer (buffer);
   gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_view), GTK_WRAP_WORD);
   /* the "+24" below was determined experimentally; */
   gtk_widget_set_size_request(text_view,width+24,height);

   gtk_container_add (GTK_CONTAINER (scrolled), text_view);
   gtk_widget_show_all (window);
   state = 1;
   
   return;
   
} /* end of cpt4help() */

