/*
 *  CPT4: Cryptogram Puzzle Tool version 4.1 for X / Linux.
 *
 *  Copyright (c) 2003-2006 by Jeff Edwards
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  -----------
 * 
 *  Rev 4.0.0  17Jun2000  Ported from CPT3 for Windose/C++ using GTK 1.2
 *  Rev 4.1.0  28Sep2003  Updated for GTK/GDK,glib 2.2.2 and Pango 1.2.3,
 *                        which involved major re-writing of monospace text
 *                        procession, but little functionality change.
 *  Rev 4.1.1  05Oct2003  Updated for Glib 2.2.3, and Pango 1.2.5, atk 1.2.4,
 *                        and GTK 2.2.4, include a bit of degugging to get
 *                        static linking working but no functionality changes.
 *  Rev 4.2.0  19Feb2006  Removed low-level Pango stuff and replaced it with
 *                        pre-processed header files containing fixed width
 *                        fonts with only the required characters defined.
 *             14Mar2006  Replace item factory menu scheme
 */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <glib-object.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include "cpt4qmsg.h"

#define HART_DEBUG 0
#define UNDO_DEBUG 0
#define UNCURSE_DEBUG 0

/* Number of times the simulated text cursor toggles on and off per second */
#define CURSOR_RATE 2.0

/*
 *  Our character set: UNKNOWN, MASK, ' ' thru '`' plus '{' thru '~'.
 * 
 *  We define MCHAR, the code for the MASK, to be compatible with previous
 *  editions of CPT.
 */
char  *charset_ink_x;
char  *charset_ink_y;
char  *charset_ink_w;
char  *charset_ink_h;
unsigned char ascii_to_charset_index[256];
int   CSP_WIDTH,CSP_HEIGHT,CSP_4TH_WIDTH;
GdkPixmap *charset_pixmap;
GdkGC *charset_gc;

/*
 *  General monospacing text positioning
 */
#define TEXT_COL_GAP 1
#define TEXT_ROW_GAP 2
#define TEXT_BORDER  1

/*
 *  Puzzle text positioning
 */
#define PZT_ROWS 5
#define PZT_COLS 80
#define PZT_ROW_EXTRA_GAP 2
int PZT_LENGTH;

/*
 *  Letter frequency text positioning
 */
#define FQT_ROWS 6
#define FQT_COL_EXTRA_GAP 3
#define FQT_SEP_EXTRA_GAP 1
int FQT_DA_COUNT;

/*
 *  Lower right button area positioning
 */
#define BUTTON_AREA_MARGIN 5

/*
 *  Defined elsewhere
 */
void cpt4pmsg(GtkWidget **pmsg_window, GtkWidget *parent,
              GdkColor *bg_color, GdkColor *fg_color,
              char *button_title, char *title,  char *msg,
              void (*closed_func) (void)
             );
extern void cpt4help(GtkWidget *appwindow);
extern void cpt4about(GtkWidget *appwindow);

/*
 *  forward function declarations
 */
static gint alphabet_expose_event (GtkWidget *widget,
                                   GdkEventExpose *event,
                                   gpointer *userdata);
void assign (int cipherchar, int plainchar);
void assign_next_free(int index);
void assign_next_not_in_word(int index);
void complete_swap_clicked (GtkWidget *widget, gpointer data);
void compute_cursor(char **pat, char *shape, char *mask);
gboolean main_enter_event (GtkWidget *w, GdkEventCrossing *e, gpointer d);
gboolean cpt4_enter_event (GtkWidget *w, GdkEventCrossing *e, gpointer d);
gboolean cpt4_leave_event (GtkWidget *w, GdkEventCrossing *e, gpointer d);
static void cpt4_load(GtkWidget *w, gpointer data);
static void cpt4_store(GtkWidget *w, gpointer data);
void cpt_draw_text(GdkDrawable *win,    /* destination    */
                   int x,               /* in destination */
                   int y,               /* in destination */
                   int source_section,  /* source section of charset_pixmap */
                   unsigned char *text, /* source string (UNK,MSK,ASCII)    */
                   int count );         /* character count, if > 0          */
void cpt_edit(int key);
void cpt_solve(int key);
void create_file_selection(char *title,
                           void (*ok_func) (GtkWidget *, gpointer));
void do_hart_clicked (GtkWidget *widget, gpointer data);
void draw_alphabet(void);
void draw_frequencies(int index);
void draw_puzzle(void);
void erase_all_clicked (GtkWidget *widget, gpointer data);
void erase_solution_clicked (GtkWidget *widget, gpointer data);
void file_selector_destroyed(GtkWidget *w, gpointer data);
void fill_alphabet_cipher(void);
void get_our_path(char *path, int maxlength);
static gint frequency_expose_event(GtkWidget *widget,
                                   GdkEventExpose *event, gpointer column);
int  frequency_substitution_target(int x, int y);
int  getmsg(int pipe, char *buf, int bufsize);
void calculate_gui_metrics();
void go_edit_clicked (GtkWidget *widget, gpointer data);
void go_solve_clicked (GtkWidget *widget, gpointer data);
void grab_font_data();
void hart_abort(void);
void help_menu_about(GtkWidget *widget, gpointer data);
void help_menu_general(GtkWidget *widget, gpointer data);
void ibg(void);
void main_destroy(GtkWidget *widget, gpointer data);
void maybe_save_xlat(void);
void menu_encrypt (GtkWidget *widget, gpointer data);
gint mouse_button_press_event(GtkWidget *widget, GdkEventButton *e, gpointer data);
gint mouse_button_release_event(GtkWidget *widget, GdkEventButton *e, gpointer data);
void my_cleanup(void);
void next_free_clicked (GtkWidget *widget, gpointer data);
void next_not_in_word_clicked (GtkWidget *widget, gpointer data);
int  nrb(void);
void other_hart_clicked (GtkWidget *widget, gpointer data);
void overwrite_yc_callback(GtkButton *b, gpointer data);
int  pair_index(int x, int y);
gboolean pipe_input_ready(GIOChannel source,
                          GIOCondition condition,
                          gpointer data);
void process_input_file(FILE *file);
void process_input_selection(GtkWidget *selector, gpointer user_data);
void process_output_file(GtkWidget *selector, char *filename);
void process_output_selection(GtkWidget *selector, gpointer data);
void putmsg(int pipe, char *msg);
void putmsg2(int pipe, char *msg, int charcnt);
int  puzzle_alpha_plain_index(int x, int y);
static gint puzzle_expose_event (GtkWidget *widget,
                                 GdkEventExpose *event,
                                 gpointer userdata);
void redo_clicked (GtkWidget *widget, gpointer data);
void save_filesel_path(char *filename_with_path);
void set_dragging_cursor(int c);
void sort1();
void switch_to_edit (void);
void switch_to_solve (void);
gint toggle_cursor(gpointer data);
void undo_clicked (GtkWidget *widget, gpointer data);
void usolu(void);
int  what_alpha(int x, int y);
int  write_word_list(void);

/*
 *  globals
 */
char edit_mode_title[]="CPT Edit Mode: -  Key in puzzle text, then click 'Go To Solve Mode'";
char solve_mode_title[]="CPT Solution Mode: -  Key in or drag plaintext substitutions";
char *user_font_name=NULL;
int charset_ink_width;
int charset_ink_height;

int alphabet_da_width;
int alphabet_da_height;
int alphabet_ink_width;
int alphabet_ink_height;
int puzzle_da_width;
int puzzle_da_height;
int frequency_da_width;
int frequency_da_height;

int edit_mode_charno=0;
int solve_mode_charno=0;
int cursed_index;
int cursed = 0;
int editmode = 1;
int edited = 0;

char ciphertext[PZT_ROWS*PZT_COLS];
char alphabet_cipher[]="CIPHER: **************************";
char alphabet_plain[] =" PLAIN: ABCDEFGHIJKLMNOPQRSTUVWXYZ";

GtkWidget *main_window;
GtkWidget *main_menubar;
GtkWidget *help_menubar;
GtkWidget *encrypt_item;
GtkWidget *erase_puzzle_item;
GtkWidget *hart_solution_item;
GtkWidget *erase_solution_item;
GtkWidget *alphabet_da;
GtkWidget *puzzle_da;
GtkWidget *frequency_da[(25+FQT_ROWS)/FQT_ROWS];
GtkWidget *buttons_area_fixed;
GtkWidget *edit_buttons_vbox;
GtkWidget *solve_buttons_vbox;
GdkColormap *cmap;
GdkColor black_color;
GdkColor puzzle_cipher_color;
GdkColor puzzle_plain_color;
GdkColor puzzle_bg_color;
GdkGC *puzzle_background_gc;
GdkGC *cipher_gc;
GdkGC *plain_gc;
GdkColor cpt_help_bg_color;
GdkColor cpt_emsg_bg_color;
GtkWidget *file_selector;
GtkWidget *file_selector_pmsg;
GtkWidget *hart_active_pmsg;
GdkScreen   *gdkscreen;

/*
 *  Solve mode buttons
 */
GtkWidget *button_other_hart;
GtkWidget *button_undo;
GtkWidget *button_redo;
GtkWidget *button_next_free;
GtkWidget *button_next_not_in_word;
GtkWidget *button_complete_swap;

#define cursor_width 16
#define cursor_height 32
void compute_cursor(char **pat, char *shape, char *mask);

static char cursor_shape[64];
static char cursor_mask[64];

char *C1pat[] ={
/*  00000000001111111 */   
/*  01234567890123456 */   
   "b               ", /* 00 */
   "bb              ", /* 01 */
   "bwb             ", /* 02 */
   "bwwb            ", /* 03 */
   "bwwwb           ", /* 04 */
   "bwwwwb          ", /* 05 */
   "bwwwwwb         ", /* 06 */
   "bwwwwwwb        ", /* 07 */
   "bwwwwwwwb       ", /* 08 */
   "bwwwwwwwwb      ", /* 09 */
   "bwwwwwbbbbb     ", /* 10 */
   "bwwbwwb         ", /* 11 */
   "bwbbbwwb        ", /* 12 */
   "bb  bwwb        ", /* 13 */
   "b    bwwb       ", /* 14 */
   "     bwwb       ", /* 15 */
   "      bwwb      ", /* 16 */
   "       bb       ", /* 17 */
   "                ", /* 18 */
   "                ", /* 19 */
   "                ", /* 20 */
   "                ", /* 21 */
   "                ", /* 22 */
   "                ", /* 23 */
   "                ", /* 24 */
   "                ", /* 25 */
   "                ", /* 26 */
   "                ", /* 27 */
   "                ", /* 28 */
   "                ", /* 29 */
   "                ", /* 30 */
   "                "};/* 31 */
char *C2pat[] ={
/*  00000000001111111 */   
/*  01234567890123456 */   
   "b               ", /* 00 */
   "bb              ", /* 01 */
   "bwb             ", /* 02 */
   "bwwb            ", /* 03 */
   "bwwwb           ", /* 04 */
   "bwwwwb          ", /* 05 */
   "bwwwwwb         ", /* 06 */
   "bwwwwwwb        ", /* 07 */
   "bwwwwwwwb       ", /* 08 */
   "bwwwwwwwwb      ", /* 09 */
   "bwwwwwbbbbb     ", /* 10 */
   "bwwbwwb         ", /* 11 */
   "bwbbbwwb        ", /* 12 */
   "bb  bwwb        ", /* 13 */
   "b    bwwb       ", /* 14 */
   "wbwbwbwwbbwbwbwb", /* 15 */
   "bwbwbwbwwbbwbwbw", /* 16 */
   "wbbbbbbbbbbbbbwb", /* 17 */
   "bwbbbbbbbbbbbbbw", /* 18 */
   "wbbbbbbbbbbbbbwb", /* 19 */
   "bwbbbbbbbbbbbbbw", /* 20 */
   "wbbbbbbbbbbbbbwb", /* 21 */
   "bwbbbbbbbbbbbbbw", /* 22 */
   "wbbbbbbbbbbbbbwb", /* 23 */
   "bwbbbbbbbbbbbbbw", /* 24 */
   "wbbbbbbbbbbbbbwb", /* 25 */
   "bwbbbbbbbbbbbbbw", /* 26 */
   "wbbbbbbbbbbbbbwb", /* 27 */
   "bwbbbbbbbbbbbbbw", /* 28 */
   "wbbbbbbbbbbbbbwb", /* 29 */
   "bwbwbwbwbwbwbwbw", /* 30 */
   "wbwbwbwbwbwbwbwb"};/* 31 */

char *C3pat[] ={
/*  00000000001111111 */   
/*  01234567890123456 */   
   "b               ", /* 00 */
   "bb              ", /* 01 */
   "bwb             ", /* 02 */
   "bwwb            ", /* 03 */
   "bwwwb           ", /* 04 */
   "bwwwwb          ", /* 05 */
   "bwwwwwb         ", /* 06 */
   "bwwwwwwb        ", /* 07 */
   "bwwwwwwwb       ", /* 08 */
   "bwwwwwwwwb      ", /* 09 */
   "bwwwwwbbbbb     ", /* 10 */
   "bwwbwwb         ", /* 11 */
   "bwbbbwwb        ", /* 12 */
   "bb  bwwb        ", /* 13 */
   "b    bwwb       ", /* 14 */
   "wbwbwbwwbbwbwbw ", /* 15 */
   "bwbwbwbwwbbwbwb ", /* 16 */
   "wbbbbbbbbbbbbbw ", /* 17 */
   "bwbbbbbbbbbbbwb ", /* 18 */
   "wbbbbbbbbbbbbbw ", /* 19 */
   "bwbbbbbbbbbbbwb ", /* 20 */
   "wbbbbbbbbbbbbbw ", /* 21 */
   "bwbbbbbbbbbbbwb ", /* 22 */
   "wbbbbbbbbbbbbbw ", /* 23 */
   "bwbbbbbbbbbbbwb ", /* 24 */
   "wbbbbbbbbbbbbbw ", /* 25 */
   "bwbbbbbbbbbbbwb ", /* 26 */
   "wbbbbbbbbbbbbbw ", /* 27 */
   "bwbbbbbbbbbbbwb ", /* 28 */
   "wbbbbbbbbbbbbbw ", /* 29 */
   "bwbwbwbwbwbwbwb ", /* 30 */
   "wbwbwbwbwbwbwbw "};/* 31 */

GdkCursor *cursor1;
GdkCursor *cursor2=NULL;
GdkPixmap *source, *mask;
GdkColor cursor_fg_color = { 0, 65535, 65535, 65535 
}; /* white */
GdkColor cursor_bg_color = { 0, 0, 0, 0 
}; /* black */

#include "fnt7x13b.h"
#include "fnt9x15b.h"
#include "fnt12x24m.h"
cpt4_ff_t *cf;
cpt4_ff_t *tf;

int freecnt;
int freeinx;
int drag_character=0;

/*
 *  Finally, here are the globals for the solution algorithm.
 */
int counts[26];
int order1[26];
int freetab[26];
int redo_solution_count=0;
int undo_solution_count=0;
int undo_solution_first=0;
int hart_in_progress=0;
pid_t do_hart_pid;
GIOChannel *hart_input_channel;

#define FILESEL_PATH_SIZE 128
char filesel_path[FILESEL_PATH_SIZE];

#define UNDO_ARRAY_SIZE 30
unsigned char redo_solution[26];
unsigned char undo_solution[UNDO_ARRAY_SIZE][26];
#define HART_ARRAY_SIZE 10
unsigned char hart_solutions[HART_ARRAY_SIZE][26];
int hart_solution_count=0;
int other_hart_index;
int last_freed=-1;
int last_orphan=-1;
int pipe_set_a[2];
int pipe_set_b[2];
int pipe_watch_id;
int in_pipe;
int out_pipe;
unsigned char xlat[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
unsigned long regA,regB,regC;

/*--------------------------------------------------------
 *  Draw 'count' ciphertext characters in the puzzle area.
 */
void draw_puzzle_chars(int count)
{
   int i;
   int row,col;
   int x,y;
   int k,w;
   char *cp;
   row = edit_mode_charno / PZT_COLS;
   col = edit_mode_charno % PZT_COLS;
   w = count * (charset_ink_width + TEXT_COL_GAP) - TEXT_COL_GAP;
   x = TEXT_BORDER + col * (charset_ink_width + TEXT_COL_GAP);
   y = TEXT_BORDER
     + row * (2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP);

   cp = ciphertext + edit_mode_charno;
   for (i=0;i<count;i++) {
      k = ascii_to_charset_index[(int)*cp++];
      gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                        cipher_gc,
                        (GdkDrawable *)charset_pixmap,
                        k*(charset_ink_width + 1),
                        0,
                        x,
                        y,
                        charset_ink_width+2,
                        charset_ink_height+2);
      x += (charset_ink_width + TEXT_COL_GAP);
   }
   /* cursed = 0; */

} /* end draw_puzzle_chars() */

/*------------------------------------------------------
 *  Draw the cursor on the specified character
 */
void curse()
{
   int c,k,index;
   int row,col;
   int x,y;
   int x_offset,y_offset;

   if (editmode) {
      index = edit_mode_charno;
      c = ciphertext[index];
      x_offset = 2*CSP_4TH_WIDTH;
      y_offset = 0;
   }
   else {
      index = solve_mode_charno;
      c = ciphertext[index];
      if ((c >= 'A') && (c <= 'Z')) c = xlat[c-'A'];
      x_offset = 3*CSP_4TH_WIDTH;
      y_offset = charset_ink_height + TEXT_ROW_GAP;
   }
   
   row = index / PZT_COLS;
   col = index % PZT_COLS;
   x  = TEXT_BORDER + col * (charset_ink_width + TEXT_COL_GAP);
   y  = TEXT_BORDER + row * (2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP);
   y += y_offset;
   
   k = ascii_to_charset_index[c];
   gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                     cipher_gc,
                     (GdkDrawable *)charset_pixmap,
                     k*(charset_ink_width + 1) + x_offset,
                     0,
                     x,
                     y,
                     charset_ink_width+2,
                     charset_ink_height+2);
 
   cursed_index = index;
   
#if (UNCURSE_DEBUG)
   printf("c%03d",index);
#endif

   cursed = 1;

} /* end curse() */
#if (UNCURSE_DEBUG)
void curse2()
{
   int c,k,index;
   int row,col;
   int x,y;
   int x_offset,y_offset;

   if (editmode) {
      index = edit_mode_charno;
      c = ciphertext[index];
      x_offset = 2*CSP_4TH_WIDTH;
      y_offset = 0;
   }
   else {
      index = solve_mode_charno;
      c = ciphertext[index];
      if ((c >= 'A') && (c <= 'Z')) c = xlat[c-'A'];
      x_offset = 3*CSP_4TH_WIDTH;
      y_offset = charset_ink_height + TEXT_ROW_GAP;
   }
   
   row = index / PZT_COLS;
   col = index % PZT_COLS;
   x  = TEXT_BORDER + col * (charset_ink_width + TEXT_COL_GAP);
   y  = TEXT_BORDER + row * (2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP);
   y += y_offset;
   
   k = ascii_to_charset_index[c];
   gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                     cipher_gc,
                     (GdkDrawable *)charset_pixmap,
                     k*(charset_ink_width + 1) + x_offset,
                     0,
                     x,
                     y,
                     charset_ink_width+2,
                     charset_ink_height+2);
 
   cursed_index = index;
   printf("C%03d",index);

 cursed = 1;

} /* end curse2() */
#endif

/*------------------------------------------------------
 *  Un-draw the cursor on the specified character
 */
void un_curse()
{
   int c,k,index;
   int row,col;
   int x,y;
   int x_offset,y_offset;

    if (editmode) {
      index = edit_mode_charno;
      c = ciphertext[index];
      x_offset = 0;
      y_offset = 0;
   }
   else {
      index = solve_mode_charno;
      c = ciphertext[index];
      if ((c >= 'A') && (c <= 'Z')) c = xlat[c-'A'];
      x_offset = 1*CSP_4TH_WIDTH;
      y_offset = charset_ink_height + TEXT_ROW_GAP;
   }
   
   row = index / PZT_COLS;
   col = index % PZT_COLS;
   x  = TEXT_BORDER + col * (charset_ink_width + TEXT_COL_GAP);
   y  = TEXT_BORDER + row * (2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP);
   y += y_offset;
   
   k = ascii_to_charset_index[c];
   gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                     cipher_gc,
                     (GdkDrawable *)charset_pixmap,
                     k*(charset_ink_width + 1) + x_offset,
                     0,
                     x,
                     y,
                     charset_ink_width+2,
                     charset_ink_height+2);
   
#if (UNCURSE_DEBUG)
   printf("u%03d",index);
#endif
   cursed = 0;
   
} /* end un_curse() */
#if (UNCURSE_DEBUG)
void un_curse2()
{
   int c,k,index;
   int row,col;
   int x,y;
   int x_offset,y_offset;

    if (editmode) {
      index = edit_mode_charno;
      c = ciphertext[index];
      x_offset = 0;
      y_offset = 0;
   }
   else {
      index = solve_mode_charno;
      c = ciphertext[index];
      if ((c >= 'A') && (c <= 'Z')) c = xlat[c-'A'];
      x_offset = 1*CSP_4TH_WIDTH;
      y_offset = charset_ink_height + TEXT_ROW_GAP;
   }
   
   row = index / PZT_COLS;
   col = index % PZT_COLS;
   x  = TEXT_BORDER + col * (charset_ink_width + TEXT_COL_GAP);
   y  = TEXT_BORDER + row * (2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP);
   y += y_offset;
   
   k = ascii_to_charset_index[c];
   gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                     cipher_gc,
                     (GdkDrawable *)charset_pixmap,
                     k*(charset_ink_width + 1) + x_offset,
                     0,
                     x,
                     y,
                     charset_ink_width+2,
                     charset_ink_height+2);
   
   printf("U%03d",index);
   cursed = 0;
   
} /* end un_curse2() */
#endif
/*
 *  Position the text cursor; possibly set some buttons active or not.
 */
void poscursor(int index)
{
   int c;
   
#if (UNCURSE_DEBUG)
   if (editmode) printf("p%03d",edit_mode_charno);
   else          printf("p%03d",solve_mode_charno);
#endif
   if (cursed) un_curse();
   if (editmode) edit_mode_charno = index;
   else {
      solve_mode_charno = index;
      c = ciphertext[index];
      if ((c >= 'A') && (c <= 'Z')) {
         gtk_widget_set_sensitive (button_next_free, 1);
         gtk_widget_set_sensitive (button_next_not_in_word, 1);
      }
      else {
         gtk_widget_set_sensitive (button_next_free, 0);
         gtk_widget_set_sensitive (button_next_not_in_word, 0);
      }
   }
#if (UNCURSE_DEBUG)
   printf("P%03d",index);
#endif
   curse();
   
} /* end of poscursor() */                                                      

/*
 *  Called when the main window gets destroyed
 */
void main_destroy( GtkWidget *widget, gpointer data)
{
    my_cleanup();
    gtk_main_quit(); 
}

/*
 *  Keyboard pressed event handler.
 * 
 *  I can't find it in the documentation, but according to the
 *  code (gdkevents.c) event.keyval comes directly from the
 *  Xevent 'keysym' member, and event.state comes directly from
 *  the Xevent 'modifier' member.
 */
gint keypressed_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
   guint key,modifiers;
   GdkEventKey *e;
   e = (GdkEventKey *)event;
   if (e->type == GDK_KEY_PRESS) {
      key = e->keyval;
      modifiers = e->state & GDK_MODIFIER_MASK;
      /*
       *  a) let ^C kill the program as might be expected
       *  b) let ^G kill the program as per the comment in in the
       *            Quit item in the File menu.
       */
      if (modifiers & GDK_CONTROL_MASK) {
         if ((key == XK_c) || (key == XK_C) ||
             (key == XK_q) || (key == XK_Q)   ) {
            my_cleanup();
            gtk_main_quit(); 
            return TRUE;
         }
      }
      else if ((modifiers & (~(GDK_SHIFT_MASK | GDK_LOCK_MASK))) == 0) {
         if (editmode) cpt_edit(key);
         else cpt_solve(key);
         return TRUE;
      }
   }
   return FALSE;
}

/*
 *  Callback for mouse key depressed event.
 * 
 *  See Gtk tutorial sections 2 and 18 for information about events.
 */
gint mouse_button_press_event(GtkWidget *widget, GdkEventButton *e, gpointer data)
{
   int c,i;
   int x,y;

   if (e->type != GDK_BUTTON_PRESS) return FALSE;
   
   x = e->x;
   y = e->y;
   if (e->button != 1) goto other_buttons;
   
   /*
    *  In edit mode, we just set the text cursor position
    */
   if (editmode) {   
      if ((i = pair_index(x,y)) != -1) poscursor(i);
      return TRUE;  /* was FALSE before 9/11/03 */
   }
   
   /*
    *  If the control or shift keys are down, we might
    *  do some substituting in the puzzle.
    */
   if (!(e->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK))) goto drag_check;
   if ((i = puzzle_alpha_plain_index(x,y)) == -1) return FALSE;
   poscursor(i);
   if (e->state & GDK_SHIFT_MASK) assign_next_free(i);
   else                           assign_next_not_in_word(i);
   return TRUE;
   
drag_check:
   c = what_alpha(x,y);
   if (c == -1) return TRUE;
   drag_character = c;
   set_dragging_cursor(c);
   return TRUE;
   
other_buttons:   
   return FALSE;
   
} /* end of mouse_button_press_event() */

/*
 *  Callback for mouse key release event.
 */
gint mouse_button_release_event(GtkWidget *widget, GdkEventButton *e, gpointer data)
{
   int c,i;
   int x,y;
   
   if (e->type != GDK_BUTTON_RELEASE) return FALSE;
   if (editmode) goto event_discarded;
   
   x = e->x;
   y = e->y;
   if (e->button != 1) goto event_discarded;
   if (e->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK)) goto event_discarded;
   
   if ((i = puzzle_alpha_plain_index(x,y)) == -1) goto try_frequency;
   if (drag_character) {
      assign (ciphertext[i], drag_character);
      gdk_window_set_cursor(main_window->window, cursor1);
      drag_character = 0;
   }
   poscursor(i);
   return TRUE;

try_frequency:   
   if ((c = frequency_substitution_target(x, y)) == -1) goto event_discarded;
   if (drag_character) {
      assign (c, drag_character);
      gdk_window_set_cursor(main_window->window, cursor1);
      drag_character = 0;
   }
   return TRUE;
   
event_discarded:
   if (drag_character) {
      gdk_window_set_cursor(main_window->window, cursor1);
      drag_character = 0;
   }
   return FALSE;
   
} /* end of mouse_button_release_event() */

/*
 *  Callback attached to "store" menu item
 */
static void cpt4_store(GtkWidget *w, gpointer data)
{
   create_file_selection("Select output file ...", process_output_selection);
   
} /* end of cpt4_store() */

/*
 *  Callback attached to "load" menu item
 */
static void cpt4_load(GtkWidget *w, gpointer data)
{
   create_file_selection("Select an input file ...", process_input_selection);
   
} /* end of cpt4_load() */

gint toggle_cursor(gpointer data)
{
#if (UNCURSE_DEBUG)
   if (cursed) { un_curse2(); cursed = 0; }
   else        {    curse2(); cursed = 1; }
#else
   if (cursed) { un_curse(); cursed = 0; }
   else        {    curse(); cursed = 1; }
#endif
   return TRUE; /* allows the 'timeout' to continue running */
   
} /* end of toggle_cursor() */

/*
 *  This routine is called when we need to draw the alphabet area because
 *  the window was moved, restored, etc.
 */
static gint alphabet_expose_event (GtkWidget *widget,
                                   GdkEventExpose *event,
                                   gpointer *userdata)
{
   draw_alphabet();
   return TRUE;
   
} /* end of alphabet_expose_event() */

static gint puzzle_expose_event (GtkWidget *widget,
                                 GdkEventExpose *event,
                                 gpointer userdata)
{
   draw_puzzle();
   return TRUE;

} /* end of puzzle_expose_event() */

static gint frequency_expose_event(GtkWidget *widget,
                                   GdkEventExpose *event,
                                   gpointer column)
{
   draw_frequencies(GPOINTER_TO_INT(column));
   return TRUE;
   
} /* end of frequency_expose_event() */

/*
 *  This is the callback routine for the help menu general item.
 */
void help_menu_general(GtkWidget *w, gpointer data)
{
   cpt4help(main_window);
   
} /* end of help_menu_general */

/*
 *  This is the callback routine for the help menu about item.
 */
void help_menu_about(GtkWidget *w, gpointer data)
{
   cpt4about(main_window);
   
} /* end of help_menu_about() */

void file_selector_destroyed(GtkWidget *w, gpointer data)
{
   if (file_selector_pmsg) gtk_widget_destroy(file_selector_pmsg);
   file_selector_pmsg = NULL;
   
} /* end of file_selector_destroyed() */

/*
 *  Called when the input file selector OK button is pressed.
 */
void process_input_selection(GtkWidget *selector, gpointer data)
{
   FILE *file;
   struct stat s;
   const char *filename;
   int n;
   
   filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(selector));
   n = stat(filename,&s);
   if (n == 0) { 
      if (s.st_mode & S_IFREG) {
         file = fopen(filename,"r");
         if (file != NULL) {
            save_filesel_path((char *)filename);
            process_input_file(file);
            gtk_widget_destroy(selector);
            return;
         }
      }
   }
   cpt4pmsg(&file_selector_pmsg,
            selector,
            &cpt_emsg_bg_color,         /* message text bg color */
            &main_window->style->black, /* message test fg color */
            "Dismiss",
            "Input File Error ...",
            "Selection is not\nan accessable file.",
            NULL);
   return;
   
} /* end of process_input_selection() */

/*
 *  Called when the output file selector OK button is pressed.
 */
void process_output_selection(GtkWidget *selector, gpointer data)
{
   struct stat s;
   const char *filename;
   int n;
   
   filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(selector));
   n = stat(filename,&s);
   if (n != 0) goto no_stat; 
   if (s.st_mode & S_IFREG) goto exists;
   
   /*
    *  Here the selected output file presumably does not exist, so we'll
    *  let the next level program open it and write it so it can decide
    *  whether or not to destroy the file selector widget depending on
    *  its success.
    */
no_stat:   
   process_output_file(selector,(char *)filename);
   return;

exists:
   cpt4qmsg(
      &file_selector_pmsg,
      file_selector,
      &cpt_emsg_bg_color,         /* message text bg color */
      &main_window->style->black, /* message test fg color */
      "Overwrite confirmation",
      "Overwrite existing file?",
      "Yes",
      "Cancel",
      overwrite_yc_callback,
      overwrite_yc_callback,
      (gpointer) filename,
      NULL
   );
   
   return;

} /* end of process_output_selection() */

void create_file_selection(char *title,
                           void (*ok_func) (GtkWidget *, gpointer))
{

   /*
    *  Later on, while we're processing the OK button for the dialog,
    *  we'll make 'file_selector_pmsg' point to any error message
    *  dialogs we use, so that when the file selector widget is destroyed
    *  it can destroy the associated error message dialog too.
    */
   file_selector_pmsg = NULL;

   file_selector = gtk_file_selection_new(title);
   gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file_selector));
   if (filesel_path[0] != 0)
      gtk_file_selection_set_filename (GTK_FILE_SELECTION(file_selector),
                                       filesel_path);
   g_signal_connect(GTK_OBJECT(file_selector), "destroy",
                       G_CALLBACK(file_selector_destroyed), NULL);
   /*
    *  The reason for using 'g_signal_connect_swapped()' instead of
    *  simply 'g_signal_connec()' in the following is that we want 
    *  the callback routine to know about its parent window.
    *  Note that connecting this way messes with the signal prototype as
    *  as described in the reference man under button, signals.
    */
   g_signal_connect_swapped(G_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
                       "clicked", G_CALLBACK(ok_func),
                       (gpointer)file_selector);
   
   /* Destroy the dialog if the user clicks the cancel button. */
   g_signal_connect_swapped(G_OBJECT(GTK_FILE_SELECTION(file_selector)->cancel_button),
                            "clicked", G_CALLBACK(gtk_widget_destroy),
                            (gpointer)file_selector);
   /*
    *  The 'gtk_window_set_modal()' call gives the file_selector widget
    *  exclusive use of the mouse and keyboard, WITHIN OUR APPLICATION.
    *  The window manager can still do its stuff ...
    */
   gtk_window_set_modal(GTK_WINDOW(file_selector),1);
   /*
    *  The gtk_set_transient_for() function causes the KDE window manager to:
    *     1) disable iconify, make sticky, and move to desktop items on the
    *        default menu;
    *     2) prevent the parent window from ever overlaying the child window;
    *     3) raise the child window whenever it raises the parent window.
    */
   gtk_window_set_transient_for(GTK_WINDOW(file_selector),
                                GTK_WINDOW(main_window));
   gtk_widget_show(file_selector);
   
} /* end of create_file_selection() */


int main(int argc, char *argv[])
{
  
   GtkWidget *main_vbox;
   GtkWidget *menubar_hbox;
   GtkWidget *alphabet_frame;
   GtkWidget *puzzle_frame;
   GtkWidget *frequency_frame;
   GtkWidget *lower_hbox;
   GtkWidget *frequency_vbox;
   GtkWidget *frequency_hbox;
   GtkWidget *separator;
   GtkWidget *menu;
   GtkWidget *menuitem;
   
   /*
    *  Edit mode buttons
    */
   GtkWidget *hbox_e_1;
   GtkWidget *vbox_e_1;
   GtkWidget *button_goto_solve;
   GtkWidget *fixed_e_h;
   GtkWidget *fixed_e_v;
   
   /*
    *  Solve mode buttons
    */
   GtkWidget *vbox_s_1, *vbox_s_2, *vbox_s_3, *vbox_s_4 , *vbox_s_5;
   GtkWidget *hbox_s_1;
   GtkWidget *button_goto_edit;
   GtkWidget *fixed_s_h;
   GtkWidget *fixed_s_v;
   
   int i,n;
   
   /*
    *  Our monospaced fonts are defined in header files.
    */
   fnt7x13b_font.bitpatterns  = fnt7x13b_data;
   fnt9x15b_font.bitpatterns  = fnt9x15b_data;
   fnt12x24m_font.bitpatterns = fnt12x24m_data;
   
   if (argc == 1) {
      tf=&fnt9x15b_font;
      cf=&fnt9x15b_font;
      goto carry_on;
   }
   if (argc != 2) goto print_usage;
   if (strcmp(argv[1],"-small") == 0) {   
      tf=&fnt7x13b_font;
      cf=&fnt7x13b_font;
      goto carry_on;
   }
   if (strcmp(argv[1],"-large") == 0) {   
      tf=&fnt12x24m_font;
      cf=&fnt9x15b_font;
      goto carry_on;
   }
   
print_usage:   
   g_print("Usage: cpt4 [option]\n");
   g_print("\nOptions:\n");
   g_print(" -small   Use CPT4's default small monospaced font\n");
   g_print(" -large   Use CPT4's default large monospaced font\n");
   exit(1);
   
carry_on:
   gtk_init(&argc, &argv);
   gdkscreen  = gdk_screen_get_default();
  
   /*
    *  The first thing we have to do is kludge up a fixed spacing font. 
    *  For the time being, we'll just load one we know is available on
    *  our development system and works for our purposes.
    */
   if (user_font_name == NULL) user_font_name = "mono 12";
   
   calculate_gui_metrics();

   main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   g_signal_connect(G_OBJECT(main_window), "destroy", 
                      G_CALLBACK(main_destroy), 
                      "WM destroy");
   g_signal_connect(G_OBJECT(main_window), "button_press_event",
                       G_CALLBACK (mouse_button_press_event), NULL);
   g_signal_connect(G_OBJECT(main_window), "button_release_event",
                       G_CALLBACK (mouse_button_release_event), NULL);
   g_signal_connect(G_OBJECT(main_window), "key_press_event",
                        G_CALLBACK (keypressed_event), NULL);
   g_signal_connect(G_OBJECT(main_window), "leave_notify_event",
                        G_CALLBACK(cpt4_leave_event), NULL);
   g_signal_connect(G_OBJECT(main_window), "enter_notify_event",
                        G_CALLBACK(main_enter_event), NULL);
   /*
    *  N.B. According to the Tutorial, gtk_widget_set_events() must be called
    *  _before_ the X window is created.
    */
   gtk_widget_add_events (main_window, GDK_BUTTON_PRESS_MASK
                                     | GDK_BUTTON_RELEASE_MASK
                                     | GDK_LEAVE_NOTIFY_MASK
                                     | GDK_ENTER_NOTIFY_MASK
                                     | GDK_KEY_PRESS_MASK    );

   gtk_window_set_title(GTK_WINDOW(main_window), edit_mode_title);

   gtk_window_set_resizable(GTK_WINDOW(main_window), 0);

   cmap = gdk_colormap_get_system();
   black_color.red       =     0; /*  0 percent */
   black_color.green     =     0; /*  0 percent */
   black_color.blue      =     0; /*  0 percent */
   if (!gdk_colormap_alloc_color(cmap, &puzzle_bg_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'puzzle_bg_color'");
   }
   puzzle_bg_color.red   =     0; /*  0 percent */
   puzzle_bg_color.green =     0; /*  0 percent */
   puzzle_bg_color.blue  = 32768; /* 50 percent */
   if (!gdk_colormap_alloc_color(cmap, &puzzle_bg_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'puzzle_bg_color'");
   }
   puzzle_plain_color.red   = 65535; /* 100 percent */
   puzzle_plain_color.green = 65535; /* 100 percent */
   puzzle_plain_color.blue  = 65535; /* 100 percent */
   if (!gdk_colormap_alloc_color(cmap, &puzzle_plain_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'puzzle_plain_color'");
   }
   puzzle_cipher_color.red   =     0; /*   0 percent */
   puzzle_cipher_color.green = 62259; /*  95 percent */
   puzzle_cipher_color.blue  = 65535; /* 100 percent */
   if (!gdk_colormap_alloc_color(cmap, &puzzle_cipher_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'puzzle_cipher_color'");
   }
   /* A nice golden beige background color for the help window */
   cpt_help_bg_color.red   = 65535; /* 100 percent */
   cpt_help_bg_color.green = 64225; /*  98 percent */
   cpt_help_bg_color.blue  = 58982; /*  90 percent */
   if (!gdk_colormap_alloc_color(cmap, &cpt_help_bg_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'help_bg_color'");
   }
   /* a medium-bright red  color for error message dialogs */
   cpt_emsg_bg_color.red   = 65535;   /* 100 percent */
   cpt_emsg_bg_color.green = 26214;   /*  40 percent */
   cpt_emsg_bg_color.blue  = 26214;   /*  40 percent */
   if (!gdk_colormap_alloc_color(cmap, &cpt_emsg_bg_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'emsg_bg_color'");
   }
   if (!gdk_colormap_alloc_color(cmap, &cursor_bg_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'cursor_bg_color'");
   }
   if (!gdk_colormap_alloc_color(cmap, &cursor_fg_color, FALSE, TRUE)) {
      g_error("couldn't allocate 'cursor_fg_color'");
   }

   gtk_widget_realize(main_window);
   puzzle_background_gc = gdk_gc_new(main_window->window);
   cipher_gc = gdk_gc_new(main_window->window);
   plain_gc  = gdk_gc_new(main_window->window);
   gtk_widget_unrealize(main_window);

   gdk_gc_set_foreground(puzzle_background_gc,&puzzle_bg_color);
   gdk_gc_set_foreground(cipher_gc,&puzzle_cipher_color);
   gdk_gc_set_foreground(plain_gc, &puzzle_plain_color);
   
   main_vbox = gtk_vbox_new(FALSE, 1); /* homogeneous, spacing */
   gtk_container_set_border_width(GTK_CONTAINER(main_vbox), 1);
   gtk_container_add(GTK_CONTAINER(main_window), main_vbox);
   gtk_widget_show(main_vbox);
  
   menubar_hbox = gtk_hbox_new(FALSE, 1);
   gtk_container_set_border_width(GTK_CONTAINER(menubar_hbox), 1);
   gtk_box_pack_start(GTK_BOX(main_vbox), menubar_hbox,
                      FALSE, /* expand  */
                      TRUE,  /* fill    */
                      0);    /* padding */
   gtk_widget_show(menubar_hbox);
  
   /*
    *  Here is how we make the labels for a menubar not have a button
    *  drawn around them in GTK+-2.2.2
    */
   gtk_rc_parse_string ("style \"global-style-properties\" { "
                        "  GtkMenuBar::shadow-type = none\n"
                        "}\n"
                        "class \"GtkWidget\" style \"global-style-properties\"");
   
   /*
    *  Set up the File and Options menus
    */
   main_menubar = gtk_menu_bar_new();
   /*
    *  We use the enter event to cancel any letter drag that might be
    *  in progress, changing the cursor back to a normal pointer.
    */
   gtk_widget_set_events(main_menubar, GDK_ENTER_NOTIFY_MASK);
   g_signal_connect(G_OBJECT(main_menubar), "enter_notify_event",
                    G_CALLBACK(cpt4_enter_event), NULL);
   
 
   /*  First the File menu */
   menu = gtk_menu_new ();
   menuitem = gtk_menu_item_new_with_mnemonic ("_File");
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
   gtk_menu_shell_append (GTK_MENU_SHELL (main_menubar), menuitem);
   gtk_widget_show (menuitem);

   menuitem = gtk_menu_item_new_with_mnemonic ("_Load Puzzle");
   g_signal_connect(G_OBJECT(menuitem), "activate",
                    G_CALLBACK(cpt4_load), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   menuitem = gtk_menu_item_new_with_mnemonic ("_Store Puzzle");
   g_signal_connect(G_OBJECT(menuitem), "activate",
                    G_CALLBACK(cpt4_store), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   menuitem = gtk_separator_menu_item_new();
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   menuitem = gtk_menu_item_new_with_label ("Quit  Ctrl+Q");
/* gtk_menu_item_set_accel_path(GTK_MENU_ITEM (menuitem), "<control>Q"); */
   gtk_menu_item_set_accel_path(GTK_MENU_ITEM (menuitem), NULL);
   g_signal_connect(G_OBJECT(menuitem), "activate",
                    G_CALLBACK(main_destroy), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   

   /*  Next, the Options menu */
   menu = gtk_menu_new ();
   menuitem = gtk_menu_item_new_with_mnemonic ("_Options");
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
   gtk_menu_shell_append (GTK_MENU_SHELL (main_menubar), menuitem);
   gtk_widget_show (menuitem);

   encrypt_item = gtk_menu_item_new_with_label ("Encrypt");
   g_signal_connect(G_OBJECT(encrypt_item), "activate",
                    G_CALLBACK(menu_encrypt), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), encrypt_item);
   gtk_widget_show (encrypt_item);
   erase_puzzle_item = gtk_menu_item_new_with_label ("Erase Puzzle");
   g_signal_connect(G_OBJECT(erase_puzzle_item), "activate",
                    G_CALLBACK(erase_all_clicked), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), erase_puzzle_item);
   gtk_widget_show (erase_puzzle_item);
   menuitem = gtk_separator_menu_item_new ();
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   menuitem = gtk_menu_item_new_with_label ("Hart Solution");
   g_signal_connect(G_OBJECT(menuitem), "activate",
                    G_CALLBACK(do_hart_clicked), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   erase_solution_item = gtk_menu_item_new_with_label ("Erase Solution");
   g_signal_connect(G_OBJECT(erase_solution_item), "activate",
                    G_CALLBACK(erase_solution_clicked), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), erase_solution_item);
   gtk_widget_show (erase_solution_item);
   
   
   gtk_box_pack_start(GTK_BOX(menubar_hbox), main_menubar, FALSE, FALSE, 0);
   
   gtk_widget_show(main_menubar);

   alphabet_frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(alphabet_frame),GTK_SHADOW_IN);

   gtk_box_pack_start(GTK_BOX(menubar_hbox), alphabet_frame, FALSE, FALSE, 0);
   gtk_widget_show(alphabet_frame);

   alphabet_da = gtk_drawing_area_new();                                        
   gtk_widget_set_size_request(alphabet_da,
                               alphabet_da_width,
                               alphabet_da_height);
   gtk_container_add(GTK_CONTAINER(alphabet_frame), alphabet_da);

   g_signal_connect(G_OBJECT(alphabet_da), "expose_event",
                    G_CALLBACK(alphabet_expose_event), NULL);
   gtk_widget_show(alphabet_da);

   /*
    *  Set up the Help menu
    */
   help_menubar = gtk_menu_bar_new();
   
   menu = gtk_menu_new ();
   menuitem = gtk_menu_item_new_with_mnemonic ("_Help");
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
   gtk_menu_shell_append (GTK_MENU_SHELL (help_menubar), menuitem);
   gtk_widget_show (menuitem);

   menuitem = gtk_menu_item_new_with_label ("General Info");
   g_signal_connect(G_OBJECT(menuitem), "activate",
                    G_CALLBACK(help_menu_general), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   menuitem = gtk_menu_item_new_with_label ("About");
   g_signal_connect(G_OBJECT(menuitem), "activate",
                    G_CALLBACK(help_menu_about), NULL);
   gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
   gtk_widget_show (menuitem);
   
   
   
/*   
   make_a_menu(main_window, &help_menu_factory, &help_menubar, help_menu_items,
               sizeof(help_menu_items) / sizeof(help_menu_items[0]));
*/
   /* "gtk_box_pack_end()" puts the help_menubar on the right */
   
   gtk_box_pack_end(GTK_BOX(menubar_hbox), help_menubar, FALSE, FALSE, 0);
   gtk_widget_show(help_menubar);

   puzzle_frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(puzzle_frame),GTK_SHADOW_IN);
   gtk_box_pack_start(GTK_BOX(main_vbox), puzzle_frame, FALSE, FALSE, 0);
   gtk_widget_show(puzzle_frame);
    
   puzzle_da = gtk_drawing_area_new();
   gtk_widget_set_size_request(puzzle_da,puzzle_da_width,puzzle_da_height);

   g_signal_connect (G_OBJECT(puzzle_da), "expose_event",
                     G_CALLBACK(puzzle_expose_event), NULL);
   gtk_container_add (GTK_CONTAINER (puzzle_frame), puzzle_da);
   gtk_widget_show(puzzle_da);

   /*
    *  Set up the widgets for the letter frequency readout.
    */
   lower_hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(lower_hbox), 0);
   gtk_box_pack_start(GTK_BOX(main_vbox), lower_hbox,
                      FALSE, TRUE, 0);
   gtk_widget_show(lower_hbox);
   
   /*
    *  We put the frequency frame in a vbox so that if the buttons
    *  area to the right of the frequency data becomes higher than
    *  the frequency data, the frequency drawing area doesn't get
    *  automatically expanced in the Y direction.
    */
   frequency_vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(frequency_vbox), 0);
   gtk_box_pack_start(GTK_BOX(lower_hbox), frequency_vbox, FALSE, FALSE, 0);
   gtk_widget_show(frequency_vbox);

   frequency_frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(frequency_frame),GTK_SHADOW_IN);
   gtk_box_pack_start(GTK_BOX(frequency_vbox), frequency_frame, FALSE, FALSE, 0);
   gtk_widget_show(frequency_frame);
   
   frequency_hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(frequency_hbox), 0);
   gtk_container_add(GTK_CONTAINER(frequency_frame), frequency_hbox);
   gtk_widget_show(frequency_hbox);

   for (i=0;i<FQT_DA_COUNT;i++) {   
      frequency_da[i] = gtk_drawing_area_new();
      gtk_widget_set_size_request(frequency_da[i],
                                  frequency_da_width, frequency_da_height);
      gtk_box_pack_start(GTK_BOX(frequency_hbox), frequency_da[i],
                      FALSE, TRUE, 0);
      gtk_widget_show(frequency_da[i]);
      g_signal_connect (G_OBJECT(frequency_da[i]),
                        "expose_event",
                        G_CALLBACK(frequency_expose_event),
                        GINT_TO_POINTER(i));
      if (i == (FQT_DA_COUNT - 1)) continue;
      separator = gtk_vseparator_new();
      gtk_box_pack_start(GTK_BOX(frequency_hbox), separator,
                      FALSE, TRUE, 0);
      gtk_widget_show(separator);
   }
   buttons_area_fixed = gtk_fixed_new();
   gtk_fixed_set_has_window (GTK_FIXED (buttons_area_fixed), 1);
   g_signal_connect(G_OBJECT(buttons_area_fixed), "enter_notify_event",
                    G_CALLBACK(cpt4_enter_event), NULL);
   /*
    *  The following is for an oddity that I just stumbled upon:
    *  a 'fixed' widget apparently gets 'realized' at creation,
    *  but it only works to set events when it is 'unrealized'.
    */
/* gtk_widget_unrealize(buttons_area_fixed); */
   gtk_widget_add_events(buttons_area_fixed, GDK_ENTER_NOTIFY_MASK);
   gtk_box_pack_start(GTK_BOX(lower_hbox), buttons_area_fixed, FALSE, FALSE, 0);
   gtk_widget_show(buttons_area_fixed);
   
   edit_buttons_vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(edit_buttons_vbox), 0);
   gtk_fixed_put((GtkFixed *)buttons_area_fixed, edit_buttons_vbox, 0, 0);
   /* we'll show this one later */
   
   hbox_e_1 = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(hbox_e_1), BUTTON_AREA_MARGIN); /* gtk2 */
   gtk_box_pack_start(GTK_BOX(edit_buttons_vbox), hbox_e_1,
                        TRUE, FALSE, 0);
   gtk_widget_show(hbox_e_1);
   
   /* this widget sets the width of the edit buttons area */ 
   fixed_e_h = gtk_fixed_new();
   gtk_box_pack_end(GTK_BOX(edit_buttons_vbox), fixed_e_h, FALSE, FALSE, 0);
   gtk_widget_show(fixed_e_h);
   
   /* this widget sets the height of the edit buttons area. */
   fixed_e_v = gtk_fixed_new();
   gtk_box_pack_start(GTK_BOX(hbox_e_1), fixed_e_v, FALSE, FALSE, 0);
   gtk_widget_show(fixed_e_v);
   
   /* this one is for vertical centering of the right button */
   vbox_e_1 = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(vbox_e_1), 0);
   gtk_box_pack_end(GTK_BOX(hbox_e_1), vbox_e_1, FALSE, FALSE, 0);
   gtk_widget_show(vbox_e_1);

   button_goto_solve = gtk_button_new_with_label("Go To\nSolve Mode");
   GTK_WIDGET_UNSET_FLAGS (button_goto_solve, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_goto_solve),"clicked",
                    G_CALLBACK (go_solve_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_e_1), button_goto_solve, TRUE, FALSE, 0);
   gtk_widget_show(button_goto_solve);
   
   solve_buttons_vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(solve_buttons_vbox), 0);
   gtk_fixed_put((GtkFixed *)buttons_area_fixed, solve_buttons_vbox, 0, 0);
   /* we'll show this one later */
   
   hbox_s_1 = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(hbox_s_1), BUTTON_AREA_MARGIN);
   gtk_box_pack_start(GTK_BOX(solve_buttons_vbox), hbox_s_1,
                      FALSE, FALSE, 0);
   gtk_widget_show(hbox_s_1);
   
   /* this widget sets the width of the solve buttons area */
   fixed_s_h = gtk_fixed_new();
   gtk_box_pack_end(GTK_BOX(solve_buttons_vbox), fixed_s_h, FALSE, FALSE, 0);
   gtk_widget_show(fixed_s_h);
   
   /* this widget sets the height of the solve buttons area. */
   fixed_s_v = gtk_fixed_new();
   gtk_box_pack_start(GTK_BOX(hbox_s_1), fixed_s_v, FALSE, FALSE, 0);
   gtk_widget_show(fixed_s_v);
   
   /* this one is for vertical centering of the left buttons */
   vbox_s_1 = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(vbox_s_1), 0);
   gtk_box_pack_start(GTK_BOX(hbox_s_1), vbox_s_1, FALSE, FALSE, 0);
   gtk_widget_show(vbox_s_1);
    
   /* this one is to group the left buttons, so they'll center as a unit */
   vbox_s_2 = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(vbox_s_2), 0);
   gtk_box_pack_start(GTK_BOX(vbox_s_1), vbox_s_2, TRUE, FALSE, 0);
   gtk_widget_show(vbox_s_2);
   
   button_undo = gtk_button_new_with_label("UnDo");
   gtk_widget_set_sensitive (button_undo, 1);
   GTK_WIDGET_UNSET_FLAGS (button_undo, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_undo),"clicked",
                    G_CALLBACK(undo_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_2), button_undo, FALSE, FALSE, 0);
   gtk_widget_show(button_undo);
   
   button_redo = gtk_button_new_with_label("ReDo");
   gtk_widget_set_sensitive (button_redo, 1);
   GTK_WIDGET_UNSET_FLAGS (button_redo, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_redo),"clicked",
                    G_CALLBACK (redo_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_2), button_redo, FALSE, FALSE, 0);
   gtk_widget_show(button_redo);

   button_other_hart = gtk_button_new_with_label("Other Hart");
   gtk_widget_set_sensitive (button_other_hart, 0);
   GTK_WIDGET_UNSET_FLAGS (button_other_hart, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_other_hart),"clicked",
                    G_CALLBACK(other_hart_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_2), button_other_hart, FALSE, FALSE, 0);
   gtk_widget_show(button_other_hart);
   
   /* this one is for vertical centering of the middle buttons */
   vbox_s_3 = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(vbox_s_3), 0);
   gtk_box_pack_start(GTK_BOX(hbox_s_1), vbox_s_3, FALSE, FALSE, 0);
   gtk_widget_show(vbox_s_3);
    
   /* this one is to group the middle buttons, so they'll center as a unit */
   vbox_s_4 = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(vbox_s_4), 0);
   gtk_box_pack_start(GTK_BOX(vbox_s_3), vbox_s_4, TRUE, FALSE, 0);
   gtk_widget_show(vbox_s_4);
   
   button_next_free = gtk_button_new_with_label("Next Free Letter");
   gtk_widget_set_sensitive (button_next_free, 1);
   GTK_WIDGET_UNSET_FLAGS (button_next_free, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_next_free),"clicked",
                    G_CALLBACK (next_free_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_4), button_next_free, FALSE, FALSE, 0);
   gtk_widget_show(button_next_free);
   
   button_next_not_in_word = gtk_button_new_with_label("Next Not In Word");
   gtk_widget_set_sensitive (button_next_not_in_word, 1);
   GTK_WIDGET_UNSET_FLAGS (button_next_not_in_word, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_next_not_in_word),"clicked",
                    G_CALLBACK(next_not_in_word_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_4), button_next_not_in_word, FALSE, FALSE, 0);
   gtk_widget_show(button_next_not_in_word);

   button_complete_swap = gtk_button_new_with_label("Compete Swap");
   gtk_widget_set_sensitive (button_complete_swap, 1);
   GTK_WIDGET_UNSET_FLAGS (button_complete_swap, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_complete_swap),"clicked",
                    G_CALLBACK (complete_swap_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_4), button_complete_swap, FALSE, FALSE, 0);
   gtk_widget_show(button_complete_swap);
   
   /* this one is for vertical centering of the right button */
   vbox_s_5 = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(vbox_s_5), 0);
   gtk_box_pack_end(GTK_BOX(hbox_s_1), vbox_s_5, FALSE, FALSE, 0);
   gtk_widget_show(vbox_s_5);

   button_goto_edit = gtk_button_new_with_label("Go To\nEdit Mode");
   GTK_WIDGET_UNSET_FLAGS (button_goto_edit, GTK_CAN_FOCUS);
   g_signal_connect(G_OBJECT(button_goto_edit),"clicked",
                    G_CALLBACK (go_edit_clicked),NULL);
   gtk_box_pack_start(GTK_BOX (vbox_s_5), button_goto_edit, TRUE, FALSE, 0);
   gtk_widget_show(button_goto_edit);

   /*
    *  Supply initial values for the puzzle text and solution.
    */
   memset(ciphertext,' ',PZT_LENGTH);
   memset(xlat,MCHAR_PSEUDO_ASCII,26);
   
   gtk_widget_show(main_window);

   /*
    *  Special cursor logic
    */
   compute_cursor(C1pat, cursor_shape, cursor_mask);
   source = gdk_bitmap_create_from_data (NULL, cursor_shape,
                                         cursor_width, cursor_height);
   mask = gdk_bitmap_create_from_data (NULL, cursor_mask,
                                      cursor_width, cursor_height);
   cursor1 = gdk_cursor_new_from_pixmap (source, mask,
                                         &cursor_fg_color,
                                         &cursor_bg_color,
                                         1,  /* x coordinate of hotspot */
                                         2); /* y coordinate of hotspot */
   
   g_object_unref((gpointer)source);
   g_object_unref((gpointer)mask);
   gdk_window_set_cursor(main_window->window, cursor1);
   
   /*
    *  Center the alphabet frame.
    */
   gtk_widget_set_size_request(main_menubar,
                               (puzzle_da_width-alphabet_frame->allocation.width)/2,
                               -1); /* -1 => not specified */
   /*
    *  Set the width of the edit and solve button areas
    */
   n = puzzle_frame->allocation.width - frequency_frame->allocation.width;
   gtk_widget_set_size_request(fixed_e_h, n, -1);
   gtk_widget_set_size_request(fixed_s_h, n, -1);
   
   /*
    *  Set the height of the edit and solve button areas
    */
   n = frequency_frame->allocation.height -2*BUTTON_AREA_MARGIN;
   gtk_widget_set_size_request(fixed_e_v, -1, n);
   gtk_widget_set_size_request(fixed_s_v, -1, n);
   
   /*
    *  We start with the edit buttons visible; we see the solve buttons
    *  when we switch to solve mode.
    */
   gtk_widget_show(edit_buttons_vbox);

   /*
    *  Get the bit patterns of the font that we used for the alphabet
    *  area so we can build special cursors later.
    */
   grab_font_data();

   /*
    *  Set up the pseudo cursor polling rate timer
    */
   gtk_timeout_add((int)(500.0 / CURSOR_RATE + 0.5), toggle_cursor, NULL);

   /*
    *  Gray-out menu items we want to be inactive now
    */
   /* gtk_widget_set_sensitive (erase_solution_item,0); */

   /*
    *  Here is the main loop
    */
   gtk_main();
   
   return (0);
   
}  /* end of main() */

/**************************************************************
|  Enter new ciphered text
**************************************************************/
void cpt_edit(int key)
{
   
   int i,j,k,m,n;
   
   i = key;
   if (i >= 'a' && i <= 'z') i += 'A'-'a';
   if ((i >= ' ') && (i <= '~')) goto new_character;
   if (i == XK_Return   ) goto enter;
   if (i == XK_BackSpace) goto backspace;
   if (i == XK_Left     ) goto leftkey;
   if (i == XK_Right    ) goto rightkey;
   if (i == XK_Up       ) goto uparrow;
   if (i == XK_Down     ) goto downarrow;
   if (i == XK_Delete   ) goto delete_char;
   if (i == XK_Insert   ) goto insert;
   if (i == XK_Home     ) goto home;
   if (i == XK_End      ) goto end;
   goto just_return;
   
new_character:
   ciphertext[edit_mode_charno] = i;
   cursed = 0; /* draw_puzzle_chars() will undraw the cursor */
   draw_puzzle_chars(1); 
   if ((edit_mode_charno%PZT_COLS)<(PZT_COLS-1)) edit_mode_charno++;
   edited = 1;
   goto position_cur;

uparrow:
   if (edit_mode_charno > (PZT_COLS-1)) {
      if (cursed) un_curse();
      edit_mode_charno -= PZT_COLS;
   }
   goto position_cur;

downarrow:
   if (edit_mode_charno < PZT_COLS*(PZT_ROWS-1)) {
      if (cursed) un_curse();
      edit_mode_charno += PZT_COLS;
   }
   goto position_cur;

leftkey:
   if (edit_mode_charno%PZT_COLS) {
      if (cursed) un_curse();
      edit_mode_charno--;
   }
   goto position_cur;

rightkey:
   if (edit_mode_charno%PZT_COLS < (PZT_COLS-1)) {
      if (cursed) un_curse();
      edit_mode_charno++;
   }
   goto position_cur;

enter:
   m = edit_mode_charno/PZT_COLS;
   if (m == (PZT_ROWS-1)) goto just_return;
   if (cursed) un_curse();
   m = PZT_COLS*m;
   n = PZT_COLS+m;
   for (i=m;i<n;i++) if (ciphertext[i] != ' ') break;
   if (i == n)
      edit_mode_charno = n;
   else
      edit_mode_charno = i+PZT_COLS;
   goto position_cur;

insert:
   cursed = 0; /* draw_puzzle_chars() will undraw the cursor */
   m = edit_mode_charno%PZT_COLS;
   n = edit_mode_charno/PZT_COLS;
   k = PZT_COLS*n+(PZT_COLS-2);
   for (j=k;j>=edit_mode_charno;j--) ciphertext[j+1] = ciphertext[j];
   ciphertext[edit_mode_charno] = ' ';
   draw_puzzle_chars(PZT_COLS-m); /* redraw to end-of-line */
   edited = 1;
   goto position_cur;

delete_char:
   if (cursed) un_curse();
delete_char2:
   m = edit_mode_charno%PZT_COLS;
   n = edit_mode_charno/PZT_COLS;
   k = PZT_COLS*n+(PZT_COLS-1);
   for (j=edit_mode_charno;j<k;j++) ciphertext[j] = ciphertext[j+1];
   ciphertext[k] = ' ';
   draw_puzzle_chars(PZT_COLS-m);
   edited = 1;
   goto position_cur;

backspace:
   if (edit_mode_charno%PZT_COLS) {
      if (cursed) un_curse();
      edit_mode_charno--;
      goto delete_char2;
   }
   goto just_return;

home:
   if (cursed) un_curse();
   m = edit_mode_charno/PZT_COLS;
   edit_mode_charno = m * PZT_COLS;
   goto position_cur;

end:
   if (cursed) un_curse();
   m = edit_mode_charno/PZT_COLS;
   edit_mode_charno = (m + 1)*PZT_COLS - 1;
   goto position_cur;

position_cur:
   poscursor(edit_mode_charno);
   
just_return:
   return;
   
}  /* end of cpt_edit() */


/*
 *  We attempt to do the right thing before exiting ...
 */
void my_cleanup(void)
{
   if (hart_in_progress) hart_abort();
   return;
   
} /* end of my_cleanup() */

/*
 *  Compute the character arrays used to build the bitmaps used to 
 *  create the custom cursors.
 */
void compute_cursor(char **pat, char *shape, char *mask)
{
   int c,i,j,m;
   char *cp0,*cp1,*cp2;
   
   memset(shape,0,64);
   memset(mask ,0,64);
   
   m = 0x01;
   
   cp1 = shape;
   cp2 = mask;
   for (i=0;i<32;i++) {
      cp0 = *(pat+i);
      for (j=0;j<16;j++) {
         c = *cp0++;
         switch (c)
         {
         case 'w':
            *cp1 = *cp1 | m;
            *cp2 = *cp2 | m;
            break;
         case 'b':
            *cp2 = *cp2 | m;
            break;
         case 'r':
            /* evidently X does not support this case */
            break;
         }
         m <<= 1;
         if (m > 0x80) {
            m = 0x01;
            cp1++;
            cp2++;
         }
      }
   }
} /* end of compute_cursor() */

/*
 *  Build the "charset pixmap", which will be used to draw characters
 *  in various combinations of foreground and background colors by 
 *  copying the appropriate rectangle a window.
 */
void grab_font_data()
{
   int  i,j;
   int  x,y,x0,y0,x1,y1;
   int  depth;
   int  databyte=0;
   int  mask;
   unsigned char *dbp;
   static int first_pass=1;
   static GdkColor *bg_color[4]={
      &puzzle_bg_color,     /* normal ciphertext */
      &puzzle_bg_color,     /* normal plaintext  */
      &puzzle_cipher_color, /* cursed ciphertext */
      &puzzle_plain_color   /* cursed plaintext  */
   };
   static GdkColor *fg_color[4]={
      &puzzle_cipher_color, /* normal ciphertext */
      &puzzle_plain_color,  /* normal plaintext  */
      &puzzle_bg_color,     /* cursed ciphertext */
      &black_color          /* cursed plaintext  */
   };
   
   if (!first_pass) return;
   first_pass = 0;

   gdk_window_get_geometry(main_window->window,NULL,NULL,NULL,NULL,&depth);
   
   /*
    *  Now we create our big pixmap
    */
   CSP_HEIGHT = charset_ink_height + 2;
   CSP_4TH_WIDTH = CHARSET_CNT*(charset_ink_width + 1) + 1;
   CSP_WIDTH = 4 * CSP_4TH_WIDTH;
   charset_pixmap = gdk_pixmap_new(NULL, CSP_WIDTH, CSP_HEIGHT, depth);
   charset_gc = gdk_gc_new(charset_pixmap);

   /*
    *  The outer loop is for the four sections of the charset pixmap.
    *  All sections will contain  all the charset characters, and each
    *  section have its own foreground and background colors.
    */
   y0 = 1;
   y1 = y0 + charset_ink_height;
   for (i=0;i<4;i++) {
      x0 = i * CSP_4TH_WIDTH;
      /*
       *  Set the background color for the current 1/4
       *  of the charset pixmap.
       */
      gdk_gc_set_foreground(charset_gc, bg_color[i]);
      gdk_draw_rectangle(charset_pixmap, charset_gc, TRUE,
                         x0, 0, CSP_4TH_WIDTH, CSP_HEIGHT);

      /*
       *  Draw the character set on the on the current 1/4 
       *  of the charset_pixmap in the corresponding fg color.
       *  In this edition, we draw all the characters in the charset
       *  directy into the charset pixmap, bit-by-bit.
       */
      x0++;
      x1 = x0 + charset_ink_width;
      dbp = tf->bitpatterns;
      gdk_gc_set_foreground(charset_gc, fg_color[i]);
      for (j=0;j<CHARSET_CNT;j++) {
         /*
          *  The "cursed" mask character looks better as just a block
          *  of the foreground color with no bitpattern drawn.
          */
         if ((i == 3) && (j == MSK_CHARSET_INDEX)) {
            dbp += charset_ink_height * ((charset_ink_width + 7)/8);
            x0 += (charset_ink_width + 1);
            x1 = x0 + charset_ink_width;
            continue;
         }
         for (y=y0;y<y1;y++) {
            mask = 0;
            for (x=x0;x<x1;x++) {
               if (mask == 0) {
                  databyte = *dbp++;
                  mask = 0x80;
               }
               if (databyte & mask) {
                  gdk_draw_point((GdkDrawable *)charset_pixmap,
                                  charset_gc, x, y);
               }
               mask >>= 1;
            }
         }
         x0 += (charset_ink_width + 1);
         x1 = x0 + charset_ink_width;
      }
   }
      
} /* end of grab_font_data() */

/*
 *  Superimpose the image of the specified character in the pre-canned
 *  box attached to the drag-and-drop cursor.
 */
void set_dragging_cursor(int c)
{
   int h,w,i,j,n;
   int maski,masko;
   char **pat;
   unsigned char *cpi,*cpo;
   
   /* if (alphabet_data == NULL) return; */
   if ((c < 'A') || (c > 'Z')) return;
   /* if ((alphabet_ink_width > 8) || (alphabet_ink_height > 11)) return; */

   /*
    *  In gtk-1.2, we used gdk_cursor_destroy() in the following.
    */
   if (cursor2 != NULL) gdk_cursor_unref(cursor2);
   
   n = 3 + (c - '!');
/* h = *(charset_ink_h + n); */
/* w = *(charset_ink_w + n); */
   h = 10;
   w = 8;
   
   /*
    *  The following is to insure that the spacing between the specified
    *  character and the box the same on left and right sides.
    */
   if ((w & 1) == 0) pat = C2pat;
   else              pat = C3pat;
   
   compute_cursor(pat, cursor_shape, cursor_mask);

   cpi = cf->bitpatterns + (c - ' ' + 2)
                         * ((cf->cs_ink_width + 7)/8)
                         *  cf->cs_ink_height + 1;
   cpo = (unsigned char *)cursor_shape + 2*(17+(13-h)/2);
   for (i=0;i<h;i++) {
      n = *cpi++;
      maski = 0x80;
      masko = 1 << ((16-w)/2);
      for (j=0;j<8;j++) {
         if (n & maski) *cpo |= masko;
         maski >>= 1;
         masko <<= 1;
         if (masko > 0x80) {
            masko = 1;
            cpo++;
         }
      }
      cpo++;
   }
   source = gdk_bitmap_create_from_data (NULL, cursor_shape,
                                         cursor_width, cursor_height);
   mask = gdk_bitmap_create_from_data (NULL, cursor_mask,
                                      cursor_width, cursor_height);
   cursor2 = gdk_cursor_new_from_pixmap (source, mask,
                                         &cursor_fg_color,
                                         &cursor_bg_color,
                                         1,  /* x coordinate of hotspot */
                                         2); /* y coordinate of hotspot */
   
   g_object_unref((gpointer)source);
   g_object_unref((gpointer)mask);
   gdk_window_set_cursor(main_window->window, cursor2);

} /* end of set_dragging_cursor() */

/*
 *  Calculate the GUI metrics.
 * 
 *  In this edition of CPT, we use a pre-processed fixed width, bitmapped
 *  font that is encoded in a header file; the idea is to circumvent
 *  all the low-level messiness of pango, since we use NONE of the
 *  high level capabilities of pango anyway.
 */
void calculate_gui_metrics()
{
   int c,i;
     
   PZT_LENGTH = PZT_ROWS * PZT_COLS;
   
   /* 
    *  Build a table to translate from an ASCII code to
    *  the position of the character in our character set.
    *  Control characters and characters with the others
    *  we're not using translate to our UNKNOWN character.
    */
   
   memset(ascii_to_charset_index,UNK_CHARSET_INDEX,256);
   ascii_to_charset_index[MCHAR_PSEUDO_ASCII] = MSK_CHARSET_INDEX;
   i = 2;
   for (c=' ';c<='`';c++) ascii_to_charset_index[c] = i++;
   for (c='{';c<='~';c++) ascii_to_charset_index[c] = i++;
   
   alphabet_ink_width = tf->ab_ink_width;
   alphabet_ink_height = tf->ab_ink_height;
   
   charset_ink_width  = tf->cs_ink_width;
   charset_ink_height = tf->cs_ink_height;
   
   alphabet_da_height = TEXT_BORDER
                      + charset_ink_height
                      + TEXT_ROW_GAP
                      + charset_ink_height
                      + TEXT_BORDER;
   
   i = strlen(alphabet_cipher);
   alphabet_da_width  = TEXT_BORDER
                      + i * (charset_ink_width + TEXT_COL_GAP)
                      - TEXT_COL_GAP
                      + TEXT_BORDER;
   
   puzzle_da_height = 2*PZT_ROWS*(charset_ink_height + TEXT_ROW_GAP)
                    - TEXT_ROW_GAP
                    + PZT_ROW_EXTRA_GAP * (PZT_ROWS - 1)
                    + 2*TEXT_BORDER;
   puzzle_da_width  = PZT_COLS * charset_ink_width
                    + (PZT_COLS - 1) * TEXT_COL_GAP 
                    + 2*TEXT_BORDER;
   /*
    *  The frequency data drawing areas are vertical columns.
    */
   FQT_DA_COUNT = (25+FQT_ROWS)/FQT_ROWS;
   frequency_da_width  = 2*TEXT_BORDER
                       + 5*(charset_ink_width + TEXT_COL_GAP)
                       - TEXT_COL_GAP
                       + 2*FQT_COL_EXTRA_GAP;
   frequency_da_height = 2*TEXT_BORDER
                       + FQT_ROWS * (charset_ink_height + TEXT_ROW_GAP)
                       - TEXT_ROW_GAP;
   
} /* end of get_font_metrics() */

/*
 *  Process the input file, which is already open.
 */
void process_input_file(FILE *file)
{
   unsigned char inbuff[256];
   int c,i,j,k;

   memset(ciphertext,' ',PZT_LENGTH);
   for (i=0;i<PZT_ROWS;i++) {
      if (fgets(inbuff,255,file) == NULL) break;
      k = PZT_COLS*i;
      for (j=0;j<PZT_COLS;j++) {
         c = inbuff[j];
         if (c > '~') continue;
         if (c < ' ') break;
         ciphertext[k++] = toupper(c);
      }
   }

   /*
    *  See if there is a solution vector in the file
    */
   if (fgets(inbuff,255,file) == NULL) goto no_solution;
   if (memcmp(inbuff,"!!CPT/ECSI!!",12)) goto no_solution;
   if (fgets(inbuff,255,file) == NULL) goto no_solution;
   maybe_save_xlat();
   memcpy(redo_solution,xlat,26);       /* temporarily save old xlat[] */
   for (i=0;i<26;i++) {
      c = inbuff[i];
      if ((c < ' ') || ((c > '~') && (c != MCHAR_PSEUDO_ASCII))) {
         memcpy(xlat,redo_solution,26); /* restore old xlat[] */
         goto no_solution;
      }
      if ((c < 'A') || (c > 'Z')) c = MCHAR_PSEUDO_ASCII;
      xlat[i] = c;
   }
   goto common;
   
no_solution:
   maybe_save_xlat();
   memset(xlat,MCHAR_PSEUDO_ASCII,26);

common:
   /*
    * Set the cursor position
    */
   for (i=0;i<PZT_LENGTH;i++) {
      c = ciphertext[i];
      if ((c >= 'A') && (c <= 'Z')) break;
   }
   if (i == PZT_LENGTH) i = 0;
   edit_mode_charno = solve_mode_charno = i;
   
   fclose(file);
   switch_to_solve();
   return;
   
}  /* end of process_input_file() */

void draw_puzzle(void)
{
   int c,i,j,k,x,x0,y0;
   int ix0;
   int dx;
   char tmpbuff[PZT_COLS];

   /*
    * 'dx' is the offset between the cipher-on-bkg and plain-on-bkg
    *  sections of the charset_pixmap.
    */
   dx = CHARSET_CNT*(charset_ink_width + 1) + 1;
   
   gdk_draw_rectangle(puzzle_da->window,
                      puzzle_background_gc,TRUE, /* filled */
                      0,0,puzzle_da_width,puzzle_da_height);
   
   x0 = TEXT_BORDER;
   y0 = TEXT_BORDER;
   ix0 = 0;
   for (i=0;i<PZT_ROWS;i++) {
      x = x0;
      for (j=0;j<PZT_COLS;j++) {
         k = ascii_to_charset_index[(int)ciphertext[ix0+j]];
         gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                           cipher_gc,
                           (GdkDrawable *)charset_pixmap,
                           k*(charset_ink_width + 1),
                           0,
                           x,
                           y0,
                           charset_ink_width+2,
                           charset_ink_height+2);
         x += (charset_ink_width + TEXT_COL_GAP);
      }
      y0 += (charset_ink_height + TEXT_ROW_GAP);
    
      if (!editmode) {
         memcpy(tmpbuff,ciphertext+ix0,PZT_COLS);
         for (k=0;k<PZT_COLS;k++) {
            c = tmpbuff[k];
            if ((c >= 'A') && (c <= 'Z')) tmpbuff[k] = xlat[c-'A'];
         }
         x = x0;
         for (j=0;j<PZT_COLS;j++) {
            k = ascii_to_charset_index[(int)tmpbuff[j]];
            gdk_draw_drawable((GdkDrawable *)puzzle_da->window,
                              cipher_gc,
                              (GdkDrawable *)charset_pixmap,
                              dx + k*(charset_ink_width + 1),
                              0,
                              x,
                              y0,
                              charset_ink_width+2,
                              charset_ink_height+2);
            x += (charset_ink_width + TEXT_COL_GAP);
         }
      }
      y0 += (charset_ink_height + TEXT_ROW_GAP);
      y0 += PZT_ROW_EXTRA_GAP;
      ix0 += PZT_COLS;
   }
   curse();

} /* end of draw_puzzle */

void draw_frequencies(int index)
{
   int  i,j,k,n,x,y;
   int  x0;
   char cipher,plain;
   char count[4];
   GdkDrawable *win;
     
   win = frequency_da[index]->window;
   gdk_draw_rectangle(win, puzzle_background_gc, TRUE, 0, 0,
                      frequency_da_width, frequency_da_height);

   x0 = TEXT_BORDER - 1;
   y  = TEXT_BORDER - 1;
   /* 
    *  The following extra gap is used because some editions of GTK
    *  a character drawn just to the right of a separator widget appears
    *  visually one pixel closer to the separator than a character drawn
    *  just to the right of a frame widget appears visually.
    */
   if (index > 0) x0 += FQT_SEP_EXTRA_GAP;
   
   if (editmode) {
      cipher = 'A' + FQT_ROWS * index;
      plain = MCHAR_PSEUDO_ASCII;
      for (i=0;i<FQT_ROWS;i++) {
         x = x0;
         cpt_draw_text(win, x, y, 0, &cipher, 1);
         x += (charset_ink_width + TEXT_COL_GAP + FQT_COL_EXTRA_GAP);
         cpt_draw_text(win, x, y, 1, &plain,  1);
         x += (charset_ink_width + TEXT_COL_GAP + FQT_COL_EXTRA_GAP);
         cpt_draw_text(win, x, y, 0, "###", 3);
         y += (charset_ink_height + TEXT_ROW_GAP);
         cipher++;
         if (cipher > 'Z') break;
      }
   }
   else {
      j = FQT_ROWS * index;
      for (i=0;i<FQT_ROWS;i++) {
         k = order1[j];
         cipher = 'A' + k;
         x = x0;
         cpt_draw_text(win, x, y, 0, &cipher, 1);
         x += (charset_ink_width + TEXT_COL_GAP + FQT_COL_EXTRA_GAP);
         n = counts[k];
         if (n > 0) plain = xlat[k];
         else plain = MCHAR_PSEUDO_ASCII;
         cpt_draw_text(win, x, y, 1, &plain, 1);
         if (n > 999) n = 999;
         sprintf(count,"%03d",n); 
         x += (charset_ink_width + TEXT_COL_GAP + FQT_COL_EXTRA_GAP);
         cpt_draw_text(win, x, y, 0, count, 3);
         y += (charset_ink_height + TEXT_ROW_GAP);
         j++;
         if (j > 25) break;
      }
   }
   
} /* end of draw_frequencies() */

/*
 *  Count frequencies of occurance and sort into descending order
 */
void sort1()
{
   int    i,j,k,n1,n2;
   int    ix1,ix2,cnt1,cnt2;

   /*
    *  This is the counting part ...
    */
   for (i=0;i<26;i++) counts[i] = 0;
   for (i=0;i<PZT_LENGTH;i++) {
      k=ciphertext[i];
      if (k >= 'a' && k <= 'z') {
         k += 'A'-'a';
         ciphertext[i] = k;
      }
      if (k >= 'A' && k <= 'Z') counts[k-'A']++;
   }
   
   /*
    *  ... and this is the sorting part.
    */
   for (i=0;i<26;i++) order1[i] = i;
   n1 = 26;
   while ((n1 = n1 / 2))
   {
      n2 = 26 - n1;
      for (i=0; i<n2; i++)
      {
         j = i;
         do
         {
            k = j + n1;
            /* compare data[j] to data[k] */
            ix1 = order1[j];
            ix2 = order1[k];
            cnt1 = counts[ix1];
            cnt2 = counts[ix2];
            if (cnt1 > cnt2) break;
            if (cnt1 < cnt2) goto swap;
            if (ix1 < ix2) break;
         swap: /* if data[j] > data[k] */
            order1[j] = ix2;
            order1[k] = ix1;
         }
         while ((j = j - n1) >= 0);
      }       
   }
}  /* end of 'sort1()' */

void go_solve_clicked (GtkWidget *widget, gpointer data)
{
   switch_to_solve();
   
} /* end of go_solve_clicked() */

void go_edit_clicked (GtkWidget *widget, gpointer data)
{
   switch_to_edit();
   
} /* end of go_edit_clicked() */

/*
 *  If we enter a menubar while dragging a letter, forget about dragging
 */
gboolean cpt4_enter_event (GtkWidget *w, GdkEventCrossing *e, gpointer d)
{
/* static int count=0;                             */
/* count++;                                        */
/* printf("In 'cpt4_enter_event() # %d'\n",count); */
   if (drag_character) {
      gdk_window_set_cursor(main_window->window, cursor1);
      drag_character = 0;
   }
   return FALSE;
} /* end of cpt4_enter_event() */

gboolean main_enter_event (GtkWidget *w, GdkEventCrossing *e, gpointer d)
{
   /*
   printf("In 'main_enter_event()'\n");
   printf("main_enter_event event->type = %d \n",e->type);
   */
   return FALSE;
} /* end of main_enter_event() */

/*
 *  If we leave the main window while dragging a letter, forget about dragging
 */
gboolean cpt4_leave_event (GtkWidget *w, GdkEventCrossing *e, gpointer d)
{
   int x,y;
   
/* printf("In cpt4_leave_event handler.\n"); */
   x = (int)e->x;
   y = (int)e->y;
   if ((x < 0) || (y < 0)
               || (x >= main_window->allocation.width)
               || (y >= main_window->allocation.height)) {
      if (drag_character) {
         gdk_window_set_cursor(main_window->window, cursor1);
         drag_character = 0;
      }
   }
   return FALSE;
} /* end of cpt4_leave_event() */

/*
 *  Return the index to the puzzle character corresponding to a mouse
 *  position, using a box covering both the cipher and plaintext
 *  character locations.
 * 
 *  Returns -1 if the mouse position is out of the puzzle area.
 */
int pair_index(int x, int y)
{
   int n,d;
   int px,py;
   int y1,dy;
   int row,col;
   
   px = puzzle_da->allocation.x;
   py = puzzle_da->allocation.y;
   
   if ((y < py) || (y >= (py+puzzle_da_height)) ||
       (x < px) || (x >= (px+puzzle_da_width ))   ) return -1;
      
   y1 = py + TEXT_BORDER
           + 2*charset_ink_height + TEXT_ROW_GAP
           + (TEXT_ROW_GAP + PZT_ROW_EXTRA_GAP)/2;
   dy  = 2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP;
   row = (y - (y1 - dy)) / dy;
   if (row <             0 ) row = 0;
   if (row > (PZT_ROWS - 1)) row = PZT_ROWS - 1;
   
   n = x - (px + TEXT_BORDER);
   d = charset_ink_width + TEXT_COL_GAP;
   if ((n % d) >= charset_ink_width) return -1;
   col = n / d;
   if (col > (PZT_COLS - 1)) col = PZT_COLS - 1;
   
   return row*PZT_COLS + col;
 
} /* end of pair_index() */

/*
 *  If the specified cursor position is over a plaintext character in
 *  puzzle area that corresponds to a ciphertext character 'A' - 'Z',
 *  return the index of the ciphertext character in the puzzle array.
 * 
 *  Returns -1 if the cursor is not over such a character.
 */
int puzzle_alpha_plain_index(int x, int y)
{
   int n,d;
   int c,i;
   int px,py;
   int y0,y1,dy;
   int row,col;
   
   px = puzzle_da->allocation.x;
   py = puzzle_da->allocation.y;
   
   if ((y < py) || (y >= (py+puzzle_da_height)) ||
       (x < px) || (x >= (px+puzzle_da_width ))   ) return -1;
      
   y0 = py + TEXT_BORDER + charset_ink_height + TEXT_ROW_GAP;
   y1 = y0 + charset_ink_height;
   dy  = 2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP;
   for (row=0;row<PZT_ROWS;row++) {
      if ((y >= y0) && (y < y1)) break;
      y0 += dy;
      y1 += dy;
   }
   if (row == PZT_ROWS) return -1;
   
   n = x - (px + TEXT_BORDER);
   d = charset_ink_width + TEXT_COL_GAP;
   if ((n % d) >= charset_ink_width) return -1;
   col = n / d;
   if (col > (PZT_COLS - 1)) col = PZT_COLS - 1;
      
   i = row*PZT_COLS + col;
   c = ciphertext[i];
   if ((c >= 'A') && (c <= 'Z')) return i;
   return -1;
     
} /* end of puzzle_alpha_plain_index() */

/*
 *  Assign the next free plaintext letter to ciphertext letter at 'index'.
 */
void assign_next_free(int index)
{
   int c,i,k;
   int c0;
   
   k = ciphertext[index];
   if ((k < 'A') || (k > 'Z')) return;
   for (i=0;i<26;i++) freetab[i] = 'A'+i;
   for (i=0;i<26;i++) {
      c = xlat[i];
      if ((c >= 'A') && (c <= 'Z')) freetab[c-'A'] = 0;
   }
   freecnt = 0;
   for (i=0;i<26;i++) if ((c = freetab[i])) freetab[freecnt++] = c;
   if (freecnt == 0) return;
   
   c0 = xlat[k-'A'];
   if ((c0 < 'A') || (c0 >  'Z') || (c0 >= freetab[freecnt-1]))
      c = freetab[0];
   else {
      for (i=0;i<freecnt;i++) if (c0 < freetab[i]) break;
      c = freetab[i];
   }
   assign (k,c);
   
} /* assign_next_free() */

/*
 *  Assign the next plaintext letter that is not assigned to a 
 *  ciphertext letter in the current word to the ciphertext character
 *  at 'index'.
 */
void assign_next_not_in_word(int index)
{
   int c,c0,i,j,k,m,n;
   
   k = ciphertext[index];
   if ((k < 'A') || (k > 'Z')) return;
   m = PZT_COLS*(index/PZT_COLS)-1;
   i = index;
   while (--i>m) {
      c = ciphertext[i];
      if ((c < 'A') || (c > 'Z')) break;
   }
   i++; /* 1st character of word */
   m = m+81;
   j = index;
   while (++j<m) {
      c = ciphertext[j];
      if ((c < 'A') || (c > 'Z')) break;
   }
   j--; /* last character of word */
   for (n=0;n<26;n++) freetab[n] = 'A'+n;
   for (n=i;n<=j;n++) {
      c = xlat[ciphertext[n]-'A'];
      if ((c >= 'A') && (c <= 'Z')) freetab[c-'A'] = 0;
   }
   freecnt = 0;
   for (i=0;i<26;i++) if ((c = freetab[i])) freetab[freecnt++] = c;
   if (freecnt == 0) return;
   
   c0 = xlat[k-'A'];
   if ((c0 < 'A') || (c0 >  'Z') || (c0 >= freetab[freecnt-1]))
      c = freetab[0];
   else {
      for (i=0;i<freecnt;i++) if (c0 < freetab[i]) break;
      c = freetab[i];
   }
   assign(k,c);
   return;
   
} /* assign_next_not_in_word() */

/*
 *  Update the solution display
 */
void usolu(void)
{
   int i;
   
   draw_puzzle();
   draw_alphabet();   
   for (i=0;i<FQT_DA_COUNT;i++) draw_frequencies(i);
   return;
   
} /* end of usolu() */

/* 
 *  Assign a plaintext letter to a ciphertext letter.
 */
void assign (int cipherchar, int plainchar)
{
   /*
    * 'xlat[]' is indexed by cipher characters, and
    *  its contents are the plaintext characters corresponding
    *  to the indexing cipher characters.
    * 
    *  'last_orphan' is the cipher character that had its corresponding
    *                plaintext character unassigned during the last 
    *                substitution, or -1 if there was no such character.
    *                
    * 
    *  'last_freed' is the plaintext character that became unassigned from
    *               some cipher character during the last substitution, 
    *               or -1 if there was no such character.
    */
   int c,i;
   int cix,old_cix;

   if ((cipherchar < 'A') || (cipherchar > 'Z')) return;
   if (( plainchar < 'A') || ( plainchar > 'Z')) return;
   
   cix = cipherchar - 'A';
   for (old_cix=0;old_cix<26;old_cix++) if (xlat[old_cix] == plainchar) break;
   if (old_cix == cix) return; /* plainchar is already assigned to cipherchar */
   
   /*
    *  Save the undo data
    */
   i = undo_solution_first + undo_solution_count - redo_solution_count;
   if (i >= UNDO_ARRAY_SIZE) i -= UNDO_ARRAY_SIZE;
#if (UNDO_DEBUG)
   g_print("assign: storing in slot %d\n",i);
#endif
   memcpy(undo_solution[i],xlat,26);
   undo_solution_count += 1 - redo_solution_count;
   if (undo_solution_count > UNDO_ARRAY_SIZE) {
      undo_solution_count  = UNDO_ARRAY_SIZE;
      undo_solution_first++;
      if (undo_solution_first >= UNDO_ARRAY_SIZE) undo_solution_first = 0;
   }
      
   redo_solution_count = 0;
   gtk_widget_set_sensitive (button_undo, 1);
   gtk_widget_set_sensitive (button_redo, 0);
   
   
   if (old_cix == 26) {
      /*
       *  'plainchar' wasn't assigned before
       */
      last_orphan = -1;
   }
   else {
      xlat[old_cix] = MCHAR_PSEUDO_ASCII;
      last_orphan = old_cix+'A';
   }
   
   c = xlat[cix];
   if ((c >= 'A') && (c <= 'Z')) last_freed = c;
   else                          last_freed = -1;

   if ((last_freed != -1) && (last_orphan != -1))
      gtk_widget_set_sensitive (button_complete_swap, 1);
   else
      gtk_widget_set_sensitive (button_complete_swap, 0);
     
   xlat[cix] = plainchar;
   
   usolu();
   return;
   
} /* end of assign() */

/*
 *  Process keystrokes in solve mode
 */
void cpt_solve(int key)
{
   int c,k;
   
   k = key;
   if ((k >= 'a') && (k <= 'z')) k += ('A' - 'a');
   if ((k >= 'A') && (k <= 'Z')) {
      c = ciphertext[solve_mode_charno];
      if ((c >= 'A') && (c <= 'Z')) assign(c,k);
      return;
   }

   if (key == XK_Left     ) goto leftkey;
   if (key == XK_Right    ) goto rightkey;
   if (key == XK_Up       ) goto uparrow;
   if (key == XK_Down     ) goto downarrow;
   if (key == XK_Home     ) goto homekey;
   if (key == XK_End      ) goto endkey;
   goto just_return;
   
homekey:
   if (cursed) un_curse();
   solve_mode_charno = 0;
   goto position_cur;
   
endkey:
   if (cursed) un_curse();
   solve_mode_charno = PZT_LENGTH-1;
   goto position_cur;

uparrow:
   if (cursed) un_curse();
   if (solve_mode_charno > (PZT_COLS - 1)) solve_mode_charno -= PZT_COLS;
   goto position_cur;

downarrow:
   if (cursed) un_curse();
   if (solve_mode_charno < PZT_LENGTH-PZT_COLS) solve_mode_charno += PZT_COLS;
   goto position_cur;

leftkey:
   if (cursed) un_curse();
   if ((solve_mode_charno%PZT_COLS) > 0) solve_mode_charno--;
   goto position_cur;

rightkey:
   if (cursed) un_curse();
   if ((solve_mode_charno%PZT_COLS) < (PZT_COLS - 1)) solve_mode_charno++;
   goto position_cur;
   
position_cur:
   poscursor(solve_mode_charno);
   
just_return:
   return;

}  /* end of cpt_solve() */

/*
 *  Fill the ciphertext alphabet string as per xlat[].
 */
void fill_alphabet_cipher(void)
{
   
   int  c,i;
   unsigned char *cp;
   
   cp = alphabet_cipher + (sizeof(alphabet_cipher) - 1) - 26;

   memset(cp,MCHAR_PSEUDO_ASCII,26);
   for (i=0;i<26;i++) if ((c=xlat[i]) != MCHAR_PSEUDO_ASCII) *(cp + (c-'A')) = (i + 'A');
   
} /* end of fill_alphabet_cipher() */

/*
 *  Draw the alphabet area
 */
void draw_alphabet(void)
{
   int x,y;

   /* 
    *  Get the set of cipher text that currently corresponds to the
    *  plaintext alphabet. The "mask character" will be used where
    *  there is no current corresponding plaintext character.
    */
   fill_alphabet_cipher();
   
   /*
    * clear the alphabet drawing area.
    */
   gdk_draw_rectangle(alphabet_da->window,
                      puzzle_background_gc,TRUE, /* filled */
                      0,0,alphabet_da_width,alphabet_da_height);

   x = 0;
   y = 0;
   cpt_draw_text(alphabet_da->window,x,y,0,alphabet_cipher,-1);
   y += charset_ink_height + TEXT_ROW_GAP;
   cpt_draw_text(alphabet_da->window,x,y,1,alphabet_plain,-1);
   
} /* end of draw_alphabet() */

/*
 *  If the specified cursor position is over a character 'A' - 'Z' in
 *  the alphabet, puzzle, or frequency area, return the character;
 *  otherwise, return -1.
 */
int what_alpha(int x, int y)
{
   int c,i;
   int n,d;
   int px,py;
   int x0,x1;
   int y0,y1,y2,y3,dy;
   int row,col;
   
   px = puzzle_da->allocation.x;
   py = puzzle_da->allocation.y;
   
   if ((y < py) || (y >= (py+puzzle_da_height)) ||
       (x < px) || (x >= (px+puzzle_da_width ))   ) goto try_alphabet;
      
   x0 = px + TEXT_BORDER;
   x1 = x0 + PZT_COLS * (charset_ink_width + TEXT_COL_GAP);
   if ((x < x0) || (x >= x1)) return -1;
   n = x - x0;
   d = charset_ink_width + TEXT_COL_GAP;
   if ((n % d) >= charset_ink_width) return -1;
   col = n / d;
   if (col > (PZT_COLS - 1)) return -1;
   
   y0 = py + TEXT_BORDER;
   y1 = y0 + charset_ink_height;
   y2 = y1 + TEXT_COL_GAP;
   y3 = y2 + charset_ink_height;
   dy  = 2*(charset_ink_height + TEXT_ROW_GAP) + PZT_ROW_EXTRA_GAP;
   for (row=0;row<PZT_ROWS;row++) {
      if ((y >= y0) && (y < y1)) goto puzzle_cipher;
      if ((y >= y2) && (y < y3)) goto puzzle_plain;
      y0 += dy;
      y1 += dy;
      y2 += dy;
      y3 += dy;
   }
   return -1;
   
puzzle_cipher:
   c = ciphertext[row*PZT_COLS+col];
   if ((c < 'A') || (c > 'Z')) return -1;
   return c;
   
puzzle_plain:
   c = ciphertext[row*PZT_COLS+col];
   if ((c < 'A') || (c > 'Z')) return -1;
   c = xlat[c-'A'];
   if ((c < 'A') || (c > 'Z')) return -1;
   return c;

try_alphabet:
   px = alphabet_da->allocation.x;
   py = alphabet_da->allocation.y;
   
   if ((y < py) || (y >= (py+alphabet_da_height)) ||
       (x < px) || (x >= (px+alphabet_da_width ))   ) goto try_frequency;
      
   x0 = px + TEXT_BORDER;
   x1 = x0 + (sizeof(alphabet_cipher)-1) * (charset_ink_width + TEXT_ROW_GAP);
   if ((x < x0) || (x >= x1)) return -1;
   
   n = x - x0;
   d = charset_ink_width + TEXT_COL_GAP;
   if ((n % d) >= charset_ink_width) return -1;
   col = n / d;
   if (col > (sizeof(alphabet_cipher)-1)) return -1;
   
   y0 = py + TEXT_BORDER;
   y1 = y0 + charset_ink_height;
   if ((y >= y0) && (y < y1)) goto in_alphabet_cipher;
   y0 = y0 + charset_ink_height + TEXT_ROW_GAP;
   y1 = y0 + charset_ink_height;
   if ((y >= y0) && (y < y1)) goto in_alphabet_plain;
   return -1;
   
in_alphabet_plain:
   c = alphabet_plain[col];
   if ((c < 'A') || (c > 'Z')) return -1;
   return c;
   
in_alphabet_cipher:
   fill_alphabet_cipher();
   c = alphabet_cipher[col];
   if ((c < 'A') || (c > 'Z')) return -1;
   return c;
   
try_frequency:
   py = frequency_da[0]->allocation.y;
   if ((y < py) || (y >= (py+frequency_da_height))) return -1;
   y0 = py + (TEXT_BORDER - 1);
   y1 = y0 + charset_ink_height;
   for (row=0;row<FQT_ROWS;row++) {
      if ((y >= y0) && (y < y1)) break;
      y0 = y0 + charset_ink_height + TEXT_ROW_GAP;
      y1 = y0 + charset_ink_height;
   }
   if (row == FQT_ROWS) return -1;
   
   for (i=0;i<FQT_DA_COUNT;i++) {
      x0 = frequency_da[i]->allocation.x + TEXT_BORDER - 1;
      if (i > 0) x0 += FQT_SEP_EXTRA_GAP;
      x1 = x0 + charset_ink_width;
      if ((x >= x0) && (x < x1)) goto frequency_cipher;
      x0 += (charset_ink_width + 1) + FQT_COL_EXTRA_GAP;
      x1 += (charset_ink_width + 1) + FQT_COL_EXTRA_GAP;
      if ((x >= x0) && (x < x1)) goto frequency_plain;
   }
   return -1;
   
frequency_cipher:
   i = i*FQT_ROWS + row;
   if (i > 25) return -1;
   c = order1[i] + 'A';
   return c;
   
frequency_plain:
   i = i*FQT_ROWS + row;
   if (i > 25) return -1;
   c = xlat[order1[i]];
   if ((c < 'A') || (c > 'Z')) return -1;
   return c;
     
} /* end of what_alpha() */

/*
 *  If the specified cursor position is over a plaintext character in
 *  frequency area that corresponds to a ciphertext character with a
 *  non-zero occurance count, return the corresponding ciphertext character.
 * 
 *  Returns -1 if the cursor is not over such a character.
 */
int frequency_substitution_target(int x, int y)
{
   int c,i;
   int row,py;
   int x0,x1,y0,y1;
   
   py = frequency_da[0]->allocation.y;
   if ((y < py) || (y >= (py+frequency_da_height))) return -1;
   y0 = py + (TEXT_BORDER - 1);
   y1 = y0 + charset_ink_height;
   for (row=0;row<FQT_ROWS;row++) {
      if ((y >= y0) && (y < y1)) break;
      y0 = y0 + charset_ink_height + TEXT_ROW_GAP;
      y1 = y0 + charset_ink_height;
   }
   if (row == FQT_ROWS) return -1;
   
   for (i=0;i<FQT_DA_COUNT;i++) {
      x0 = frequency_da[i]->allocation.x + TEXT_BORDER - 1;
      if (i > 0) x0 += FQT_SEP_EXTRA_GAP;
      x0 += (charset_ink_width + 1) + FQT_COL_EXTRA_GAP;
      x1 = x0 + charset_ink_width;
      if ((x >= x0) && (x < x1)) goto frequency_plain;
   }
   return -1;
   
frequency_plain:
   i = i*FQT_ROWS + row;
   if (i > 25) return -1;
   c = order1[i];
   if (counts[c] < 1) return -1;
   return c + 'A';
     
} /* end of frequency_substitution_target() */

/*
 *  Open and write an output file. Pop up an error window if not successful,
 *  otherwise destroy the file selector widget.
 */
void process_output_file(GtkWidget *selector, char *filename)
{
   int i;
   FILE *file;
   
   file = fopen(filename,"w");
   if (file == NULL) goto issue_error_msg;
   
   save_filesel_path(filename);
   for (i=0;i<PZT_ROWS;i++) {
      if (fwrite(ciphertext+i*PZT_COLS,1,PZT_COLS,file) != PZT_COLS) goto write_error;
      if (fputc('\n',file) != '\n') goto write_error;
   }
   if (fputs("!!CPT/ECSI!!\n",file) == EOF) goto write_error;
   if (fwrite(xlat,1,26,file) != 26) goto write_error;
   if (fputc('\n',file) != '\n') goto write_error;
   fclose(file);
   edited = 0;
   gtk_widget_destroy(selector);
   return;

write_error:
   fclose(file);
   
issue_error_msg:
   cpt4pmsg(&file_selector_pmsg,
            selector,
            &cpt_emsg_bg_color,         /* message text bg color */
            &main_window->style->black, /* message test fg color */
            "Dismiss",
            "Output File Error ...",
            "Error on output file\nopen or write.",
            NULL);
   return;

} /* end of process_output_file() */

/*
 *  Callback for "overwrite - yes or cancel" dialog buttons 
 */
void overwrite_yc_callback(GtkButton *b, gpointer data)
{
   /*
    * we're done with the dialog window
    */
   gtk_widget_destroy(file_selector_pmsg);
   
   if (data != NULL) {
      /*
       *  We're here because the OK (left) button was clicked
       */
      process_output_file(file_selector, (char *)data);
   }
   return;
   
} /* overwrite_yc_callback() */

/*
 *  Write the word list to the specified FILE pointer, to be processed
 *  by the Hart algorithm. Don't worry about limiting the length, and 
 *  pass along words with embedded apostrophies even though they will
 *  get screened out by 'do_hart()'.
 *
 *  Returns the number of words written.
 */
int write_word_list()
{
   int  c,i,j,k;
   int  word_count=0;
   char *cp0,*cp1,*cp2;
   
   for (i=0;i<PZT_ROWS;i++) {
      cp0 = (char *)(ciphertext+PZT_COLS*i);
      cp2 = cp0+PZT_COLS;
      
      /*
       *  Find the start of a word, an alphabetic
       */
   loop1:
      if (cp0 >= cp2) continue;
      c = *cp0;
      if ((c < 'A') || (c > 'Z')) { 
         cp0++;
         goto loop1;
      }
      
      /* 
       *  Find the end of the word, and note imbedded apostrophes
       */
      k = 0;   /* apostrophe counter */
      cp1 = cp0;
   loop2:
      if (cp1 >= cp2) goto end_of_word1;
      c = *cp1;
      if ((c >= 'A') && (c <= 'Z')) {
         cp1++;
         goto loop2;
      }
      if (c == '\'') {
         k++;
         cp1++;
         goto loop2;
      }
      goto end_of_word2;
   
      /*
       *  A word terminated by end-of-line
       */
   end_of_word1:
      j = cp1 - cp0;       /* j = number of characters in the word */
      while (k > 0) {
         if (*(cp1-1) != '\'') break;
         cp1--;
         j--; 
      }
      putmsg2(out_pipe,cp0,j);
      word_count++;
      continue;
      
      /*
       *  A word terminated by a (non-alphabetic, non apostrophe);
       */
   end_of_word2:
      j = cp1 - cp0;       /* j = number of characters in the word */
      while (k > 0) {
         if (*(cp1-1) != '\'') break;
         cp1--;
         j--; 
      }
      putmsg2(out_pipe,cp0,j);
      word_count++;
      
      cp0 = cp1;
      goto loop1;
   }
   putmsg(out_pipe,"!EOL");
   return word_count;
   
} /* end of write_word_list() */

/*
 *  Write a message to the output pipe. Adds the byte count on to the
 *  beginning and a newline character to the end.
 */
void putmsg(int pipe, char *msg)
{
   int n;
   char buff[128];
   
   n = strlen(msg);
   if (n > 125) {
      g_print("WARNING: cpt4 putmsg() charcnt = %d\n",n);
      return;
   }
   sprintf(buff,"%02d",n+1);
   memcpy(buff+2,msg,n);
   buff[n+2] = '\n';
   write (pipe,buff,n+3);
#if (HART_DEBUG)
   g_print("cpt4: sent %d char msg: '%s'\n",n,msg);
#endif   

} /* end of putmsg() */

/*
 *  Write a message to the output pipe. Adds the byte count on to the
 *  beginning and a newline character to the end.
 */
void putmsg2(int pipe, char *msg, int charcnt)
{
   char buff[128];

   if (charcnt > 125) {
      g_print("WARNING: cpt4 putmsg2() charcnt = %d\n",charcnt);
      return;
   }
   sprintf(buff,"%02d",charcnt+1);
   memcpy(buff+2,msg,charcnt);
   buff[charcnt+2] = '\n';
   write (pipe,buff,charcnt+3);
#if (HART_DEBUG)
   buff[charcnt+2] = 0;
   g_print("cpt4: sent %d char msg: '%s'\n",charcnt,buff+2);
#endif   

} /* end of putmsg2() */

/*
 *  Read a message from the input pipe, stripping the byte count and
 *  newline character and adding a terminal NULL.
 * 
 *  Returns the actual message length, or ZERO if something bad happened.
 */
int getmsg(int pipe, char *buf, int bufsize)
{
   int c,m,n;
   char length[2];
   GIOStatus s;
   GError *e=NULL;
   
   s = g_io_channel_read_chars(hart_input_channel, length, 2, &m, &e);
   
   if (s != G_IO_STATUS_NORMAL) {
#if (HART_DEBUG > 1)   
      g_print("(s != G_IO_STATUS_NORMAL) in 'cpt4' getmsg().\n");
#endif
     goto something_bad;
   }
   
   if (m != 2) {
#if (HART_DEBUG > 1)   
      g_print("(m != 2) in 'cpt4' getmsg().\n");
#endif
     goto something_bad;
   }
   
   c = length[0];
   if ((c < '0') || (c > '9')) {
#if (HART_DEBUG > 1)   
      g_print("1st digit of incoming message length = 0x%02X in 'cpt4'\n",c);
#endif
     goto something_bad;
   }
   n = (c - '0')*10;
   c = length[1];
   if ((c < '0') || (c > '9')) {
#if (HART_DEBUG > 1)   
      g_print("2nd digit of incoming message length = 0x%02X in 'cpt4'\n",c);
#endif
      goto something_bad;
   }
   n += (c - '0');
   if ((n < 2) || (n > bufsize)) {
#if (HART_DEBUG > 1)   
      g_print("Bad message size = %d 'cpt4'\n",n);
#endif
      goto something_bad;
   }
   
   s = g_io_channel_read_chars(hart_input_channel, buf, n, &m, &e);
   
   if (s != G_IO_STATUS_NORMAL) {
#if (HART_DEBUG > 1)   
      g_print("(s != G_IO_STATUS_NORMAL) in 'cpt4' getmsg().\n");
#endif
     goto something_bad;
   }
   
   if (m != n) {
#if (HART_DEBUG > 1)
      g_print("Expected %d, got %d characters in 'cpt4'\n",n,m);
      for (c=0;c<m;c++) g_print("cpt4: char %0d = 0x%02X\n",c,*(buf+c));
#endif
      goto something_bad;
   }
   n--;    
   if (*(buf+n) != '\n') {
#if (HART_DEBUG > 1)   
      g_print("Missing newline in 'cpt4'.\n");
#endif
      goto something_bad;
   }
   *(buf+n) = 0;
   return n;
   
something_bad:
   return 0;
   
} /* end of getmsg() */

/*
 *  Start up the auxiliary program 'do_hart' to automatically solve the
 *  puzzle, using fork() and execl() so we can communicate via to sets
 *  anonymous pipes (AKA fifo's). Once we get the pipes set up, we fork()
 *  and the new process execl()'s 'do_hart' with the file descriptors of
 *  the pipes  to be use for input and output as command line parameters.
 *
 *  Communication between 'cpt4' and 'do_hart' consists of a series of
 *  messages that are detailed in the comments in 'do_hart.c'; the general
 *  idea is that we break the puzzle into words and send then out through
 *  the first pipe set and read solution permutations back from the second
 *  pipe set.
 * 
 */
void do_hart_clicked (GtkWidget *widget, gpointer data)
{
   int n;
   char hart_in_pipe[16];
   char hart_out_pipe[16];
   char hart_path[256];
   GtkAllocation *a;
   
   if (hart_in_progress) return;
   
   hart_in_progress = 1;
   hart_solution_count = 0;
   gtk_widget_set_sensitive (button_other_hart, 0);
   if (pipe(pipe_set_a) != 0) return;
   if (pipe(pipe_set_b) != 0) {
      close (pipe_set_a[0]);
      close (pipe_set_a[1]);
      hart_in_progress = 0;
      return;
   }
   in_pipe  = pipe_set_a[0];
   out_pipe = pipe_set_b[1];
   
   /*
    *  All systems seem to be GO. If we got called from edit mode, switch
    *  to solve mode before we get started. Save just the current solution
    *  for the undo logic.
    */
   if (editmode) switch_to_solve();
   maybe_save_xlat();
   
   do_hart_pid = fork();
   if (do_hart_pid == -1) {
      close (pipe_set_a[0]);
      close (pipe_set_a[1]);
      close (pipe_set_b[0]);
      close (pipe_set_b[1]);
      hart_in_progress = 0;
      return;
   }
    
   if (do_hart_pid == 0) {
      /*
       *  We're the new process, so we execl() the 'do_hart' executable.
       *  First we'll try using just the executable name, and if that 
       *  doesn't work we'll try tacking on our own executable path.
       */
      sprintf(hart_in_pipe,"%d",pipe_set_b[0]);
      sprintf(hart_out_pipe,"%d",pipe_set_a[1]);
      execl("do_hart", "do_hart", hart_in_pipe, hart_out_pipe, NULL);
      
      /*
       *  If we get back here, the exec() didn't work.
       */
      get_our_path(hart_path,256-strlen("do_hart"));
      strcat(hart_path,"do_hart");
      execl(hart_path, hart_path, hart_in_pipe, hart_out_pipe, NULL);
      
      g_print("The exec() of 'do_hart' didn't work!\n");
      /*
       *  Should go something better here ...
       */
      exit(1);
   }
   
   /*
    *  We're the original process
    */
   n = write_word_list();
   if (n < 1) {
      /*
       *  Nothing to solve; 'do_hart' will exit, so wait for it
       *  to exit in order to flush the defunct child process.
       */
      hart_in_progress = 0;
      waitpid(-1, NULL, 0);
      return;
   }

   /*
    *  Create a GIOChannel for the pipe that we are using to
    *  read input from the 'do_hart' process; the current GTK
    *  uses glib GIOChannels for I/O callback functionality.
    * 
    *  The GIOChannel will be  created with a reference count
    *  of one ...
    */
   hart_input_channel = g_io_channel_unix_new(in_pipe);
   
   /*
    *  Connect up a callback for messages back from 'do_hart'.
    * 
    *  This adds one the the GIOChannel reference count.
    */
   pipe_watch_id = g_io_add_watch(hart_input_channel, G_IO_IN,
                                  (GIOFunc) pipe_input_ready, NULL);
   
   /*
    *  Hack to start up the advisory window in the button area
    *  instead of over the puzzle. 'None' is defined in 'X.h', which
    *  is included by 'Xlib.h'.
    */
   a = &buttons_area_fixed->allocation;
/* XWarpPointer(GDK_WINDOW_XDISPLAY(main_window->window),None,   */
/*              GDK_WINDOW_XWINDOW(main_window->window),0,0,0,0, */
   XWarpPointer(gdk_x11_drawable_get_xdisplay(main_window->window),None,
                GDK_WINDOW_XID(main_window->window),0,0,0,0,
                a->x + a->width/2,    /* x */
                a->y + a->height/2);  /* y */

   cpt4pmsg(&hart_active_pmsg,
            main_window,
            &cpt_help_bg_color,         /* message text bg color */
            &main_window->style->black, /* message test fg color */
            "Abort",
            "Hart solution in progress ...",
            "Calculating solution ...\nHit Abort to return\nto manual mode",
            hart_abort);
   
} /* end of do_hart_clicked() */

/*
 *  Executed when we get a message from 'do_hart'.
 */
gboolean pipe_input_ready(GIOChannel source,
                          GIOCondition condition,
                          gpointer data)
{
   int c,i,n;
   char buff[80];
   char *cp;
   
   n = getmsg(in_pipe, buff, 80);
#if (HART_DEBUG)
   g_print("cpt4: received %d char msg: '%s'\n",n,buff);
#endif   
   if (n == 35) goto maybe_a_solution;
   if (n !=  5) goto bad_message;
   
   if (strcmp(buff,"!DONE") != 0) goto bad_message;
   close(in_pipe);
   close(out_pipe);
   g_io_channel_unref(hart_input_channel); /* the add_watch reference */
#if 0
   g_io_channel_unref(hart_input_channel); /* the unix_new  reference */
#endif
   hart_in_progress = 0;
   if (hart_solution_count > 1) { 
      other_hart_index = (hart_solution_count - 2) % HART_ARRAY_SIZE;
      gtk_widget_set_sensitive (button_other_hart, 1);
   }
   
   gtk_input_remove(pipe_watch_id);
   if (hart_active_pmsg != NULL) {
      gtk_widget_destroy(hart_active_pmsg);
      hart_active_pmsg = NULL;
   }
   waitpid(-1, NULL, 0);                   
   return TRUE;
   
maybe_a_solution:
   if (buff[0] != '!') goto bad_message;
   if (buff[1] != 'C') goto bad_message;
   if (buff[2] != '=') goto bad_message;
   if (buff[6] != ',') goto bad_message;
   if (buff[7] != 'P') goto bad_message;
   if (buff[8] != '=') goto bad_message;
   putmsg(out_pipe,"!OK");
   
   cp = buff+9;
   for (i=0;i<26;i++) {
      c = *cp++;
      if ((c < 'A') || (c > 'Z')) c = MCHAR_PSEUDO_ASCII;
      xlat[i] = c;
   }
   i = hart_solution_count % HART_ARRAY_SIZE;
   memcpy(hart_solutions[i],xlat,26);
   hart_solution_count++;
   usolu();
   return TRUE;
   
bad_message:
   close(in_pipe);
   close(out_pipe);
   g_io_channel_unref(hart_input_channel);
#if 0
   g_io_channel_unref(hart_input_channel);
#endif
   hart_in_progress = 0;
   hart_solution_count = 0;
   gtk_widget_set_sensitive (button_other_hart, 0);
   return TRUE;
   
} /* end of pipe_input_ready() */

void erase_all_clicked (GtkWidget *widget, gpointer data)
{
   int i;
   
   memset(ciphertext,' ',PZT_LENGTH);
   maybe_save_xlat();
   memset(xlat,MCHAR_PSEUDO_ASCII,26);
   last_freed = last_orphan = -1;
   draw_alphabet();   
   if (cursed) un_curse();
   draw_puzzle();
   for (i=0;i<FQT_DA_COUNT;i++) draw_frequencies(i);
   edit_mode_charno=0;
   solve_mode_charno=0;
   return;
   
} /* end of erase_all_clicked() */

void erase_solution_clicked (GtkWidget *widget, gpointer data)
{
   int i;
   
   maybe_save_xlat();
   memset(xlat,MCHAR_PSEUDO_ASCII,26);
   draw_alphabet();   
   if (cursed) un_curse();
   draw_puzzle();
   for (i=0;i<FQT_DA_COUNT;i++) draw_frequencies(i);
   return;
   
} /* end of erase_all_clicked() */

void other_hart_clicked (GtkWidget *widget, gpointer data)
{
   
   if (hart_solution_count < 2) return;
   
   memcpy(xlat,hart_solutions[other_hart_index],26);
   other_hart_index--;
   if (other_hart_index < 0) {
      if (hart_solution_count < HART_ARRAY_SIZE)
         other_hart_index = (hart_solution_count - 1) % HART_ARRAY_SIZE;
      else
         other_hart_index = HART_ARRAY_SIZE - 1;
   }
   usolu();
   return;
   
} /* end of other_hart_clicked() */

/*
 *  Called from the hart-in-progress popup window's abort button clicked
 *  callback routine.
 */
void hart_abort(void)
{
   int n;
   
   close(in_pipe);
   close(out_pipe);
   hart_in_progress = 0;
   if (hart_solution_count > 1) { 
      other_hart_index = (hart_solution_count - 2) % HART_ARRAY_SIZE;
      gtk_widget_set_sensitive (button_other_hart, 1);
   }
   gtk_input_remove(pipe_watch_id);
   n = kill(do_hart_pid,SIGKILL);
   waitpid(-1, NULL, 0);                   
   return;
   
} /* end of hart_abort() */

/***********************************************************
|  initialize pseudo random bit generator
***********************************************************/
void ibg(void)
{

   static struct timeval t0,t1;
   int i,m0,m1;
   
   gettimeofday(&t0,NULL);
   do {
      regA = rand();
      gettimeofday(&t1,NULL);
   } while (t1.tv_sec == t0.tv_sec);
   
   m0 = 0x80000000;
   m1 = 0x00000001;
   for (i=0;i<16;i++) { 
      regC = regC << 2;
      if (t0.tv_sec & m0) regC |= 1;
      if (t0.tv_sec & m1) regC |= 2;
      m0 >>= 1;
      m1 <<= 1;
   }
   
   regB = (unsigned long) 0x33333333
        ^ regC<<2;
   
    return;

} /* end of ibg() */

/***********************************************************
|  get next pseudo random bit
|
|     Code extracted from Dr. Dobbs Journal,
|     February 1992,  page 38.  The sequence
|     of bits is supposed to start repeating
|     only after 10**27 bits.
|
|     Note: the original Dr. Dobbs text had
|     two errors, corrected below!
|
***********************************************************/
int nrb(void)
{
    regA = ((((regA>>31)^(regA>>6)^(regA>>4)^(regA>>2)^(regA>>1)^regA)
           & 0x00000001)<<31) | (regA>>1);
    regB = ((((regB>>30)^(regB>>2)) & 0x00000001)<<30) | (regB>>1);
    regC = ((((regC>>28)^(regC>>1)) & 0x00000001)<<28) | (regC>>1);

    /* return ((regA & regB) | (!regA & regC)) & 0x00000001; SIC! */

    if (regA & 1)
       return regB & 1;
    else
       return regC & 1;

} /* end of nrn() */

void menu_encrypt (GtkWidget *widget, gpointer data) 
{
   int c,i,j,k,n;
   int used[26];
   
   for (i=0;i<26;i++) used[i] = 0;
   ibg(); /* initialize random bit generator */
   for (i=0;i<20;i++) {
     n = 0;
     for (j=0;j<5;j++) n = n + n + nrb();
     k = n + 15;
     for (j=0;j<k;j++) nrb();
   }
   for (i=0;i<26;i++) {
      do {
         n = 0;
         for (j=0;j<5;j++) n = n + n + nrb();
      } while ((n>25) || (n == i) || used[n]);
      xlat[i] = 'A'+ n;
      used[n] = 1;
      if (i == 23) {             /* only 'y' and 'z' left to assign  */
         if (used[25]) continue; /* all is ok if 'z' is already used */
         for (j=0;j<26;j++) if (!used[j]) break;
         xlat[24] = 'Z';
         xlat[25] = 'A'+j;
         break;
      }
   }
   for (i=0;i<PZT_LENGTH;i++) {
      c = ciphertext[i];
      if (c >= 'a' && c <= 'z') c += 'A'-'a';
      if (c >= 'A' && c <= 'Z') ciphertext[i] = xlat[c-'A'];
   }
   memset(xlat,MCHAR_PSEUDO_ASCII,26);
   last_freed = last_orphan = -1;
   draw_alphabet();   
   if (cursed) un_curse();
   draw_puzzle();
   for (i=0;i<FQT_DA_COUNT;i++) draw_frequencies(i);
   
   return;
   
} /* end of menu_encrypt() */

/*
 *  Switch to solve mode from edit mode
 */
void switch_to_solve (void)
{
   int i,s;
   
   if (cursed) un_curse();
   gtk_window_set_title(GTK_WINDOW (main_window), solve_mode_title);
   editmode = 0;
   draw_alphabet();
   draw_puzzle();
   sort1();
   for (i=0;i<FQT_DA_COUNT;i++) draw_frequencies(i);
   gtk_widget_hide ( edit_buttons_vbox);
   gtk_widget_show (solve_buttons_vbox);
   gtk_widget_set_sensitive (encrypt_item,0);
   gtk_widget_set_sensitive (erase_puzzle_item,0);
   gtk_widget_set_sensitive (erase_solution_item,1);
   s =((undo_solution_count - redo_solution_count) > 0);
   gtk_widget_set_sensitive (button_undo, s);
   s =(redo_solution_count > 0);
   gtk_widget_set_sensitive (button_redo, s);
   s = ((last_orphan != -1) && (last_freed != -1));
   gtk_widget_set_sensitive (button_complete_swap, s);
   poscursor(solve_mode_charno);
   
} /* end of switch_to_solve() */

/*
 *  Switch to edit mode from solve mode
 */
void switch_to_edit (void)
{
   int i;
   
   if (cursed) un_curse();
   gtk_window_set_title(GTK_WINDOW (main_window), edit_mode_title);
   editmode = 1;
   draw_alphabet();
   draw_puzzle();
   for (i=0;i<FQT_DA_COUNT;i++) draw_frequencies(i);
   gtk_widget_hide (solve_buttons_vbox);
   gtk_widget_show ( edit_buttons_vbox);
   gtk_widget_set_sensitive (encrypt_item,1);
   gtk_widget_set_sensitive (erase_puzzle_item,1);
   gtk_widget_set_sensitive (erase_solution_item,0);
   
} /* end of switch_to_edit() */

void undo_clicked (GtkWidget *widget, gpointer data) 
{
   int i,n,s;

   if (UNDO_DEBUG) {
      g_print("undo_clicked: start: undo_solution_count = %d\n",undo_solution_count);
      g_print("undo_clicked: start: undo_solution_first = %d\n",undo_solution_first);
      g_print("undo_clicked: start: redo_solution_count = %d\n",redo_solution_count);
   }
   n = undo_solution_count - redo_solution_count;
   if (n < 1) return;
   
   if (redo_solution_count < 1) memcpy(redo_solution,xlat,26);
   
   i = undo_solution_first + n - 1;
   if (i >= UNDO_ARRAY_SIZE) i -= UNDO_ARRAY_SIZE;
   if (UNDO_DEBUG) {
      g_print("undo: restoring from slot %d\n",i);
   }
   memcpy(xlat,undo_solution[i],26);
   redo_solution_count++;
   last_orphan = last_freed = -1;
   gtk_widget_set_sensitive (button_redo, 1);
   gtk_widget_set_sensitive (button_complete_swap, 0);
   s =((undo_solution_count - redo_solution_count) > 0);
   gtk_widget_set_sensitive (button_undo, s);
   
   usolu();
   if (UNDO_DEBUG) {
      g_print("undo_clicked:   end: undo_solution_count = %d\n",undo_solution_count);
      g_print("undo_clicked:   end: undo_solution_first = %d\n",undo_solution_first);
      g_print("undo_clicked:   end: redo_solution_count = %d\n",redo_solution_count);
   }
   
} /* end of undo_clicked() */

void redo_clicked (GtkWidget *widget, gpointer data) 
{
   int i,s;
   
   if (UNDO_DEBUG) {
      g_print("redo_clicked: start: undo_solution_count = %d\n",undo_solution_count);
      g_print("redo_clicked: start: undo_solution_first = %d\n",undo_solution_first);
      g_print("redo_clicked: start: redo_solution_count = %d\n",redo_solution_count);
   }
   if (redo_solution_count <  1) return;
   if (redo_solution_count == 1) {
      memcpy(xlat,redo_solution,26);
   }
   else {
      i = undo_solution_first + undo_solution_count - redo_solution_count + 1;
      if (i >= UNDO_ARRAY_SIZE) i -= UNDO_ARRAY_SIZE;
      memcpy(xlat,undo_solution[i],26);
   }
   redo_solution_count--;
   last_orphan = last_freed = -1;
   s =((undo_solution_count - redo_solution_count) > 0);
   gtk_widget_set_sensitive (button_undo, s);
   s =(redo_solution_count > 0);
   gtk_widget_set_sensitive (button_redo, s);
   gtk_widget_set_sensitive (button_complete_swap, 0);
   
   usolu();
   if (UNDO_DEBUG) {
      g_print("redo_clicked:   end: undo_solution_count = %d\n",undo_solution_count);
      g_print("redo_clicked:   end: undo_solution_first = %d\n",undo_solution_first);
      g_print("redo_clicked:   end: redo_solution_count = %d\n",redo_solution_count);
   }
 
} /* end of redo_clicked() */

void complete_swap_clicked (GtkWidget *widget, gpointer data) 
{

   if ((last_orphan != -1) && (last_freed != -1)) 
      assign (last_orphan,last_freed);
   
} /* end of complete_swap_clicked() */

void next_free_clicked (GtkWidget *widget, gpointer data) 
{
   assign_next_free(solve_mode_charno);
   
} /* end of next_free_clicked() */

void next_not_in_word_clicked (GtkWidget *widget, gpointer data) 
{
   assign_next_not_in_word(solve_mode_charno);
   
} /* end of next_not_in_word_clicked() */

/*
 *  If the current xlat[] table has anything useful in it,
 *  save it as the only undo entry. Otherwise, just delete
 *  any undo data.
 */
void maybe_save_xlat(void)
{
   int c,i;
   
   for (i=0;i<26;i++) {
      c = xlat[i];
      if ((c >= 'A') && (c <= 'Z')) break;
   }
   if (i == 26) { 
      undo_solution_count = 0;
      gtk_widget_set_sensitive (button_undo, 0);
   }
   else {
      memcpy(undo_solution[0],xlat,26);
      undo_solution_count = 1;
      gtk_widget_set_sensitive (button_undo, 1);
   }
   
   undo_solution_first = 0;
   redo_solution_count = 0;
   last_orphan = last_freed = -1;
   gtk_widget_set_sensitive (button_redo, 0);
   gtk_widget_set_sensitive (button_complete_swap, 0);
     
} /* end of maybe_save_xlat() */
   

/*
 *  Get the path to our executable. Note: this code won't work as is
 *  if any names in the path contain spaces or tabs.
 */
void get_our_path(char *path, int maxlength)
{
   int c;
   char tmpstr[32];
   char *cp0,*cp1,*cp2;
   FILE *pipe;
   
   sprintf(tmpstr,"ls -l /proc/%d/exe",getpid());
   pipe = popen(tmpstr,"r");
   if (pipe == NULL) goto unavailable;
   if (fgets(path,maxlength,pipe) == NULL) goto unavailable;
   pclose(pipe);
   
   cp0 = cp1 = cp2 = path;
   while ((c = *cp0++) != 0) {
      if ((c == ' ') || (c == 0x09)) cp1 = cp0; /* space or tab */
      if  (c == '/')                 cp2 = cp0;
   }
   if (*(cp0-2) != '\n') goto unavailable;
   *cp2 = 0;
   cp2 = path;
   do {
      c = *cp1++;
      *cp2++ = c;
   } while (c != 0);
   return;   
   
unavailable:
   *path = 0;
   return;
   
} /* end of find_our_path() */

void save_filesel_path(char *filename_with_path)
{
   int  c,n;
   char *cp,*cp0;
   
   cp = cp0 = filename_with_path;
   while ((c = *cp++) != 0) if (c == '/') cp0 = cp;
   n = cp0 - filename_with_path;
   if ((n > 0) && (n < FILESEL_PATH_SIZE)) {
      memcpy(filesel_path,filename_with_path,n);
      *(filesel_path+n) = 0;
   }
   
}  /* end of save_filesel_path() */

/* 
 *  Draw 'count' chars in our charset font by copying the them indiviually
 *  from the specified section of our charset_pixmap to the destination.
 * 
 *  If 'count' < 1, draws until a zero is encountered in 'text'.
 */
void cpt_draw_text(GdkDrawable *win,    /* destination    */
                   int x,               /* in destination */
                   int y,               /* in destination */
                   int source_section,  /* source section of charset_pixmap */
                   unsigned char *text, /* source string (UNK,MSK,ASCII)    */
                   int count )          /* character count, if > 0          */
{
   int c,k;
   int x0;
   
/*   if (count == 1) printf("drawing ASCII character 0x%02X\n", *text); */
     
   if (count < 1) count = strlen(text);
   x0 = source_section * CSP_4TH_WIDTH;
   for (;count>0;count--) {
      c = *text++;
      k = ascii_to_charset_index[c];
      gdk_draw_drawable(win,
                        cipher_gc,
                        (GdkDrawable *)charset_pixmap,
                        x0 + k * (charset_ink_width + 1),
                        0,
                        x,
                        y,
                        charset_ink_width+2,
                        charset_ink_height+2);
      x += (charset_ink_width + TEXT_COL_GAP);
   }
} /* end of cpt_draw_text() */
